# agent-rtpgw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rtpgw/agent-rtpgw.tcl,v 1.51 2002/02/03 04:29:18 lim Exp $

import rtpgw-encoders

import RTP/Video RTP/Audio Session/RTP/RTPGW \
		SDPParser AnnounceListenManager/AS/Service/MeGa \
		AnnounceListenManager/AS/Client/MeGa CoordinationBus \
		MediaAgent/RTPGW

Class RTPGWAgent
Class RTPGWAgent/Video -superclass { RTPGWAgent RTP/Video }
Class RTPGWAgent/Audio -superclass { RTPGWAgent RTP/Audio }

RTPGWAgent/Video instproc init { app } {
	$self next $app

	$self instvar encoders_ codec_map_
	set encoders_ { h261 }
	set codec_map_ { { jpeg h261 JPEG/DCT DCT/H261 }
			 { h261 h261 H261/Pixel Pixel/H261 }
		       }
#			 { nv h261 nv Pixel/H261 }

	$self alive
}

RTPGWAgent/Audio instproc init { app } {
	$self next $app
	$self instvar encoders_ codec_map_
	set encoders_ { lpc }
	set codec_map_ { { pcm lpc PCM LPC }
			 { pcm gsm PCM GSM }
			 { adpcm lpc ADPCM LPC}
			 { adpcm gsm ADPCM LPC}
		       }

	$self alive
}

RTPGWAgent instproc session_transcoders { sess } {
	$self instvar transcoders_

	set tlist [array names transcoders_ *,$sess]
	set ret {}
	foreach t $tlist {
		lappend ret $transcoders_($t)
	}
	return $ret
}

RTPGWAgent/Video instproc create-session {} {
	set s [new Session/RTP/RTPGW/Video $self]
	$s set ofmt_ h261
	return $s
}

RTPGWAgent/Video instproc create_encoder { type } {
	return [new Module/VideoEncoder/$type]
}

RTPGWAgent/Audio instproc create-session {} {
	set s [new Session/RTP/RTPGW/Audio $self]
	$s set ofmt_ lpc
	return $s
}

RTPGWAgent/Audio instproc create_encoder { type } {
	return [new Module/AudioEncoder/$type]
}

RTPGWAgent instproc add_agent { agentid srcid addr } {
}

RTPGWAgent instproc remove_agent { agentid srcid addr } {
}

RTPGWAgent instproc init { app } {
	$self next
	$self instvar app_ all_active_ srcid_ all_sources_ sessions_
	set all_active_ {}
	set all_sources_ {}
	set sessions_ {}
	set app_ $app
	$self init_confbus

	set srcid_ [alloc_srcid]

	set sspec [$self get_option megaSession]
	$self set sdp_ [new SDPParser]
	if { $sspec != "" } {
		$self init_megactrl $sspec
	} else {
		# Bootstrap initial check
		set rint [$self get_option siteDropTime]
		set rint [expr $rint*1000]
		after $rint "$self check_for_sources"
	}

}

RTPGWAgent instproc init_megactrl { sspec } {
	set megaspec [$self get_option asCtrl]
	set bw [$self get_option asCtrlBW]

	$self instvar gwal_ cliental_ app_
	set name [$app_ set name_]
	if { $name == "vgw" } {
		set media video
		set cls Video
	} else {
		set media audio
		set cls Audio
	}
	set gwal_ [new AnnounceListenManager/AS/Service/MeGa/$cls \
			$self $megaspec $bw $sspec $name $media]

	set megaclient [$self get_option megaClient]
	if { $megaclient != "" } {
		set localbw [$self get_option localSessionBW]
		if { $localbw == "" } {
			set localbw [$self get_option maxSessionBW]
		}
		$self set sessionbw_ $localbw
		set bw [expr 0.02*$localbw]
		set sname [$self get_option megaSession]
		set sspec [$self get_option sessionSpec]
		set rportspec [$self get_option megaRecvPort]
		set ofmt [$self get_option megaFormat]

		set cliental_ [new AnnounceListenManager/AS/Client/MeGa/$cls \
			      	$self $megaclient $bw $name $media \
				$sname $sspec $rportspec $ofmt]
		$cliental_ start
	}
	$self instvar checkInt_
	$self set checkInt_ [$self get_option startupIdleTime]
	after $checkInt_ "$self mega_check_active 1"
}

RTPGWAgent instproc mega_register args {}
RTPGWAgent instproc mega_unregister { atype aspec addr sname } {
	if { $atype != "client" } {
		return
	}
	$self mega_check_active 0
}

RTPGWAgent instproc change_name { src } {
	$self trigger_sdes $src
}


RTPGWAgent instproc trigger_format { src } {
	$self reconfigure $src
}

RTPGWAgent instproc trigger_sdes { src } {
	set rep [$self rtp_representation $src]
	$self instvar srcinfo_
	set srcinfo_($src,name) [lindex $rep 0]
	set srcinfo_($src,info) [lindex $rep 1]
}

RTPGWAgent instproc register { src } {
#puts "$self register $src [$src srcid]"
	#
	# set up pass through control path
	#
	set rep [new Replicator/Packet/Copy]
	set srcsess [$src set session_]
	$self instvar sessions_
	foreach s $sessions_ {
		if { $s == $srcsess } {
			continue
		}
		$rep add-target [$s ctrl-handler]
	}
	$src ctrl-handler $rep
	$self instvar all_sources_
	lappend all_sources_ $src

	$self instvar cb_
	$cb_ send register $src
}

RTPGWAgent instproc unregister { src } {
#puts "$self unregister $src [$src srcid]"
	# Tear down control path.  'deactivate' call tears down data path.
	$self instvar all_sources_
	set i [lsearch -exact $all_sources_ $src]
	set all_sources_ [lreplace $all_sources_ $i $i]
	delete [$src ctrl-handler]

	# FIXME this should really happen here, but C++ does deletion.
	#delete $src

	$self instvar cb_
	$cb_ send unregister $src

}

RTPGWAgent instproc mega_check_active { timer } {
	$self instvar sessbyname_ gwal_ sdp_

	# Check if there exists a client that is listening on our address.
	# If so, we are "active".

	set clist [$gwal_ set agentbytype_(client)]
	set s $sessbyname_(local)
	set nm [$s set netmgr_]
	set net [$nm set net_(0)]
	set dn [$net data-net]
	if [in_multicast [$dn addr]] {
		set lspec [$dn addr]/[$dn rport]:[$dn sport]/[$dn ttl]
	} else {
		set lspec [localaddr]/[$dn rport]:[$dn sport]/[$dn ttl]
	}
	foreach c $clist {
		set msg [$sdp_ parse [lindex [$gwal_ agenttab $c] 1]]
		set media [lindex [$msg set allmedia_] 0]
		set addr [lindex [$media field_value c] 2]
		delete $msg
		if { $addr == $lspec } {
			# puts #rtpgw alive!"
			if $timer {
				$self instvar checkInt_
				after $checkInt_ "$self mega_check_active 1"
			}
			return

		}
	}
        puts "rtpgw: no clients, exiting."
	exit 0
}

RTPGWAgent instproc check_for_sources {} {
#puts "check_for_sources"
	# If there is only one session with registered sources - kill the
        # gateway.
	$self instvar sessions_
	set n 0
	foreach s $sessions_ {
		set sm [$s sm]
		if { [$sm set sources_] != "" } {
			incr n
		}
	}
	if { $n <= 1 } {
		if { [$self get_option megaSession] != "" } {
			$self mega_check_active 0
			return
		} else {
			puts \
			    "rtpgw: only $n session(s) with sources.  Exiting."
			exit 0
		}
	}
	set rint [$self get_option siteDropTime]
	set rint [expr $rint*1000]
	after $rint "$self check_for_sources"
}

RTPGWAgent instproc activate { src } {
#puts "$self activate $src [$src srcid]"
	$self instvar all_active_ srcinfo_ sessbyname_ cb_

	lappend all_active_ $src

	#
	# Set up data path and redirect control path
	#
	set rep [new Replicator/Packet/Copy]
	$src data-handler $rep

	delete [$src ctrl-handler]
	set rep [new Replicator/Packet/Copy]
	$src ctrl-handler $rep

	$self reconfigure $src

	set addr [$src addr]
	set sess [$src set session_]
	set sname [$sess set sname_]
 	$cb_ send activate "$src \"$srcinfo_($src,name)\" \
				   \"$addr\" \
				   \"$sname\" \
				   \"$srcinfo_($src,info)\""
	$self srcupdate {} $src
}

RTPGWAgent instproc deactivate src {
#puts "$self deactivate $src [$src srcid]"
    	$self instvar all_active_ cb_ bufferPools_
	set i [lsearch -exact $all_active_ $src]
	set all_active_ [lreplace $all_active_ $i $i]

	global ifpshat ibpshat ofpshat obpshat
	if { [info exists ifpshat($src)] } {
		unset ifpshat($src)
		unset ibpshat($src)
		$self instvar sessions_
		set srcsess [$src set session_]
		foreach s $sessions_ {
			if { $s == $srcsess } {
				continue
			}
			unset ofpshat($src,$s)
			unset obpshat($src,$s)
			$self delete_transcoder $src $s
			delete $bufferPools_($src,$s)
		}
	}
	delete [$src data-handler]
    	$cb_ send deactivate $src
}

RTPGWAgent instproc delete_transcoder { src sess } {
	$self instvar transcoders_
	# Delete old structures
	set t $transcoders_($src,$sess)
	if {[$t set tname_] != "pass-thru"} {
		set e [$t set encoder_]
		delete $e
	}
	set input [$t data-handler]
	set rep [$src data-handler]
	$rep remove-target $input
	delete $input

	set input [$t ctrl-handler]
	set rep [$src ctrl-handler]
	$rep remove-target $input
	delete $input

	unset transcoders_($src,$sess)
	delete $t
}

RTPGWAgent instproc reconfigure { src } {
	$self instvar sessions_ transcoders_ bufferPools_

	set srcsess [$src set session_]
	foreach sess $sessions_ {
		if { $sess == $srcsess } {
			continue
		}
		if [info exists transcoders_($src,$sess)] {
			$self delete_transcoder $src $sess
		}
		set rc [$sess set rate_control_]
		set txonly [$sess set txonly_]

		if ![info exists bufferPools_($src,$sess)] {
			set pool [new BufferPool/RTP]
			$pool srcid [$src srcid]
			set bufferPools_($src,$sess) $pool
		}
		if { $rc == 0 } {
			set t [$self create-transcoder $src $sess null null]
			$t set forward_ 1
		} else {
			set ifmt [$self rtp_type [$src format]]
			set ofmt [$sess set ofmt_]
			set t [$self create-transcoder $src $sess $ifmt $ofmt]
		}
		$t set txonly_ $txonly

		set transcoders_($src,$sess) $t

		$self set_rate_vars $src
		$self trigger_sdes $src
	}
}


RTPGWAgent instproc create-transcoder { src osess ifmt ofmt } {
	$self instvar codec_map_ bufferPools_

#puts "[$osess set sname_]: create-transcoder $src [$src srcid] $osess $ifmt $ofmt"
	# FIXME Eventually optimize this so we can share encoders
    	foreach e $codec_map_ {
		set m_ifmt [lindex $e 0]
		set m_ofmt [lindex $e 1]
		if { $m_ifmt == $ifmt && $m_ofmt == $ofmt } then {
			set encoder [$self create_encoder [lindex $e 3]]
			$encoder buffer-pool $bufferPools_($src,$osess)
			$encoder target [$osess data-handler]
			set t [new Transcoder/[lindex $e 2] $src $osess]
			$t encoder $encoder
			$t set encoder_ $encoder
			$t set ofmt_ $ofmt
			$t set tname_ $ifmt->$ofmt
			return $t
		}
	}
	set t [new Transcoder/Null $src $osess]
	$t set tname_ pass-thru

        # Control path is set up in base constructor since it is
	# identical for all transcoders.
	set i [$osess data-handler]
	set o [$t data-handler]
	$o target $i

	return $t
}

RTPGWAgent instproc set_rate_vars { src } {
	global ofpshat obpshat ibpshat ifpshat
	$self instvar sessions_
	set srcsess [$src set session_]
	if { [info exists ifpshat($src)] } {
		unset ifpshat($src)
		unset ibpshat($src)

		foreach s $sessions_ {
			if { $s == $srcsess } {
				continue
			}
			unset ofpshat($src,$s)
			unset obpshat($src,$s)
		}
	}

	set gain [$self get_option filterGain]

	set ifpshat($src) 0
	rate_variable ifpshat($src) $gain
	set ibpshat($src) 0
	rate_variable ibpshat($src) $gain

	foreach s $sessions_ {
		if { $s == $srcsess } {
			continue
		}
		set ofpshat($src,$s) 0
		rate_variable ofpshat($src,$s) $gain
		set obpshat($src,$s) 0
		rate_variable obpshat($src,$s) $gain
	}
}

RTPGWAgent instproc srcupdate { info src } {
	global ifpshat ibpshat ofpshat obpshat
	$self instvar all_active_ srcinfo_ transcoders_ sessions_

	# May have had a message in transit.
    	if { [lsearch -exact $all_active_ $src] == -1 } then {
		return
	}
	# FIXME Unlayered
	set l0 [lindex [$src set layers_] 0]
	set ifpshat($src) [$l0 set nf_]
	set ibpshat($src) [expr [$l0 set nb_]*8]
	set ifps $ifpshat($src)
	set ibps $ibpshat($src)

	set srcsess [$src set session_]
	set msg ""
	foreach sess $sessions_ {
		if { $sess == $srcsess } {
			continue
		}
		set sname [$sess set sname_]

		set t $transcoders_($src,$sess)

		set ofpshat($src,$sess) [$t set ofrms_]
		set nb [$t set obytes_]
		set obpshat($src,$sess) [expr $nb*8]

		set ofps $ofpshat($src,$sess)
		set obps $obpshat($src,$sess)

		set ifps [RTPGWAgent format_fps $ifps]
		set ibps [RTPGWAgent format_bps $ibps]
		set ofps [RTPGWAgent format_fps $ofps]
		set obps [RTPGWAgent format_bps $obps]

		set maxbps [$t set bps_]
		set tname [$t set tname_]
		set m "{$sname $tname $maxbps \
			{$ifps} {$ibps} {$ofps} {$obps}}"
		set msg $msg$m
	}
	$self instvar cb_
	set srcsessname [$srcsess set sname_]
	$cb_ send srcupdate "$src \
			\"$srcinfo_($src,name)\" \
			\"$srcinfo_($src,info)\" \
			$srcsessname \
			{$msg}"
}

#
# FIXME This should be in the UI, not here.
#
RTPGWAgent proc format_fps f {
	set fps $f
	if { $fps < .1 } {
		set fps "0 f/s"
	} elseif { $fps < 10 } {
		set fps [format "%.1f f/s" $fps]
	} else {
		set fps [format "%2.0f f/s" $fps]
	}

	return $fps
}

RTPGWAgent proc format_bps b {
	set bps $b

	if { $bps < 1 } {
		set bps "0 bps"
	} elseif { $bps < 1000 } {
		set bps [format "%3.0f bps" $bps]
	} elseif { $bps < 1000000 } {
		set bps [format "%3.0f kb/s" [expr $bps / 1000.]]
	} else {
		set bps [format "%.1f Mb/s" [expr $bps / 1000000.]]
	}

	return $bps
}

RTPGWAgent instproc cb_get { info var } {
	$self instvar encoders_ all_active_ cb_
	switch $var {
		encoders {
			$cb_ send encoders "{$encoders_}"
		}
		active_list {
			$self instvar all_active_
			$cb_ send active_list "{$all_active_}"
		}
	}
}

RTPGWAgent instproc cb_init { info } {
	$self instvar all_active_

	foreach s $all_active_ {
		$s deactivate
	}
}

RTPGWAgent instproc set_maxchannel n {
	# If and when we have a layered transcoder - we'll have to
	# do something here.
}


RTPGWAgent instproc add_session { sname spec } {
	$self instvar sessbyname_ sessions_
	set s [$self create-session]

	# FIXME delete this in destructor!
	$s buffer-pool [new BufferPool]
	# no local loopback
	$s loopback-layer -1
	$s set rate_control_ 1
	$s set txonly_ 0
	set sm [new MediaAgent/RTPGW $self]
	$sm site-drop-time [$self get_option siteDropTime]
	$s sm $sm

	if { $spec != "none" } {
		set ab [new AddressBlock $spec]
		$s reset $ab
		delete $ab
	}
	# No local source
	$s set loopbackLayer_ 0
	set sessbyname_($sname) $s
	$s set sname_ $sname
	lappend sessions_ $s
}

RTPGWAgent instproc reset_spec spec {
	$self instvar sessbyname_

	set ab [new AddressBlock $spec]
	$sessbyname_(global) reset $ab
	delete $ab
}


RTPGWAgent instproc cb_sessions { info slist } {
	foreach s [split $slist !] {
		set s [split $s =]
		$self add_session [lindex $s 0] [lindex $s 1]
	}
	$self instvar gwal_
	if { [$self get_option megaSession] != "" } {
		# Now we can start sending MeGa messages.
		# $gwal_ start 1
		$gwal_ send_announcement
	}
}

RTPGWAgent instproc sessionbw { b sess } {
	$sess data-bandwidth $b
}

RTPGWAgent instproc cb_set { info sname var val } {
	$self instvar sessbyname_ sessions_
	if ![info exists sessbyname_($sname)] {
		return
	}
	set sess $sessbyname_($sname)
	switch $var {
		sessionbw {
			$self sessionbw $val $sess
		}
		txonly {
			$sess set txonly_ $val
			set tlist [$self session_transcoders $sess]
			foreach t $tlist {
				$t set txonly_ $val
			}
		}
		RC {
			$sess set rate_control_ $val
			foreach osess $sessions_ {
				if { $osess == $sess } {
					continue
				}
				set sm [$osess sm]
				set al [$sm active_list]
				foreach s $al {
					$self reconfigure $s
				}
			}
		}
		ofmt {
			$sess set ofmt_ $val
			set rc [$sess set rate_control_]
			# If no rate control, no need to do anything.
			if { $rc == 0 } then {
				return
			}
			foreach osess $sessions_ {
				if { $osess == $sess } {
					continue
				}
				set sm [$osess sm]
				set al [$sm active_list]
				foreach s $al {
					$self reconfigure $s
				}
			}
		}
		key {
			set nm [$sess set netmgr_]
			$nm install-key $val
		}
		default {
			puts stderr "rtpgw: cb_set: unknown variable \"$var\""
		}
	}
}

RTPGWAgent/Video instproc cb_set { info sname var val } {
	$self instvar transcoders_ sessbyname_
	switch $var {
		color {
			set sess $sessbyname_($sname)
			$sess set color_ $val
			set tlist [$self session_transcoders $sess]
			foreach t $tlist {
				if {[$t set tname_] != "pass-thru"} {
					$t color $val
				}
			}
		}
		default {
			$self next {} $sname $var $val
		}
	}
}

RTPGWAgent instproc cb_srcset { info src sname type val } {
	$self instvar all_active_
	# May have had a message in transit.
    	if { [lsearch -exact $all_active_ $src] == -1 } then {
		return
	}
	$self instvar sessbyname_ transcoders_
	switch $type {
		maxbps {
			set sess $sessbyname_($sname)
			set t $transcoders_($src,$sess)
			$t set-bps $val
		}
	}
}

RTPGWAgent instproc alive {} {
	$self instvar cb_
	$cb_ send alive
	after 10000 "$self alive"
}

RTPGWAgent instproc adios {} {
	$self instvar cb_
	$cb_ send dead
}

RTPGWAgent instproc loopdetect { msg } {
	$self instvar cb_
    	$cb_ send loopdetect "{$msg}"
    	$self adios
}

# FIXME
RTPGWAgent instproc src_switch { info addr } {
}

RTPGWAgent instproc init_confbus {} {
	$self instvar cb_ app_
	set channel [$self get_option confBusChannel]
	set name [$app_ set name_]
	if { $channel != 0 } {
		set cb_ [new CoordinationBus -channel $channel]
	} else {
		puts stderr "rtpgw: error coordination bus channel must be > 0"
		exit 1
	}

	$self init_callbacks
}

RTPGWAgent instproc init_callbacks {} {
	$self instvar cb_
	$cb_ register cb_init "$self cb_init"
	$cb_ register cb_sessions "$self cb_sessions"
	$cb_ register cb_get "$self cb_get"
	$cb_ register cb_set "$self cb_set"
	$cb_ register cb_srcset "$self cb_srcset"
	$cb_ register srcupdate "$self srcupdate"
	$cb_ register src_switch "$self src_switch"
#	$cb_ register cb_crypt_set "$self cb_crypt_set"
}

RTPGWAgent instproc have_network {} {
	$self instvar sessbyname_
	if ![info exists sessbyname_(global)] {
		return 0
	}
	set nm [$sessbyname_(global) set netmgr_]
	if { $nm == "" } {
		return 0
	} else {
		return 1
	}
}

RTPGWAgent instproc network {} {
	if ![$self have_network] {
		return none
	}
	$self instvar sessbyname_
	set network [$sessbyname_(global) set netmgr_]
	return [$network data-net 0]
}

RTPGWAgent instproc session-addr {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] addr]
}

RTPGWAgent instproc session-port {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] port]
}

RTPGWAgent instproc session-rport {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] rport]
}

RTPGWAgent instproc session-sport {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] sport]
}

RTPGWAgent instproc session-ttl {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] ttl]
}


Transcoder instproc init { src sess } {
	$self next

	$self source $src

	set datarep [$src data-handler]
	set ctrlrep [$src ctrl-handler]

	set h [new Module/DataHandler]
	$self data-handler $h
	$datarep add-target $h

	set h [new Module/ControlHandler]
	$h target [$sess ctrl-handler]
	$self ctrl-handler $h
	$ctrlrep add-target $h
}

Transcoder/Null instproc rtcp-thumbnail n {}

Transcoder set bps_ 0
Transcoder set opkts_ 0
Transcoder set obytes_ 0
Transcoder set ofrms_ 0
Transcoder set forward_ 0
Transcoder set txonly_ 0
