# graph-comm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import SRMv2_Source
import SRMv2_Session

Class GraphComm;

GraphComm instproc destroy {} {
    $self instvar sess_list_

    if {[info exists sess_list_]} {
	foreach s $sess_list_ {
	    $s callback_object ""
	}
    }
    $self next
}

GraphComm instproc init {src_id addr port {ttl 16}} {
    $self next;

    $self instvar primary_sess_ sess_list_ local_source_
    $self instvar sess_map_;

    set primary_sess_ [new SRMv2_Session $addr $port $port $ttl];
    lappend sess_list_ $primary_sess_;

    set local_source_ [new SRMv2_Source $primary_sess_ $src_id];

    $primary_sess_ callback_object $self;

    $self instvar local_src_cids_;

    set local_src_cids_(inputs) [$local_source_ calloc 0 inputs];
    set local_src_cids_(outputs) [$local_source_ calloc 0 outputs];
    set local_src_cids_(parameters) [$local_source_ calloc 0 parameters];
    set local_src_cids_(misc) [$local_source_ calloc 0 misc];
    set local_src_cids_(trigger_cmds) [$local_source_ calloc 0 trigger_cmds];
    set local_src_cids_(map_cmds) [$local_source_ calloc 0 map_cmds];
    set local_src_cids_(debug) [$local_source_ calloc 0 debug];

    $self instvar input_names_ output_names_ parameter_names_;

    set input_names_ "";
    set output_names_ "";
    set parameter_names_ "";

    set sess_map_($primary_sess_,inputs) 1;
    set sess_map_($primary_sess_,outputs) 1;
    set sess_map_($primary_sess_,parameters) 1;
    set sess_map_($primary_sess_,misc) 1;
    set sess_map_($primary_sess_,trigger_cmds) 1;
    set sess_map_($primary_sess_,map_cmds) 1;
    set sess_map_($primary_sess_,debug) 1;

    $self instvar read_adu_callback_map_;

    set read_adu_callback_map_($local_source_,$local_src_cids_(map_cmds)) "$self handle_map_cmd_read_adu ";
    set read_adu_callback_map_($local_source_,$local_src_cids_(misc)) "$self handle_misc_read_adu ";
    set read_adu_callback_map_($local_source_,$local_src_cids_(debug)) "$self handle_debug_read_adu ";

}

GraphComm instproc search_for_session {addr port} {
    $self instvar sess_list_;

    foreach s $sess_list_ {
	if {[$s set addr_] == $addr} {
	    if {[$s set rport_] == $port} {
		return $s;
	    }
	}
    }
    return "";
}

GraphComm instproc add_session {addr port ttl} {
    $self instvar sess_list_ sess_map_;

    set s [new SRMv2_Session $addr $port $port $ttl];
    lappend sess_list_ $s;

    set sess_map_($s,inputs) 1;
    set sess_map_($s,outputs) 1;
    set sess_map_($s,parameters) 1;
    set sess_map_($s,misc) 1;
    set sess_map_($s,trigger_cmds) 1;
    set sess_map_($s,map_cmds) 1;
    set sess_map_($s,debug) 1;

    $s callback_object $self;

    return $s;
}

GraphComm instproc srm_source_update {src info} {
#    puts "SourceUpdate: $src $info";

    $self instvar recv_cid_callback_map_;
    $self instvar should_recover_callback_map_;

    set recv_cid_callback_map_($src,0) "$self handle_root_recv_cid";
    set should_recover_callback_map_($src,0) "$self always_recover";
}

GraphComm instproc srm_recv_cid {src cid pcid name} {
#    puts "RecvCID: $src $cid $pcid $name";

    $self instvar recv_cid_callback_map_;

    if [info exists recv_cid_callback_map_($src,$pcid)] {
	eval $recv_cid_callback_map_($src,$pcid) [list $src $cid $pcid $name];
    }
}

GraphComm instproc srm_recv {src cid seqno data} {
#    puts "Recv: $src $cid $seqno $data";

    $self instvar recv_callback_map_;

    if [info exists recv_callback_map_($src,$cid)] {
	eval $recv_callback_map_($src,$cid) [list $src $cid $seqno $data];
    }
}

GraphComm instproc srm_should_recover {src cid sseq eseq} {
#    puts "ShouldRecover: $src $cid $sseq $eseq";

    $self instvar should_recover_callback_map_;

    if [info exists should_recover_callback_map_($src,$cid)] {
	set ret_val [eval $should_recover_callback_map_($src,$cid) [list $src $cid $sseq $eseq]]
    } else {
	set ret_val 0;
    }
#    puts "ShouldRecover: returning $ret_val";

    return $ret_val;
}

GraphComm instproc srm_read_adu {src cid seqno} {
#    puts "ReadAdu: $src $cid $seqno";

    $self instvar read_adu_callback_map_

    if [info exists read_adu_callback_map_($src,$cid)] {
	set ret_val [eval $read_adu_callback_map_($src,$cid) [list $src $cid $seqno]];
    } else {
	set ret_val "";
    }
#    puts "ReadAdu: returning $ret_val";
    return $ret_val;
}

GraphComm instproc handle_root_recv_cid {src cid pcid name} {
    $self instvar recv_cid_callback_map_;
    $self instvar recv_callback_map_;
    $self instvar should_recover_callback_map_;
    $self instvar sess_map_;

    set sess [$src session];

    switch -exact -- $name {
	"inputs" {
	    if {$sess_map_($sess,inputs) == 1} {
		set recv_cid_callback_map_($src,$cid) "$self handle_input_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    } elseif {$sess_map_($sess,inputs) == "conditional"} {
		set recv_cid_callback_map_($src,$cid) "$self handle_conditioned_input_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    }
	}
	"outputs" {
	    if {$sess_map_($sess,outputs) == 1} {
		set recv_cid_callback_map_($src,$cid) "$self handle_output_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    } elseif {$sess_map_($sess,outputs) == "conditional"} {
		set recv_cid_callback_map_($src,$cid) "$self handle_conditioned_output_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    }
	}
	"parameters" {
	    if {$sess_map_($sess,parameters) == 1} {
		set recv_cid_callback_map_($src,$cid) "$self handle_parameter_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    } elseif {$sess_map_($sess,parameters) == "conditional"} {
		set recv_cid_callback_map_($src,$cid) "$self handle_conditioned_parameter_recv_cid"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    }
	}
	"trigger_cmds" {
	    if {$sess_map_($sess,trigger_cmds) == 1} {
		set recv_callback_map_($src,$cid) "$self handle_trigger_recv"
		set should_recover_callback_map_($src,$cid) "$self never_recover";
	    }
	}
	"map_cmds" {
	    if {$sess_map_($sess,map_cmds) == 1} {
		set recv_callback_map_($src,$cid) "$self handle_map_recv"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    }
	}
	"misc" {
	    if {$sess_map_($sess,misc) == 1} {
		set recv_callback_map_($src,$cid) "$self handle_misc_recv"
		set should_recover_callback_map_($src,$cid) "$self always_recover";
	    }
	}
	"debug" {
	    if {$sess_map_($sess,debug) == 1} {
		set recv_callback_map_($src,$cid) "$self handle_debug_recv"
		set should_recover_callback_map_($src,$cid) "$self never_recover";
	    }
	}
    }
}

GraphComm instproc handle_input_recv_cid {src cid pcid name} {
    $self instvar input_names_;
    $self instvar recv_cid_callback_map_;

    if {[lsearch $input_names_ $name] == -1} {
	# New input !!!!
	$self new_input $name;
    }
    set recv_cid_callback_map_($src,$cid) "$self handle_input_attr_recv_cid $name"

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self always_recover";
}

GraphComm instproc handle_conditioned_input_recv_cid {src cid pcid name} {
    $self instvar input_names;
    $self instvar recv_cid_callback_map_;

    $self instvar sess_map_;

    set sess [$src session];

    if {![info exists sess_map_($sess,inputs,mappings,$name)]} {
	# This input not mapped. Return doing nothing.
	return;
    }

    set mapped_name $sess_map_($sess,inputs,mappings,$name);

    $self handle_input_recv_cid $src $cid $pcid $mapped_name;
}

GraphComm instproc handle_input_attr_recv_cid {input_name src cid pcid name} {
    $self instvar input_names_;
    $self instvar input_info_;

    if {[lsearch $input_info_($input_name,attr_list) $name] == -1} {
	# New attribute for an input!!!!
	$self new_input_attribute $input_name $name;
    }

    $self instvar recv_callback_map_;
    set recv_callback_map_($src,$cid) "$self handle_input_attr_value_recv $input_name $name ";

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self handle_input_attr_should_recover $input_name $name "

    $self instvar read_adu_callback_map_;
    set read_adu_callback_map_($src,$cid) "$self handle_input_attr_read_adu $input_name $name "
}

GraphComm instproc handle_output_recv_cid {src cid pcid name} {
    $self instvar output_names_;
    $self instvar recv_cid_callback_map_;

    if {[lsearch $output_names_ $name] == -1} {
	# New output !!!!
	$self new_output $name;
    }
    set recv_cid_callback_map_($src,$cid) "$self handle_output_attr_recv_cid $name"

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self always_recover";
}

GraphComm instproc handle_conditioned_output_recv_cid {src cid pcid name} {
    $self instvar output_names;
    $self instvar recv_cid_callback_map_;

    $self instvar sess_map_;

    set sess [$src session];

    if {![info exists sess_map_($sess,outputs,mappings,$name)]} {
	# This output not mapped. Return doing nothing.
	return;
    }

    set mapped_name $sess_map_($sess,outputs,mappings,$name);

    $self handle_output_recv_cid $src $cid $pcid $mapped_name;
}

GraphComm instproc handle_output_attr_recv_cid {output_name src cid pcid name} {
    $self instvar output_names_;
    $self instvar output_info_;

    if {[lsearch $output_info_($output_name,attr_list) $name] == -1} {
	# New attribute for an output!!!!
	$self new_output_attribute $output_name $name;
    }
    $self instvar recv_callback_map_;
    set recv_callback_map_($src,$cid) "$self handle_output_attr_value_recv $output_name $name ";

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self handle_output_attr_should_recover $output_name $name "

    $self instvar read_adu_callback_map_;
    set read_adu_callback_map_($src,$cid) "$self handle_output_attr_read_adu $output_name $name "

}

GraphComm instproc handle_parameter_recv_cid {src cid pcid name} {
    $self instvar parameter_names_;
    $self instvar recv_cid_callback_map_;

    if {[lsearch $parameter_names_ $name] == -1} {
	# New parameter !!!!
	$self new_parameter $name;
    }
    set recv_cid_callback_map_($src,$cid) "$self handle_parameter_attr_recv_cid $name"

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self always_recover";
}

GraphComm instproc handle_conditioned_parameter_recv_cid {src cid pcid name} {
    $self instvar parameter_names;
    $self instvar recv_cid_callback_map_;

    $self instvar sess_map_;

    set sess [$src session];

    if {![info exists sess_map_($sess,parameters,mappings,$name)]} {
	# This parameter not mapped. Return doing nothing.
	return;
    }

    set mapped_name $sess_map_($sess,parameters,mappings,$name);

    $self handle_parameter_recv_cid $src $cid $pcid $mapped_name;
}

GraphComm instproc handle_parameter_attr_recv_cid {parameter_name src cid pcid name} {
    $self instvar parameter_names_;
    $self instvar parameter_info_;

    if {[lsearch $parameter_info_($parameter_name,attr_list) $name] == -1} {
	# New attribute for an parameter!!!!
	$self new_parameter_attribute $parameter_name $name;
    }
    $self instvar recv_callback_map_;
    set recv_callback_map_($src,$cid) "$self handle_parameter_attr_value_recv $parameter_name $name ";

    $self instvar should_recover_callback_map_;
    set should_recover_callback_map_($src,$cid) "$self handle_parameter_attr_should_recover $parameter_name $name "

    $self instvar read_adu_callback_map_;
    set read_adu_callback_map_($src,$cid) "$self handle_parameter_attr_read_adu $parameter_name $name "

}

GraphComm instproc handle_input_attr_value_recv {input_name attr_name src cid seqno data} {
    $self instvar input_info_;

    # Check to see whether this message is later than previous message
    # from same source. If not, throw away.

    if [info exists input_info_($input_name,$attr_name,last_seqno,$src)] {
	set last_seqno $input_info_($input_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $seqno} {
	    return;
	}
    }

    # Message is good. Record that this as most recent seqno from this source
    set input_info_($input_name,$attr_name,last_seqno,$src) $seqno;

    # Deliver data

    $self update_input_attr_value $input_name $attr_name $data
}

GraphComm instproc handle_input_attr_read_adu {input_name attr_name src cid seqno} {
    $self instvar input_info_;

    if {[info exists input_info_($input_name,$attr_name,cur_value)]} {
	return $input_info_($input_name,$attr_name,cur_value);
    }
}

GraphComm instproc handle_output_attr_read_adu {output_name attr_name
src cid seqno} {
    $self instvar output_info_;

    if {[info exists output_info_($output_name,$attr_name,cur_value)]} {
	return $output_info_($output_name,$attr_name,cur_value);
    }
}

GraphComm instproc handle_parameter_attr_read_adu {parameter_name attr_name src cid seqno} {
    $self instvar parameter_info_;

    if {[info exists parameter_info_($parameter_name,$attr_name,cur_value)]} {
	return $parameter_info_($parameter_name,$attr_name,cur_value);
    }
}

GraphComm instproc handle_map_cmd_read_adu {src cid seqno} {
    $self instvar map_command_datastore_;

    if {[info exists map_command_datastore_($seqno)]} {
	return $map_command_datastore_($seqno);
    }
    return "";
}

GraphComm instproc handle_misc_read_adu {src cid seqno} {
    $self instvar misc_datastore_;

    if {[info exists misc_datastore_($seqno)]} {
	return $misc_datastore_($seqno);
    }
    return "";
}

GraphComm instproc handle_debug_read_adu {src cid seqno} {
    $self instvar debug_datastore_;

    if {[info exists debug_datastore_($seqno)]} {
	return $debug_datastore_($seqno);
    }
    return "";
}

GraphComm instproc handle_input_attr_should_recover {input_name attr_name src cid sseq eseq} {
    $self instvar input_info_;

    if [info exists input_info_($input_name,$attr_name,last_seqno,$src)] {
	set last_seqno $input_info_($input_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $eseq} {
	    return 0;
	} else {
	    if {[info exists input_info_($input_name,$attr_name,cur_value)]} {
		unset input_info_($input_name,$attr_name,cur_value);
	    }
	    $src recover $cid $eseq $eseq;
	    return 0;
	}
    } else {
	if {[info exists input_info_($input_name,$attr_name,cur_value)]} {
	    unset input_info_($input_name,$attr_name,cur_value);
	}
	$src recover $cid $eseq $eseq;
	return 0;
    }
}

GraphComm instproc handle_output_attr_should_recover {output_name attr_name src cid sseq eseq} {
    $self instvar output_info_;

    if [info exists output_info_($output_name,$attr_name,last_seqno,$src)] {
	set last_seqno $output_info_($output_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $eseq} {
	    return 0;
	} else {
	    if {[info exists output_info_($output_name,$attr_name,cur_value)]} {
		unset output_info_($output_name,$attr_name,cur_value);
	    }
	    $src recover $cid $eseq $eseq;
	    return 0;
	}
    } else {
	if {[info exists output_info_($output_name,$attr_name,cur_value)]} {
	    unset output_info_($output_name,$attr_name,cur_value);
	}
	$src recover $cid $eseq $eseq;
	return 0;
    }
}

GraphComm instproc handle_parameter_attr_should_recover {parameter_name attr_name src cid sseq eseq} {
    $self instvar parameter_info_;

    if [info exists parameter_info_($parameter_name,$attr_name,last_seqno,$src)] {
	set last_seqno $parameter_info_($parameter_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $eseq} {
	    return 0;
	} else {
	    if {[info exists parameter_info_($parameter_name,$attr_name,cur_value)]} {
		unset parameter_info_($parameter_name,$attr_name,cur_value);
	    }
	    $src recover $cid $eseq $eseq;
	    return 0;
	}
    } else {
	if {[info exists parameter_info_($parameter_name,$attr_name,cur_value)]} {
	    unset parameter_info_($parameter_name,$attr_name,cur_value);
	}
	$src recover $cid $eseq $eseq;
	return 0;
    }
}

GraphComm instproc handle_output_attr_value_recv {output_name attr_name src cid seqno data} {
    $self instvar output_info_;

    # Check to see whether this message is later than previous message
    # from same source. If not, throw away.

    if [info exists output_info_($output_name,$attr_name,last_seqno,$src)] {
	set last_seqno $output_info_($output_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $seqno} {
	    return;
	}
    }

    # Message is good. Record that this as most recent seqno from this source
    set output_info_($output_name,$attr_name,last_seqno,$src) $seqno;

    # Deliver data

    $self update_output_attr_value $output_name $attr_name $data
}


GraphComm instproc handle_parameter_attr_value_recv {parameter_name attr_name src cid seqno data} {
    $self instvar parameter_info_;

    # Check to see whether this message is later than previous message
    # from same source. If not, throw away.

    if [info exists parameter_info_($parameter_name,$attr_name,last_seqno,$src)] {
	set last_seqno $parameter_info_($parameter_name,$attr_name,last_seqno,$src);
	if {$last_seqno > $seqno} {
	    return;
	}
    }

    # Message is good. Record that this as most recent seqno from this source
    set parameter_info_($parameter_name,$attr_name,last_seqno,$src) $seqno;

    # Deliver data

    $self update_parameter_attr_value $parameter_name $attr_name $data
}

GraphComm instproc handle_trigger_recv {src cid seqno data} {
    $self recv_trigger_command $data;
}

GraphComm instproc handle_map_recv {src cid seqno data} {
    $self recv_map_command $data;
}

GraphComm instproc handle_misc_recv {src cid seqno data} {
    $self recv_misc $data
}

GraphComm instproc handle_debug_recv {src cid seqno data} {
    $self recv_debug $data
}

GraphComm instproc parameter_values_are_uptodate {} {
    $self instvar parameter_names_ parameter_info_;

    foreach p $parameter_names_ {
	if {![info exists parameter_info_($p,value,cur_value)]} {
	    return 0;
	}
    }
    return 1;
}

GraphComm instproc parameter_attr_has_value {parameter_name attr_name} {
    $self instvar parameter_info_;

    if {[info exists parameter_info_($parameter_name,$attr_name,cur_value)]} {
	return 1;
    } else {
	return 0;
    }
}

GraphComm instproc get_parameter_attr_value {parameter_name attr_name} {
    $self instvar parameter_info_;

    return $parameter_info_($parameter_name,$attr_name,cur_value);
}

GraphComm instproc primary_addr {} {
    $self instvar primary_sess_;

    return [$primary_sess_ set addr_];
}

GraphComm instproc primary_port {} {
    $self instvar primary_sess_;

    return [$primary_sess_ set rport_];
}

GraphComm instproc primary_ttl {} {
    $self instvar primary_sess_;

    return [$primary_sess_ set ttl_];
}

GraphComm instproc always_recover {args} {
    return 1;
}

GraphComm instproc never_recover {args} {
    return 0;
}

#####################################################
# Below here is the general interface that gets used (and for
# many things overridden) by the specific entity in charge
# If overriding a function that is not empty, be sure
# to do an "$self next" call.
#####################################################


GraphComm instproc recv_trigger_command {cmd} {
}

GraphComm instproc recv_map_command {cmd} {
    $self instvar sess_map_;

    set type [lindex $cmd 0];
    set addr [lindex $cmd 1];
    set port [lindex $cmd 2];
    set ttl [lindex $cmd 3];

    set sess [$self search_for_session $addr $port];

    switch -exact -- $type {
	map_sess {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
	    }
	    set sess_map_($sess,inputs) 1;
	    set sess_map_($sess,outputs) 1;
	    set sess_map_($sess,parameters) 1;
	    set sess_map_($sess,misc) 1;
	    set sess_map_($sess,trigger_cmds) 1;
	    set sess_map_($sess,map_cmds) 1;
	    set sess_map_($sess,debug) 1;
	}
	map_inputs {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
	    }
	    set sess_map_($sess,inputs) 1;
	}
	map_outputs {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
	    }
	    set sess_map_($sess,outputs) 1;
	}
	map_parameters {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
	    }
	    set sess_map_($sess,parameters) 1;
	}
	map_misc {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
		set sess_map_($sess,debug) 0;
	    }
	    set sess_map_($sess,misc) 1;
	}
	map_trigger_cmds {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,map_cmds) 0;
	    }
	    set sess_map_($sess,trigger_cmds) 1;
	}
	map_map_cmds {
	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,inputs) 0;
	    }
	    set sess_map_($sess,map_cmds) 1;
	}
	map_input {
	    set in_name [lindex $cmd 4];
	    set in_mapped_name [lindex $cmd 5];

	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,inputs) "conditional"
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
		set sess_map_($sess,inputs,mappings,$in_name) $in_mapped_name;
	    } else {
		if {$sess_map_($sess,inputs) == "conditional"} {
		    set sess_map_($sess,inputs,mappings,$in_name) $in_mapped_name;
		} elseif {$sess_map_($sess,inputs) == 0} {
		    set sess_map_($sess,inputs) "conditional";
		    set sess_map_($sess,inputs,mappings,$in_name) $in_mapped_name;
		}
	    }
	}
	map_output {
	    set out_name [lindex $cmd 4];
	    set out_mapped_name [lindex $cmd 5];

	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,outputs) "conditional"
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,parameters) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
		set sess_map_($sess,outputs,mappings,$out_name) $out_mapped_name;
	    } else {
		if {$sess_map_($sess,outputs) == "conditional"} {
		    set sess_map_($sess,outputs,mappings,$out_name) $out_mapped_name;
		} elseif {$sess_map_($sess,outputs) == 0} {
		    set sess_map_($sess,outputs) "conditional";
		    set sess_map_($sess,outputs,mappings,$out_name) $out_mapped_name;
		}
	    }
	}
	map_parameter {
	    set p_name [lindex $cmd 4];
	    set p_mapped_name [lindex $cmd 5];

	    if {$sess == ""} {
		set sess [$self add_session $addr $port $ttl];
		set sess_map_($sess,parameters) "conditional"
		set sess_map_($sess,outputs) 0;
		set sess_map_($sess,inputs) 0;
		set sess_map_($sess,misc) 0;
		set sess_map_($sess,debug) 0;
		set sess_map_($sess,trigger_cmds) 0;
		set sess_map_($sess,map_cmds) 0;
		set sess_map_($sess,parameters,mappings,$p_name) $p_mapped_name;
	    } else {
		if {$sess_map_($sess,parameters) == "conditional"} {
		    set sess_map_($sess,parameters,mappings,$p_name) $p_mapped_name;
		} elseif {$sess_map_($sess,parameters) == 0} {
		    set sess_map_($sess,parameters) "conditional";
		    set sess_map_($sess,parameters,mappings,$p_name) $p_mapped_name;
		}
	    }
	}
    }
}

GraphComm instproc recv_misc {cmd} {
#    puts "Received misc: $cmd";
}

GraphComm instproc new_input {new_name} {
    $self instvar input_names_ input_info_;

    lappend input_names_ $new_name;
    set input_info_($new_name,attr_list) "";
}

GraphComm instproc new_output {new_name} {
    $self instvar output_names_ output_info_;

    lappend output_names_ $new_name;
    set output_info_($new_name,attr_list) "";
}

GraphComm instproc new_parameter {new_name} {
    $self instvar parameter_names_ parameter_info_;

    lappend parameter_names_ $new_name;
    set parameter_info_($new_name,attr_list) "";
}

GraphComm instproc new_parameter_attribute {parameter_name attr_name} {
    $self instvar parameter_info_;

    lappend parameter_info_($parameter_name,attr_list) $attr_name;
}

GraphComm instproc new_output_attribute {output_name attr_name} {
    $self instvar output_info_;

    lappend output_info_($output_name,attr_list) $attr_name;
}

GraphComm instproc new_input_attribute {input_name attr_name} {
    $self instvar input_info_;

    lappend input_info_($input_name,attr_list) $attr_name;
}

GraphComm instproc update_parameter_attr_value {parameter_name attr_name value} {
    $self instvar parameter_info_;

    set parameter_info_($parameter_name,$attr_name,cur_value) $value;
}

GraphComm instproc update_output_attr_value {output_name attr_name value} {
    $self instvar output_info_;

    set output_info_($output_name,$attr_name,cur_value) $value;
}

GraphComm instproc update_input_attr_value {input_name attr_name value} {
    $self instvar input_info_;

    set input_info_($input_name,$attr_name,cur_value) $value;
}

GraphComm instproc create_input {input_name} {
    $self instvar input_names_;
    $self instvar input_info_;

    if {[lsearch $input_names_ $input_name] == -1} {
	lappend input_names_ $input_name;
	set input_info_($input_name,attr_list) "";
    }

    if {![info exists input_info_($input_name,local_cid)]} {
	$self instvar local_source_;
	$self instvar local_src_cids_;

	set input_info_($input_name,local_cid) [$local_source_ calloc $local_src_cids_(inputs) $input_name];
    }
}

GraphComm instproc create_output {output_name} {
    $self instvar output_names_;
    $self instvar output_info_;

    if {[lsearch $output_names_ $output_name] == -1} {
	lappend output_names_ $output_name;
	set output_info_($output_name,attr_list) "";
    }

    if {![info exists output_info_($output_name,local_cid)]} {
	$self instvar local_source_;
	$self instvar local_src_cids_;

	set output_info_($output_name,local_cid) [$local_source_ calloc $local_src_cids_(outputs) $output_name];
    }
}

GraphComm instproc create_parameter {parameter_name} {
    $self instvar parameter_names_;
    $self instvar parameter_info_;

    if {[lsearch $parameter_names_ $parameter_name] == -1} {
	lappend parameter_names_ $parameter_name;
	set parameter_info_($parameter_name,attr_list) "";
    }

    if {![info exists parameter_info_($parameter_name,local_cid)]} {
	$self instvar local_source_;
	$self instvar local_src_cids_;

	set parameter_info_($parameter_name,local_cid) [$local_source_ calloc $local_src_cids_(parameters) $parameter_name];
    }
}

GraphComm instproc create_input_attr {input_name attr_name} {
    $self instvar input_names_;
    $self instvar input_info_;

    if {[lsearch $input_names_ $input_name] == -1} {
	return;
    }

    if {![info exists input_info_($input_name,local_cid)]} {
	return;
    }

    if [info exists input_info_($input_name,attr_list)] {
	if {[lsearch $input_info_($input_name,attr_list) $attr_name] == -1} {
	    lappend input_info_($input_name,attr_list) $attr_name;
	}
    } else {
	lappend input_info_($input_name,attr_list) $attr_name;
    }

    if {![info exists input_info_($input_name,$attr_name,local_cid)]} {
	$self instvar local_source_;

	set input_info_($input_name,$attr_name,local_cid) [$local_source_ calloc $input_info_($input_name,local_cid) $attr_name];

	$self instvar read_adu_callback_map_;
	set read_adu_callback_map_($local_source_,$input_info_($input_name,$attr_name,local_cid)) "$self handle_input_attr_read_adu $input_name $attr_name ";

    }
}

GraphComm instproc create_output_attr {output_name attr_name} {
    $self instvar output_names_;
    $self instvar output_info_;

    if {[lsearch $output_names_ $output_name] == -1} {
	return;
    }

    if {![info exists output_info_($output_name,local_cid)]} {
	return;
    }

    if [info exists output_info_($output_name,attr_list)] {
	if {[lsearch $output_info_($output_name,attr_list) $attr_name] == -1} {
	    lappend output_info_($output_name,attr_list) $attr_name;
	}
    } else {
	lappend output_info_($output_name,attr_list) $attr_name;
    }

    if {![info exists output_info_($output_name,$attr_name,local_cid)]} {
	$self instvar local_source_;

	set output_info_($output_name,$attr_name,local_cid) [$local_source_ calloc $output_info_($output_name,local_cid) $attr_name];

	$self instvar read_adu_callback_map_;
	set read_adu_callback_map_($local_source_,$output_info_($output_name,$attr_name,local_cid)) "$self handle_output_attr_read_adu $output_name $attr_name ";
    }
}

GraphComm instproc create_parameter_attr {parameter_name attr_name} {
    $self instvar parameter_names_;
    $self instvar parameter_info_;

    if {[lsearch $parameter_names_ $parameter_name] == -1} {
	return;
    }

    if {![info exists parameter_info_($parameter_name,local_cid)]} {
	return;
    }

    if [info exists parameter_info_($parameter_name,attr_list)] {
	if {[lsearch $parameter_info_($parameter_name,attr_list) $attr_name] == -1} {
	    lappend parameter_info_($parameter_name,attr_list) $attr_name;
	}
    } else {
	lappend parameter_info_($parameter_name,attr_list) $attr_name;
    }

    if {![info exists parameter_info_($parameter_name,$attr_name,local_cid)]} {
	$self instvar local_source_;

	set parameter_info_($parameter_name,$attr_name,local_cid) [$local_source_ calloc $parameter_info_($parameter_name,local_cid) $attr_name];

	$self instvar read_adu_callback_map_;
	set read_adu_callback_map_($local_source_,$parameter_info_($parameter_name,$attr_name,local_cid)) "$self handle_parameter_attr_read_adu $parameter_name $attr_name ";
    }
}

GraphComm instproc set_input_attr {input_name attr_name value} {
    $self instvar input_info_;

    if {[info exists input_info_($input_name,$attr_name,local_cid)]} {

	$self instvar local_source_;

	$local_source_ send $input_info_($input_name,$attr_name,local_cid) $value
	set input_info_($input_name,$attr_name,cur_value) $value;
    }
}

GraphComm instproc set_output_attr {output_name attr_name value} {
    $self instvar output_info_;

    if {[info exists output_info_($output_name,$attr_name,local_cid)]} {

	$self instvar local_source_;

	$local_source_ send $output_info_($output_name,$attr_name,local_cid) $value
	set output_info_($output_name,$attr_name,cur_value) $value;
    }
}

GraphComm instproc set_parameter_attr {parameter_name attr_name value} {
    $self instvar parameter_info_

    if {[info exists parameter_info_($parameter_name,$attr_name,local_cid)]} {

	$self instvar local_source_;

	$local_source_ send $parameter_info_($parameter_name,$attr_name,local_cid) $value
	set parameter_info_($parameter_name,$attr_name,cur_value) $value;
    }
}

GraphComm instproc send_trigger_command {cmd} {
    $self instvar local_source_ local_src_cids_;

    $local_source_ send $local_src_cids_(trigger_cmds) $cmd;
}

GraphComm instproc send_map_command {cmd {store_data_flag 1}} {
    $self instvar local_source_ local_src_cids_;

    set seqno [$local_source_ send $local_src_cids_(map_cmds) $cmd];

    if {$store_data_flag} {
	$self instvar map_command_datastore_;
	set map_command_datastore_($seqno) $cmd;
    }
}

GraphComm instproc send_misc {misc_data {store_data_flag 1}} {
    $self instvar local_source_ local_src_cids_;

    set seqno [$local_source_ send $local_src_cids_(misc) $misc_data];

    if {$store_data_flag} {
	$self instvar misc_datastore_;
	set misc_datastore_($seqno) $misc_data;
    }
}


GraphComm instproc send_debug {data {store_data_flag 1}} {
    $self instvar local_source_ local_src_cids_;

    set seqno [$local_source_ send $local_src_cids_(debug) $data];

    if {$store_data_flag} {
	$self instvar debug_datastore_;
	set debug_datastore_($seqno) $data;
    }
}

GraphComm instproc recv_debug {data} {
#    puts "Received debug: $data";
}
