# fca-ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


set V(fonts) [new Fonts adobe]
option add *Font [$V(fonts) set helv10]

# Yatin's tkvar command.  This goes somewhere else...
Object instproc tkvar args {
    foreach var $args {
	uplevel upvar #0 $self/$var $var
    }
}

Object instproc tkvarname var {
    return $self/$var
}






Class FCA_UI


FCA_UI instproc attach_uimgr { uiMgr } {
    $self next
    $self set uiMgr_ $uiMgr
}


FCA_UI instproc attach_appmgr { appMgr } {
    $self set appMgr_ $appMgr
}



FCA_UI instproc build { path } {
    $self instvar main_book_ page1_ page2_

    frame $path
    bind $path <Destroy> "+delete $self"

    set main_book_ [new UIBook $path.main_book]
    pack $path.main_book -padx 10 -pady 5 -fill both -expand true

    set page1_ [$self build_floor_page $main_book_]
    set page2_ [$self build_queue_page $main_book_]
    set page3_ [$self build_srclist_page $main_book_]
    $self build_buttons $path.buttons
    $self build_request_menu
    $self build_srclist_menu

    $page1_ bring_to_top
}


FCA_UI instproc build_floor_page { book } {
    global V
    set page [new UIPage $book text "-text \"Floor\ncontrol\" \
	    -font [$V(fonts) set helv10b]"]
    Within [$page frame] {
	$self build_floorReq [WithinPath floorReq]
	$self build_status   [WithinPath status]
	$self set statusFrame_ [WithinPath status]
    }
    return $page
}



FCA_UI instproc build_queue_page { book } {
    global V
    set page [new UIPage $book text "-text \"Queue\nstatus\" \
	    -font [$V(fonts) set helv10b]"]
    Within [$page frame] {
	$self build_admittedList [WithinPath admittedList]
	$self build_pendingList  [WithinPath pendingList]
    }
    return $page
}


FCA_UI instproc build_srclist_page { book } {
    global V
    $self instvar srcList_
    set page [new UIPage $book text "-text \"Source\nlist      \" \
	    -font [$V(fonts) set helv10b]"]
    Within [$page frame] {
	set srcList_ [new UIList [WithinPath srcList] \
		{-width 225 -height 241 -bg white} 1 0]
	Pack srcList -fill both -expand 1

	$srcList_ proc on_ButtonPress_1 { id x y } \
	    "$self post_menu \[$self set srclist_menu_\] \
	    enable_srclist_menu \$id \$x \$y"
    }

    return $page
}


FCA_UI instproc build_buttons { path } {
    global exit_icon exit_press_icon
    imagebutton $path -image $exit_icon -pressimage $exit_press_icon \
	    -command "destroy ."
    pack $path -anchor e -padx 10 -pady 3 -side bottom
}


FCA_UI instproc build_admittedList { path } {
    $self instvar admittedList_
    Frame $path
    Pack $path -side top -fill x -expand 1
    Within $path {
	Label label -text "Admitted requests:" -anchor w
	Pack label -anchor w

	set admittedList_ [new UIList [WithinPath main] \
		{-width 225 -height 110 -bg white} 1 1]
	Pack main -fill x -expand 1
    }


    $admittedList_ proc build_item { path id info } \
	    "$self build_request_item \$path \$id"
    $admittedList_ proc on_ButtonPress_1 { id x y } \
	    "$self post_menu \[$self set request_menu_\] \
	    enable_admitted_menu \$id \$x \$y"

}


FCA_UI instproc build_pendingList { path } {
    $self instvar pendingList_
    Frame $path
    Pack $path -side top -fill x -expand 1
    Within $path {
	Label label -text "Pending requests:" -anchor w
	Pack label -anchor w -side top

	set pendingList_ [new UIList [WithinPath main] \
		{-width 225 -height 65 -bg white} 1 1]
	Pack main -fill x -expand 1
    }

    $pendingList_ proc build_item { path id info } \
	    "$self build_request_item \$path \$id"
    $pendingList_ proc on_ButtonPress_1 { id x y } \
	    "$self post_menu \[$self set request_menu_\] \
	    enable_pending_menu \$id \$x \$y"
}



FCA_UI instproc build_floorReq { path } {
    $self instvar commentPath_
    Frame $path -bd 1 -relief raised
    Pack $path -side top -fill x -expand 1 -padx 5 -pady 2
    Within $path {
	Label label -text "Comment:" -anchor w
	Pack label -anchor w -side top

	set commentPath_ [Text comment -bd 1 -relief sunken -bg white \
		-fg black -width 30 -height 3 -highlightthickness 0]
	Pack comment -anchor w -padx 5 -fill x -expand 1

	Frame split
	Pack split -expand 1 -fill x
	Within split {
	    $self build_floorlist [WithinPath floorlist]

	    Frame buttons
	    Pack buttons -side right -padx 5 -pady 3
	    Within buttons {
		Button request -text "Make request" -pady 0 -bd 1 \
			-highlightthickness 1 \
			-command "$self make_floor_request"
		Button follow -text "Follow on" -pady 0 -bd 1 \
			-highlightthickness 1 -state disabled
		Pack request follow -padx 3 -pady 1 -side top -anchor w \
			-fill x -expand 1
	    }
	}
    }
}



FCA_UI instproc build_floorlist { path } {
    Frame  $path
    Pack   $path -side left -padx 10 -pady 3
    Within $path {
	$self tkvar rbFloors_  # rb => radio-button
	set rbFloors_ Text-only
	trace variable rbFloors_ w "$self enable_selectfloors"
	Frame helper -bd 0 -relief flat
	RadioButton textonly -text "Text-only" -bd 1 -variable \
		[$self tkvarname rbFloors_] -value Text-only -pady 0 -anchor w
	RadioButton all -text "All" -variable [$self tkvarname rbFloors_]\
		-value All -pady 0 -anchor w -bd 1
	RadioButton select -text "Select floors" -bd 1 -variable \
		[$self tkvarname rbFloors_] -value Select -pady 0 -anchor w

	new UIMinimize [WithinPath min] [WithinPath selectFrame] 1 {} \
		Down_arrow_Icon Down_arrow_Icon
	Pack select min -in [WithinPath helper] -side left
	Pack textonly all helper -side top -anchor w -pady 0 -fill x
	$self build_selectfloors [WithinPath selectFrame]
    }

    $self instvar floors_
}


FCA_UI instproc build_selectfloors { path } {
    $self instvar selectfloors_path_ floors_
    Frame $path
    set selectfloors_path_ $path
    set floors_(all) {}
}


FCA_UI instproc enable_selectfloors { variable dummy op } {
    $self instvar floors_
    $self tkvar rbFloors_
    if { $rbFloors_=="Select" } {
	set state normal
    } else {
	set state disabled
    }

    foreach floortype $floors_(all) {
	$floors_($floortype,button) configure -state $state
    }
}




FCA_UI instproc build_status { path } {
    Frame $path -bd 1 -relief raised
    Pack $path -side top -fill x -expand 1 -padx 5 -pady 2
    Within $path {
	Label label -text "Floor status:" -anchor w
	Pack label  -anchor w -side top
    }
}









FCA_UI instproc create_floorstatus_entry { floorType floorInstObj } {
    set parentPath [$self statusFrame $floorType]
    set path $parentPath.instance_$floorInstObj
    label $path -bg [$parentPath cget -bg] -anchor w -text \
	    [[$self srcList] get_info [$floorInstObj srcId]]
    pack  $path -side top -fill x -expand 1
}


FCA_UI instproc destroy_floorstatus_entry { floorType floorInstObj } {
    set parentPath [$self statusFrame $floorType]
    set path $parentPath.instance_$floorInstObj
    catch { destroy $path }
}





FCA_UI instproc build_request_item { path request } {
    $self instvar uiMgr_
    frame $path -bd 1
    $path configure -bg [[winfo parent $path] cget -bg]

    foreach floorType [$request floorTypes] {
	$self build_floortype_label $path.floortype_$floorType $floorType
	pack $path.floortype_$floorType -padx 0 -pady 0 -side left
    }

    label $path.cname -text [$uiMgr_ cname [$request srcId]] -anchor w
    $path.cname configure -bg [[winfo parent $path.cname] cget -bg]
    pack $path.cname -side left -anchor w -fill x -expand 1
    #set comment [$request comment]
}


FCA_UI instproc build_floortype_label { path floorType } {
    $self instvar floors_
    label $path -image $floors_($floorType,icon) -padx 0 -pady 0 -bd 0 \
	    -highlightthickness 0 -relief flat
    $path configure -bg [[winfo parent $path] cget -bg]
}


FCA_UI instproc build_request_menu { } {
    $self instvar uiMgr_ listId_ request_menu_
    set menu .request_menu_$self
    menu $menu -tearoff 0
    $menu add command -label "Grant floor" -command "$uiMgr_ grant_floor \
	    \[$self currentListElement\]"
    $menu add command -label "Cancel request" -command "$uiMgr_ \
	    cancel_floor_request \[$self currentListElement\]"
    set request_menu_ $menu
}


FCA_UI instproc build_srclist_menu { } {
    $self instvar uiMgr_ listId_ srclist_menu_
    set menu .srclist_menu_$self
    menu $menu -tearoff 0
    $menu add command -label "Grant floor" -command \
	    "$self grant_floor_to_participant \[$self currentListElement\]"
    set srclist_menu_ $menu
}


FCA_UI instproc post_menu { menu enableMethod id x y } {
    $self set currentListElement_ $id
    $self $enableMethod $menu $id
    tk_popup $menu $x $y
}


FCA_UI instproc currentListElement { } {
    return [$self set currentListElement_]
}



FCA_UI instproc enable_admitted_menu { menu request } {
    # 0 = grant floor
    # 1 = cancel request
    $self instvar appMgr_
    $menu entryconfigure 0 -state disabled
    if { [$request srcId]==[[$appMgr_ localRcvr] srcId] } {
	$menu entryconfigure 1 -state normal
    } else {
	$menu entryconfigure 1 -state disabled
    }
}


FCA_UI instproc enable_pending_menu { menu request } {
    # 0 = grant floor
    # 1 = cancel request
    $menu entryconfigure 0 -state disabled
    $menu entryconfigure 1 -state normal
    # all pending requests are my own
}



FCA_UI instproc enable_srclist_menu { menu request } {
    # 0 = grant floor
    $menu entryconfigure 0 -state disabled
}



Class FCA_UI/Moderator -superclass FCA_UI


FCA_UI/Moderator instproc enable_admitted_menu { menu request } {
    # 0 = grant floor
    # 1 = cancel request

    # moderator can do everything!
    $menu entryconfigure 0 -state normal
    $menu entryconfigure 1 -state normal
}


FCA_UI/Moderator instproc enable_pending_menu { menu request } {
    # 0 = grant floor
    # 1 = cancel request
    $menu entryconfigure 0 -state disabled
    $menu entryconfigure 1 -state normal
}


FCA_UI/Moderator instproc enable_srclist_menu { menu request } {
    # 0 = grant floor
    $menu entryconfigure 0 -state normal
}










FCA_UI instproc add_floor { floortype label icon } {
    puts "adding floor for $floortype"
    $self instvar selectfloors_path_ floors_
    $self tkvar rbFloors_

    # add this floor type to the selection panel
    Within $selectfloors_path_ {
	lappend floors_(all) $floortype
	set floors_($floortype,label) $label
	set floors_($floortype,icon)  $icon
	set floors_($floortype,var)   floor_var_$floortype

	$self tkvar $floors_($floortype,var)
	set $floors_($floortype,var) 0
	set floors_($floortype,button) [WithinPath floorbutton_$label]
	CheckButton $floors_($floortype,button) -text $label -bd 1 -anchor w \
		-highlightthickness 1 -variable [$self tkvarname \
		$floors_($floortype,var)]
	if { $rbFloors_!="Select" } {
	    $floors_($floortype,button) configure -state disabled
	}

	Pack $floors_($floortype,button) -pady 0 -fill x -anchor w
    }

    # add this floor type to the status panel
    $self instvar statusFrame_
    Within $statusFrame_ {
	Frame floorstatus_$floortype -bd 0 -highlightthickness 0
	Pack  floorstatus_$floortype -padx 2 -pady 1 -fill x -expand 1
	Within floorstatus_$floortype {
	    Label label -text $label -anchor w
	    set frame [Frame frame -bd 1 -relief sunken -bg White]
	    Pack label -side left
	    Pack frame -side left -expand 1 -fill x
	    Within frame {
		if { $icon != {} } {
		    Label icon -image $icon -bg [$frame cget -bg]
		    set floors_($floortype,statusFrame) [Frame frame \
			    -bg [$frame cget -bg]]
		    Pack icon -side left
		    Pack frame -fill x -expand 1 -side left
		}
	    }
	}
    }

}


FCA_UI instproc get_floor_label { floortype } {
    $self instvar floors_
    if { [info exists floors_($floortype,label)] } {
	return $floors_($floortype,label)
    }
    return ""
}


FCA_UI instproc floortype_from_label { label } {
    $self instvar floors_
    foreach entry [array names floors_ "*,label"] {
	if { $floors_($entry)==$label } {
	    set floorType ""
	    regexp "(.*),label" $entry dummy floorType
	    return $floorType
	}
    }
    return ""
}


FCA_UI instproc admittedList { } {
    return [$self set admittedList_]
}


FCA_UI instproc pendingList { } {
    return [$self set pendingList_]
}


FCA_UI instproc srcList { } {
    return [$self set srcList_]
}


FCA_UI instproc statusFrame { floorType } {
    $self instvar floors_
    return [$self set floors_($floorType,statusFrame)]
}



FCA_UI instproc make_floor_request { } {
    $self tkvar rbFloors_
    $self instvar floors_
    switch $rbFloors_ {
	Text-only {
	    set floorTypes {}
	}
	All {
	    set floorTypes $floors_(all)
	}
	Select {
	    set floorTypes {}
	    foreach type $floors_(all) {
		$self tkvar $floors_($type,var)
		if { [set $floors_($type,var)] } {
		    # this box has been checked
		    lappend floorTypes $type
		}
	    }
	}
    }

    $self instvar commentPath_ uiMgr_
    $uiMgr_ make_floor_request $floorTypes [$commentPath_ get 1.0 end]
    $commentPath_ delete 1.0 end
}


FCA_UI instproc grant_floor_to_participant { src } {
    # src is the SRM_Source object!

    $self instvar uiMgr_ floors_
    $uiMgr_ grant_floor_to_participant $floors_(all) [$src srcid]
}

