# simple-video-tx.tcl --
#
#       A simple video transmitter
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#if {[catch {source [file join $env(TCLCL_IMPORT_DIRS) import.tcl]} res]} {
#	puts "error sourcing the import.tcl initialization script: $res"
#}


Import enable
import Application AddressBlock VideoAgent VideoPipeline

Class SimpleVideoApp -superclass Application

SimpleVideoApp instproc init {} {
	$self next sv
	$self add_default defaultTTL 16
	$self instvar agent_ vpipe_
	set agent_ [new VideoAgent $self 224.1.2.3/12345]
	set vpipe_ [new VideoPipeline $agent_]
}

SimpleVideoApp instproc run {} {
	$self instvar agent_ vpipe_
	# puts here the different options and (maybe) use 

	# get a list of all video-capture devices
	set device_list [$vpipe_ input_devices]

	# use the first one of the list
	set device [lindex $device_list 0]

	# select the video-compression format for this device to be ITU's H.261
	$vpipe_ select $device h261

	# select the quality factor for the video-compression format
	$vpipe_ set_quality 10

	# start the VideoPipeline
	$vpipe_ start
}

SimpleVideoApp instproc enhance {} {
	$self instvar agent_ vpipe_

	# FIXME: this requires more information on how to know which arguments 
	#	are valid for each method

	$vpipe_ set_port Composite1
	$vpipe_ set_norm ntsc

	$vpipe_ set_quality 100
	$vpipe_ set_fps 30
	$vpipe_ set_bps 3000000

	#$agent_ sessionbw 1000
	#$agent_ local_bandwidth 1000

	#set tap_ [$vpipe_ set tap_] 
	#$tap_ set_bps 30
	#set grabber_ [$tap_ set grabber_]
	#$tap_ set device_
	#$grabber_ fps 30
	#$grabber_ norm pal
	#$grabber_ norm ntsc
}



set app [new SimpleVideoApp]
$app run
$app enhance
vwait forever


###########

source [file join $env(TCLCL_IMPORT_DIRS) import.tcl]

Import enable
import Application AddressBlock VideoAgent VideoPipeline

Class SimpleVideoApp -superclass Application

Class MyAgent

SimpleVideoApp instproc init {} {
	$self next sv
	$self add_default defaultTTL 16
	$self instvar agent_ vpipe_
	set agent_ [new MyAgent]
	set vpipe_ [new VideoPipeline $agent_]
}

MyAgent instproc get_local_srcid {args} {
	puts "MyAgent::get_local_srcid called with $args"
}
MyAgent instproc get_transmitter {args} {
	puts "MyAgent::get_transmitter called with $args"
	return [new MyPacket]
}

Class MyPacket
MyPacket instproc recv {args} {
	puts "MyPacket::recv called with $args"
}

set app [new SimpleVideoApp]
#
#SimpleVideoApp instproc run
#
set vpipe_ [$app set vpipe_]
set device_list [$vpipe_ input_devices]
set device [lindex $device_list 0]
$vpipe_ select $device h261
$vpipe_ set_quality 10
$vpipe_ start

