# scanconv.tcl --
#
#       Talks to amxd to control scan converter and provides GUI
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import 405Client

global g_mode

Class ScanConvInterface

ScanConvInterface instproc init {amxHost amxPort {base ""}} {
    global g_mode
    $self instvar 405_

    set 405_ [new 405Client $amxHost $amxPort]
    $self InitUI $base
}

ScanConvInterface instproc InitUI {{base_frame ""}} {
    global g_mode
    $self instvar 405_

    wm title . "Scan Converter Adjustment"
    wm minsize . 150 0

    set g_mode "1024x768"

    set cur_frame "$base_frame.select_frame"
    frame $cur_frame
    pack $cur_frame -fill x -side left -pady 10
    label $cur_frame.label -text "Mode"
    pack $cur_frame.label -side top
    frame $cur_frame.640
    pack $cur_frame.640 -side top -fill x -padx 20
    radiobutton $cur_frame.640.but -text "640x480" -variable g_mode -value "640x480" -command "$self changeMode"
    pack $cur_frame.640.but -side left
    frame $cur_frame.800
    pack $cur_frame.800 -side top -fill x -padx 20
    radiobutton $cur_frame.800.but -text "800x600" -variable g_mode -value "800x600" -command "$self changeMode"
    pack $cur_frame.800.but -side left
    frame $cur_frame.1024
    pack $cur_frame.1024 -side top -fill x -padx 20
    radiobutton $cur_frame.1024.but -text "1024x768" -variable g_mode -value "1024x768" -command "$self changeMode"
    pack $cur_frame.1024.but -side left
    frame $cur_frame.sgi
    pack $cur_frame.sgi -side top -fill x -padx 20
    radiobutton $cur_frame.sgi.but -text "sgi" -variable g_mode -value "sgi" -command "$self changeMode"
    pack $cur_frame.sgi.but -side left

    set g_mode "1024x768"


    set cur_frame "$base_frame.size_frame"
    frame $cur_frame
    pack $cur_frame -side left -pady 10 -padx 10
    label $cur_frame.label -text "Size"
    pack $cur_frame.label -side top

    set canv "$cur_frame.position_canvas"
    canvas $canv -width 150 -height 100 -borderwidth 0
    pack $canv -side top
    set widearrow "10 4 10 9 19 0 10 -9 10 -4 -10 -4 -10 -9 -19 0 -10 9 -10 4"

    set p_wide [eval $canv create polygon $widearrow -tags \{wide arrow\}]
    set narrowarrow "-19 4 -9 4 -9 9 0 0 9 9 9 4 19 4 19 -4 9 -4 9 -9 0 0 -9 -9 -9 -4 -19 -4"
    set p_narrow [eval $canv create polygon $narrowarrow -tags \{narrow arrow\}]
    set tallarrow "4 10 9 10 0 19 -9 10 -4 10 -4 -10 -9 -10 0 -19 9 -10 4 -10"
    set p_tall [eval $canv create polygon $tallarrow -tags \{tall arrow\}]
    set shortarrow "0 0 9 9 4 9 4 19 -4 19 -4 9 -9 9 0 0 -9 -9 -4 -9 -4 -19 4 -19 4 -9 9 -9"
    set p_short [eval $canv create polygon $shortarrow -tags \{short arrow\}]


    $canv bind wide <ButtonPress-1> "$405_ scanConv_adjustSize wide"
    $canv bind narrow <ButtonPress-1> "$405_ scanConv_adjustSize narrow"
    $canv bind tall <ButtonPress-1> "$405_ scanConv_adjustSize tall"
    $canv bind short <ButtonPress-1> "$405_ scanConv_adjustSize short"

    #"$405_ scanConv_adjustPosition up"
    $canv move wide -20 -12
    $canv move narrow -20 12
    $canv move tall 25 0
    $canv move short 47 0
    $canv move all 45 35
    $canv scale all 0 0 1.4 1.4


    set cur_frame "$base_frame.position_frame"
    frame $cur_frame
    pack $cur_frame -side left -pady 10 -padx 10
    label $cur_frame.label -text "Position"
    pack $cur_frame.label -side top

    set canv "$cur_frame.position_canvas"
    canvas $canv -width 100 -height 100 -borderwidth 0
    pack $canv -side top
    set uparrow " -6 -9	 -6 -23	 -14 -23  0 -35	 14 -23	 6 -23	 6 -9  -6 -9"
    set dnarrow " -6  9	 -6  23	 -14  23  0  35	 14  23	 6  23	 6  9  -6  9"
    set ltarrow " -9 -6	 -23 -6	 -23 -14  -35 0	 -23 14	 -23 6	 -9 6  -9 -6"
    set rtarrow "  9 -6	  23 -6	  23 -14   35 0	  23 14	  23 6	  9 6	9 -6"
    set p_up [eval $canv create polygon $uparrow -tags \{up arrow\}]
    set p_dn [eval $canv create polygon $dnarrow -tags \{dn arrow\}]
    set p_lt [eval $canv create polygon $ltarrow -tags \{lt arrow\}]
    set p_rt [eval $canv create polygon $rtarrow -tags \{rt arrow\}]
    $canv bind up <ButtonPress-1> "$405_ scanConv_adjustPosition up"
    $canv bind dn <ButtonPress-1> "$405_ scanConv_adjustPosition down"
    $canv bind lt <ButtonPress-1> "$405_ scanConv_adjustPosition left"
    $canv bind rt <ButtonPress-1> "$405_ scanConv_adjustPosition right"
    $canv scale all 0 0 1.2 1.2
    # 0,0 is the top left, so move 0, 0 to the center of the canvas
    $canv move all 50 50
}

ScanConvInterface instproc changeMode {} {
    global g_mode
    $self instvar 405_

    $405_ scanConv_switchMode $g_mode
}

ScanConvInterface instproc destroy {} {
    $self instvar 405_

    $405_ closeConnection
}

