# ui-main.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-main.tcl,v 1.22 2002/02/03 04:21:46 lim Exp $


import AudioPanel AudioControlMenu MultiSourceManager ScrolledListbox \
		VisualFrame TipManager MultiSourceIcons VideoContainer \
		MultiControlMenu UIMinimize Observer/Mb Observer/Mbv2 \
		PaneManager RoverPanel MBv2UI CollaboratorIcons MashLogoIcon

Class CollaboratorUI -superclass Observer -configuration {
	sessionType rtp
	speakerMute false
	inputPort {mike microphone mic}
	outputPort {speaker wave}
	mikeAGC false
	speakerAGC false
	buttonforeground gray40
	meterEnable true
}


CollaboratorUI public unknown {args} {
	puts "invoked unknown $args"
}


CollaboratorUI instproc keep-sorted {sense} {
    # FIXME
    # The code below is what vat would do, but collaborator doesn't have a
    # Sitebox.  This method is just here for now to silence the "invoked
    # unknown" message.
    #
    # [$self set sitebox_] keep-sorted $sense
}


CollaboratorUI public init { usemega exitCmd } {
	$self set useMega_ $usemega
	$self set exitCmd_ $exitCmd

	$self instvar as_
	set as_(video) 0
	set as_(audio) 0
	set as_(mb)    0
	set as_(mars)  0
	$self next
}


CollaboratorUI public default_options {prefix} {
	set defaults {
		{ *Menu*borderWidth 1 }
		{ *Menu*activeBorderWidth 1 }
		{ *Menu*font WidgetDefault }
		{ *ScrolledListbox.scrollbar both }
		{ *ScrolledListbox.bbox.highlightThickness 1 }
		{ *ScrolledListbox.Scrollbar.borderWidth 1 }
		{ *ScrolledListbox.Scrollbar.highlightThickness 1 }
		{ *ScrolledListbox.Scrollbar.width 10 }
		{ *ScrolledListbox*Canvas.width 225 }
		{ *ScrolledListbox*Canvas.height 120 }
		{ *ScrolledWinMgr.scrollbar both }
		{ *ScrolledWinMgr.Scrollbar.borderWidth 1 }
		{ *ScrolledWinMgr.Scrollbar.highlightThickness 1 }
		{ *ScrolledWinMgr.Scrollbar.width 10 }
		{ *ScrolledListbox/CanvasList*Canvas.relief sunken }
		{ *ScrolledListbox/CanvasList*Canvas.borderWidth 1 }
		{ *AudioPanelPane*borderWidth 1 }
	}

	foreach optval $defaults {
		set option [lindex $optval 0]
		set value [lindex $optval 1]
		option add ${prefix}$option $value widgetDefault
	}

	set defaults {
		{ *ScrolledWindow.scrollbar both }
		{ *ScrolledWindow.Scrollbar.borderWidth 1 }
		{ *ScrolledWindow.Scrollbar.highlightThickness 1 }
		{ *ScrolledWindow.Scrollbar.width 10 }
		{ *ScrolledWindow*Canvas.height 300 }
	}

	foreach optval $defaults {
		set option [lindex $optval 0]
		set value [lindex $optval 1]
		option add $option $value widgetDefault
	}

	option add ${prefix}*AudioPanelPane*borderWidth 1
}


CollaboratorUI public build_widget { path } {
	$self instvar sm_ path_ paneMgrs_ useMega_

	set path_ $path
	$self default_options "*[$path cget -class]"

	# create the menubar

	# in mplug mode, if the toplevel is . we will have problems making
	# $path.menu the menu of the toplevel, so let's just make a menu
	# button for it
	global mash
	if { [info exists mash(environ)] && $mash(environ)=="mplug" && \
			[winfo toplevel $path]=="." } {
		#menubutton $path.menubutton -bd 1 -text "Menu..." \
		#		-menu $path.menu
		#pack $path.menubutton -in $path.bottom -side left -fill y \
		#		-after $path.label

		menu $path.menu -type menubar
		$self build_menu $path.menu
		pack $path.menu -side top -fill x
	} else {
		menu $path.menu -type menubar
		$self build_menu $path.menu
		[winfo toplevel $path] configure -menu $path.menu
	}

	# create the container frames

	frame $path.frame
	frame $path.bottom -bd 2 -relief ridge

	# must create this label here, since the arbiter is going to
	# try to set its font
	label $path.label

	# create a source manager widget
	if [$self get_local_option have_mb] {
		# must create the "enable mb hack" button
		$self tkvar mb_hack_
		set mb_hack_ 0
		frame $path.list
		checkbutton $path.hack -text "Enable MB cname hack" \
				-variable [$self tkvarname mb_hack_] \
				-command "$self enable_mb_hack" \
				-bd 1 -anchor w
		pack $path.hack -in $path.list -side bottom -fill x
		set list $path.list_with_hack
	} elseif [$self get_local_option have_mbv2] {
		frame $path.list
		set list $path.mbv2list
		$self set mbv2_list_frame_  $path.list
		$self set mbv2_member_list_ $list
	} else { set list $path.list }

	frame $list
	label $list.label -anchor w -text "Member list:" -bd 1 -relief raised
	ScrolledListbox ${list}.list -itemclass UIMultiSource -scrollbar both
	set sm_ [new MultiSourceManager ${list}.list]
	pack $list.label -fill x
	pack $list.list -fill both -expand 1

	if { [$self get_local_option have_mb] || \
			[$self get_local_option have_mbv2] } {
		pack $list -in $path.list -fill both -expand 1 -side top
	}

	# create MultiControlMenu
	set cm [new MultiControlMenu .menu $self]
	$self set_local_option controlmenu $cm

	# create a rover panel if required
	if [$self get_local_option have_rover] {
		frame $path.rest
		raise $path.rest $path.frame
		$self make_rover_panel $path.roverpanel
		set encloser $path.rest
	} else {
		set encloser $path.frame
	}

	# create an mb panel if required
	if [$self get_local_option have_mb] {
		frame $path.mbpanel -class MbPanel
		$self make_mb_panel $path.mbpanel

		set mcm [$cm add_mb_page]
		set observers(mb) [new Observer/Mb $sm_ \
				[[$self get_local_option mbUI] source_list]]
		$self set_local_option observer,mb $observers(mb)
		if $useMega_ {
			$cm original_session_spec mb \
					[$self get_option mbSessionSpec]
		}
	}

	# create an mbv2 panel if required
	if [$self get_local_option have_mbv2] {
		#frame $path.mbv2panel -class Mbv2Panel
		$self make_mbv2_panel $path.mbv2panel

		set mcm [$cm add_mbv2_page]
		set observers(mbv2) [new Observer/Mbv2 $sm_ \
				[$self get_local_option mbv2UI]]
		$self set_local_option observer,mbv2 $observers(mbv2)
		if $useMega_ {
			$cm original_session_spec mbv2 \
					[$self get_option mbv2SessionSpec]
		}
	}

	# create a video panel if required
	if [$self get_local_option have_video] {
		set videoAgent [$self get_local_option videoAgent]
		set scubaSess [$self get_local_option scubaSession]
		set canVoiceSwitch [$self get_local_option can_voiceswitch]

		set vc [$self make_video_panel $path.videopanel]

		set observers(video) [new Observer/Video $sm_ $videoAgent $vc\
				$canVoiceSwitch $scubaSess]
		$self set_local_option observer,video $observers(video)
		if $canVoiceSwitch {
			[$self get_local_option local_channel] register \
					FOCUS_SPEAKER \
					"$observers(video) focus_speaker"
		}

		set visualFrame [new VisualFrame $path.visual]
		# FIXME use_hw_decoder
		UISource/Video decoder_params [$visualFrame set colorModel_] 0
		$visualFrame attach_observer $observers(video)
		$self set_local_option visualFrame $visualFrame

		set vcm [$cm add_video_page]
		if $useMega_ {
			$cm original_session_spec video \
					[$self get_option videoSessionSpec]
		}
	}

	# create an audio panel if required
	if [$self get_local_option have_audio] {
		set audioAgent [$self get_local_option audioAgent]
		frame $path.audiopanel -class AudioPanel
		set panel [$self make_audio_panel $path.audiopanel]
		$self set_local_option audioPanel $panel
		set acm [$cm add_audio_page]
		set observers(audio) [new Observer/Audio $sm_ $audioAgent \
				$panel $acm]
		$self set_local_option observer,audio $observers(audio)
		if $useMega_ {
			$cm original_session_spec audio \
					[$self get_option audioSessionSpec]
		}

		set a [$panel set arbiter_]
		$a attach_observer $self
		$a indicator_update
	}

	# create the various pane managers
	set have {}
	if [$self get_local_option have_mb   ] { append have m }
	if [$self get_local_option have_mbv2 ] { append have m }
	if [$self get_local_option have_video] { append have v }
	if [$self get_local_option have_audio] { append have a }

	if [$self get_local_option have_mb] { set mbpanel $path.mbpanel } \
			else { set mbpanel $path.mbv2panel }
	if { $have=="mva" || $have=="mv" } {
		frame $path.mv
		raise $path.mv $encloser
		set paneMgrs_(mv) [new PaneManager $mbpanel \
				$path.videopanel -in $path.mv -orient vertical\
				-percent 0.65]
	}

	if { $have=="mva" || $have=="ma" || $have=="va" } {
		switch $have {
			mva { set left $path.mv; set per 0.82 }
			ma { set left $mbpanel; set per 0.8 }
			va { set left $path.videopanel; set per 0.65 }
		}

		frame $path.mva
		raise $path.mva $encloser
		set paneMgrs_(audio) [new PaneManager $left $path.audiopanel \
				-in $path.mva -orient horizontal -percent $per]
	}

	switch $have {
		m   { set right $mbpanel; set per 0.3 }
		v   { set right $path.videopanel; set per 0.6 }
		a   { set right $path.audiopanel; set per 0.73 }
		mv  { set right $path.mv; set per 0.3 }
		ma  { set right $path.mva; set per 0.3 }
		va  { set right $path.mva; set per 0.4 }
		mva { set right $path.mva; set per 0.3 }
	}

	set paneMgrs_(list) [new PaneManager $path.list $right -in $encloser\
			-orient horizontal -percent $per]

	if [$self get_local_option have_rover] {
		set paneMgrs_(rover) [new PaneManager $encloser \
				$path.roverpanel -in $path.frame \
				-orient vertical -percent 0.85]
	}

	if { $useMega_ || [$self get_local_option have_rover] } {
		$path.label configure -text "Contacting service..." -anchor w
	} else {
		global mash
		$path.label configure -text "Collaborator v$mash(version)"
	}
	button $path.control -text "Properties..." -command \
			"\[$self get_local_option controlmenu\] toggle" \
			-bd 1 -highlightthickness 0
	button $path.quit -text "Quit" -command [$self set exitCmd_] -bd 1 \
			-highlightthickness 0
	pack $path.label -in $path.bottom -fill both -expand 1 -side left
	pack $path.control -in $path.bottom -side left
	pack $path.quit -in $path.bottom -side left
	pack $path.bottom -fill x -side bottom
	pack $path.frame -fill both -expand 1

	# explicitly set the geometry of the toplevel window
	set top [winfo toplevel $path]
	global mash
	if { $mash(environ) == "mplug" } { set top $path }
	if ![pack propagate $top] {
        # For some unknown reason, you have to force an update before you set
        # the window geometry on Windows.
        update idletasks
		switch $have {
			mva { $top configure -width 800 -height 600 }
			mv  { $top configure -width 800 -height 600 }
			ma  { $top configure -width 680 -height 480 }
			va  { $top configure -width 480 -height 410 }
			v   { $top configure -width 480 -height 410 }
			m   { $top configure -width 640 -height 480 }
			a   { $top configure -width 335 -height 320 }
		}
	}
}




#
# Called by AudioArbiter through the observer mechanism.
#
CollaboratorUI public arbiter_snatch {} {
	$self instvar path_
	set cm [$self get_local_option controlmenu,audio]
	if [$cm query autoRaise] {
                raise [winfo toplevel $path_]
        }
}


CollaboratorUI public arbiter_have {flag} {
	$self instvar path_
	set titleBar $path_.label
        if $flag {
                $titleBar configure -font [$self get_option helv10b]
        } else {
                $titleBar configure -font [$self get_option noAudioFont]
        }
}



CollaboratorUI public build_menu {menu} {
	$menu add cascade -label "File" -menu $menu.file
	menu $menu.file
	$menu.file add command -label "Properties..." -command \
			"\[$self get_local_option controlmenu\] toggle"

	$menu.file add separator
	$menu.file add command -label "Quit" -command [$self set exitCmd_]

	$menu add cascade -label "Help" -menu $menu.help
	menu $menu.help
	$menu.help add command -label "Help..."
	$menu.help add command -label "About Collaborator..." \
			-command "$self about"
}


CollaboratorUI public build_mbv2_menu { menu } {
	set mbv2ui [$self get_local_option mbv2UI]
	set tools_toolbar_ [$mbv2ui tools_toolbar]
	set canvmgr_ [$mbv2ui canvmgr]
	set select [$tools_toolbar_ tool MBv2SelectTool]

	$menu.file insert 1 command -label "Save whiteboard as PS..." \
			-command "$canvmgr_ save_as_postscript"

	$menu add cascade -label "Edit" -menu $menu.edit -state disabled
	menu $menu.edit -postcommand "$mbv2ui configure_edit_menu $menu.edit"
	$menu.edit add command -label "Undo"   -accelerator <Ctl-Z> \
			-command "$tools_toolbar_ undo" -state disabled
	$menu.edit add command -label "Redo"   -accelerator <Shift-Ctl-Z> \
			-command "$tools_toolbar_ redo" -state disabled
	$menu.edit add separator
	$menu.edit add command -label "Cut"    -accelerator <Ctl-X> \
			-command "$select cut"   -state disabled
	$menu.edit add command -label "Copy"   -accelerator <Ctl-C> \
			-command "$select copy"  -state disabled
	$menu.edit add command -label "Paste"  -accelerator <Ctl-V> \
			-command "$select paste" -state disabled
	$menu.edit add command -label "Delete" -accelerator <Del>   \
			-command "$select delete" -state disabled
	$menu.edit add separator
	$menu.edit add cascade -label "Ordering" -menu $menu.edit.order \
			-state disabled

	menu $menu.edit.order
	$menu.edit.order add command -label "Bring to front"
	$menu.edit.order add command -label "Send to back"
	$menu.edit.order add command -label "Bring forward"
	$menu.edit.order add command -label "Send backward"


	$menu add cascade -label "Tools" -menu $menu.tools -state disabled
	menu $menu.tools
	$menu.tools add command -label "Freehand/Text" -command \
			"$tools_toolbar_ invoke MBv2DrawTextTool"
	$menu.tools add command -label "Arrow" -command \
			"$tools_toolbar_ invoke MBv2ArrowTool"
	$menu.tools add command -label "Rectangle" -command \
			"$tools_toolbar_ invoke MBv2RectTool"
	$menu.tools add command -label "Oval" -command \
			"$tools_toolbar_ invoke MBv2OvalTool"
	$menu.tools add command -label "Select" -command \
			"$tools_toolbar_ invoke MBv2SelectTool"
	$menu.tools add cascade -label "Insert..." -menu $menu.tools.insert

	menu $menu.tools.insert
	$menu.tools.insert add command -label "Image..." -command \
			"$mbv2ui import image"
	$menu.tools.insert add command -label "Text..." -command \
			"$mbv2ui import text"

	$menu add cascade -label "Options" -menu $menu.options -state disabled
	menu $menu.options -postcommand \
			"$self configure_options_menu $menu.options"
	$self tkvar show_mbv2_page_list_
	set show_mbv2_page_list_ 0
	$menu.options add checkbutton -label "Show page list" \
			-variable [$self tkvarname show_mbv2_page_list_] \
			-command "$self show_mbv2_page_list \[set [$self \
			tkvarname show_mbv2_page_list_]\]"
	$mbv2ui tkvar show_tips_dummy_
	set show_tips_ 1
	$menu.options add checkbutton -label "Show tips" \
			-variable [$mbv2ui tkvarname show_tips_] \
			-command "TipManager enable \[set [$mbv2ui tkvarname \
			show_tips_]\]"
	$menu.options add cascade -label "Show owner of item..." \
			-menu $menu.options.tips
	menu $menu.options.tips
	$mbv2ui tkvar tips_when_drawn_ tips_under_cursor_
	$menu.options.tips add checkbutton -label "when drawn" \
			-variable [$mbv2ui tkvarname tips_when_drawn_] \
			-command "$mbv2ui show_owner_when_drawn \
			\[set [$mbv2ui tkvarname tips_when_drawn_]\]"
	$menu.options.tips add checkbutton -label "under cursor (Select mode)"\
			-variable [$mbv2ui tkvarname tips_under_cursor_] \
			-command "$mbv2ui show_owner_under_cursor \
			\[set [$mbv2ui tkvarname tips_under_cursor_]\]"
	set tips_when_drawn_   1; $mbv2ui show_owner_when_drawn   1
	set tips_under_cursor_ 1; $mbv2ui show_owner_under_cursor 1

	$menu.options add command -label "Simulate packet drop..." -command \
			"$mbv2ui simulate_packet_drop"
}


CollaboratorUI private configure_options_menu { menu } {
	set mbv2ui [$self get_local_option mbv2UI]
	$mbv2ui configure_options_menu $menu
	$self tkvar show_mbv2_page_list_
	$self instvar mbv2_list_pane_mgr_
	set show_mbv2_page_list_ [info exists mbv2_list_pane_mgr_]
}


CollaboratorUI private show_mbv2_page_list { f } {
	$self instvar mbv2_list_frame_ mbv2_member_list_ mbv2_page_list_ \
			mbv2_list_pane_mgr_
	set mbv2ui [$self get_local_option mbv2UI]
	set canvmgr [$mbv2ui canvmgr]
	$canvmgr set_show_canvas_list $f
	if $f {
		if ![info exists mbv2_page_list_] {
			set mbv2_page_list_ $mbv2_list_frame_.pagelist
			$canvmgr create_canvas_list $mbv2_page_list_
		}
		pack forget $mbv2_member_list_
		set mbv2_list_pane_mgr_ [new PaneManager $mbv2_member_list_ \
				$mbv2_page_list_ -in $mbv2_list_frame_ \
				-orient vertical -percent 0.7]
	} else {
		delete $mbv2_list_pane_mgr_
		unset mbv2_list_pane_mgr_
		pack $mbv2_member_list_ -in $mbv2_list_frame_ -fill both \
				-expand 1 -side top
	}
}


CollaboratorUI private mb_minimize { operation } {
	$self instvar path_
	if { $operation == "minimize" } {
		pack configure $path_.video_mb -fill none -expand 0
	} else {
		pack configure $path_.video_mb -fill both -expand 1
	}
}


CollaboratorUI public set_local_option { option value } {
	$self instvar local_options_
	set local_options_($option) $value
}


CollaboratorUI public get_local_option { option } {
	$self instvar local_options_
	if [info exists local_options_($option)] {
		return $local_options_($option)
	}
}



#
CollaboratorUI private make_audio_panel { w } {
	set audioAgent [$self get_local_option audioAgent]
	set panel [new AudioPanel $w $audioAgent]
	$self set_local_option audioPanel $panel


	#FIXME: copied from tcl/vat/ui-main.tcl
	global inputPortButton outputPortButton inputScale outputScale
	set ports [$audioAgent get_input_ports]
	if { [llength $ports] <= 1 } {
		$inputPortButton configure -state disabled \
			-disabledforeground [$self get_option buttonforeground]
	}
	set plist [$self get_option inputPort]
	set pname ""
	foreach elt $plist {
		if {[lsearch [string tolower $ports] $elt] >= 0} {
			set pname $elt
		}
	}
	if { $pname == "" } {
		set pname [lindex $ports 0]
	}
	$panel setPort input $inputPortButton $inputScale $pname

	set ports [$audioAgent get_output_ports]
	if { [llength $ports] <= 1 } {
		$outputPortButton configure -state disabled \
			-disabledforeground [$self get_option buttonforeground]
	}
	set plist [$self get_option outputPort]
	set pname ""
	foreach elt $plist {
		if {[lsearch [string tolower $ports] $elt] >= 0} {
			set pname $elt
		}
	}
	if { $pname == "" } {
		set pname [lindex $ports 0]
	}
	$panel setPort output $outputPortButton $outputScale $pname


	#global outputScale inputScale
	#$outputScale set [$audioAgent get_output_gain]
	#$inputScale set [$audioAgent get_input_gain]
	set meterEnable [$self yesno meterEnable]
	$panel enable_meters $meterEnable
	return $panel
}


#
CollaboratorUI private make_video_panel { w } {
	if { [$self get_local_option have_mb] || \
			[$self get_local_option have_mbv2] } \
			{ set orient horizontal } else { set orient vertical }
	return [new VideoContainer $w 2 qcif $orient]
}


#
CollaboratorUI public make_mb_panel { w } {
	set mbMgr  [$self get_local_option mbMgr]
	set mbSndr [$self get_local_option mbSender]
	set mbui [new MBUI $w $mbMgr $mbSndr [$self get_option showUI] ""]
	$mbui proc window_title { args } { }
	$self set_local_option mbUI $mbui
}


CollaboratorUI public make_mbv2_panel { w } {
	$self instvar path_
	set mbv2ui [new MBv2UI $w]
	$self set_local_option mbv2UI $mbv2ui

	if { [$self get_local_option have_mbv2] == "1" } {
		$self build_mbv2_menu $path_.menu
	}
}


CollaboratorUI public make_rover_panel { w } {
	RoverPanel $w
	$self set rover_panel_path_ $w
	$w ssac_client [$self get_local_option ssacClient]
}


CollaboratorUI public set_rover_offset { offset } {
	$self instvar rover_panel_path_
	$rover_panel_path_ move_slider $offset
}


CollaboratorUI public activate_slider { start end } {
	$self instvar rover_panel_path_
	$rover_panel_path_ activate_slider $start $end
}


CollaboratorUI public update_title { info1 info2 duration } {
	set cm [$self get_local_option controlmenu]
	if { $cm!={} } {
		$cm update_session_info mars "Title: $info1\
				\nInformation: $info2\nDuration: $duration\n"
	}
}


CollaboratorUI public play_update { state } {
	$self instvar rover_panel_path_
	$rover_panel_path_ play_update $state
}


CollaboratorUI private create_minimize { tip frame minimize_frame \
		{minimize_cmd {}} {restore_cmd {}} } {
	frame ${frame}_encloser
	raise $frame ${frame}_encloser
	button ${frame}_minimize -bd 1 -highlightthickness 0 \
			-image CollaboratorIcons(close) -command \
			[list $self minimize $frame $minimize_frame \
			$minimize_cmd $restore_cmd] -bg \#c0c0c0 \
			-activebackground \#c0c0c0
	TipManager tip ${frame}_minimize -tip $tip
	# 9898f8

	pack ${frame}_minimize -side top -in ${frame}_encloser -anchor w
	pack $frame -side bottom -in ${frame}_encloser -fill both -expand 1
	return ${frame}_encloser
}


CollaboratorUI private minimize { frame minimize_frame minimize_cmd \
		restore_cmd } {
	pack forget $frame
	${frame}_minimize configure -image CollaboratorIcons(open) -command \
			[list $self restore $frame $minimize_frame \
			$minimize_cmd $restore_cmd]
	pack ${frame}_minimize -side bottom -in ${frame}_encloser -anchor s
	${frame}_encloser configure -width 0 -height 0
	if { $minimize_cmd != {} } { eval $minimize_cmd }
}


CollaboratorUI private restore { frame minimize_frame minimize_cmd \
		restore_cmd } {
	${frame}_minimize configure -image CollaboratorIcons(close) -command \
			[list $self minimize $frame $minimize_frame \
			$minimize_cmd $restore_cmd]
	pack ${frame}_minimize -side top -in ${frame}_encloser -anchor w
	pack $frame -side bottom -in ${frame}_encloser -fill both -expand 1
	if { $restore_cmd != {} } { eval $restore_cmd }
}


CollaboratorUI public reset media {
	if [catch {$self reset_ $media} m] {
		global errorInfo
		puts "$m: $errorInfo"
	}
}


CollaboratorUI public reset_ media {
	$self instvar useMega_ audioRecvOnly_

	if { $media == "audio" } {
		if { [$self get_option isAudioAgentReset]=={} } {
			$self add_option isAudioAgentReset 1
			set audioPanel [$self get_local_option audioPanel]
			if [info exists audioRecvOnly_] {
				$self set_recv_only $audioRecvOnly_
			}
		}
	}

	if { $media == "mbv2" } {
		$self instvar path_
		[$self get_local_option mbv2UI] enable_menu $path_.menu
	}

	set cm [$self get_local_option controlmenu,$media]
	if { $cm != {} } { $cm new_hostspec }

	if $useMega_ { $self heard_from $media }
}


CollaboratorUI public heard_from media {
	$self instvar as_ path_ useMega_
	set as_($media) 1

	set target [$self get_local_option have_rover]
	if $useMega_ {
		set target [expr $target + \
				[$self get_local_option have_video] + \
				[$self get_local_option have_audio] + \
				[$self get_local_option have_mb]]
	}
	if { [expr $as_(video) + $as_(audio) + $as_(mb) + $as_(mars)] >= \
			$target } {
		# we've got everything!
		global mash
		$path_.label configure -text "Collaborator v$mash(version)" \
				-anchor c
		return
	}

	set text "Contacting service... Heard from: "
	foreach media [array names as_] {
		if $as_($media) { append text "$media " }
	}
	$path_.label configure -text $text
}


#
# If <i>v</i> is true, mute user's input and undo the AudioPanel's
# 3rd-mouse-button binding for speaking.
#
CollaboratorUI public set_recv_only v {
	$self instvar audioRecvOnly_
	if { [$self get_option isAudioAgentReset]=={} } {
		set audioRecvOnly_ $v
		set v 1
	}

	set audioPanel [$self get_local_option audioPanel]
	$audioPanel set_recv_only $v
	if !$v {
		bind all <ButtonPress-3> \
				"if { !\[string match *mbpanel* %W \] && \
				!\[string match *mbv2panel* %W \] } \
				\{ $audioPanel ptt-press \}"
		bind all <ButtonRelease-3> \
				"if { !\[string match *mbpanel* %W \] && \
				!\[string match *mbv2panel* %W \] } \
				\{ $audioPanel ptt-release \}"
	} else {
		bind all <ButtonPress-3> ""
		bind all <ButtonRelease-3> ""
	}
}


CollaboratorUI private enable_mb_hack { } {
	$self instvar sm_
	$self tkvar mb_hack_
	$sm_ enable_mb_cname_hack $mb_hack_
}


CollaboratorUI public about { } {
	global mash
	if [info exists mash(version)] {
		set v $mash(version)
	} else {
		set v ?
	}
	set text "The Mash Collaborator\
			\nMash Version $v\
			\nOpen Mash Consortium\
			\n\n<http://www.openmash.org/>"
	set cnt 0
	while [winfo exists .about$cnt] { incr cnt }
	set about .about$cnt

	option add *${about}*background #d9d9d9
	MessageBox $about -image MashLogoIcon -text $text \
			-options { {text.wraplength 0 } } \
			-title "About Collaborator..."
	pack configure [$about subwidget image] -padx 10 -pady 10
	pack configure [$about subwidget text ] -padx 10 -pady 10
	pack configure [$about subwidget ok   ] -pady 10
	$about invoke
	destroy $about
}

