/*
 * session-scuba.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_session_scuba_h
#define mash_session_scuba_h

#include "net.h"
#include "timer.h"

class ScubaSessionManager;

class ScubaHandler : public DataHandler, public Timer {
    public:
	ScubaHandler();
	virtual void dispatch(int mask);
	virtual void net(Network* net);
	virtual void timeout();
	void adapt(int size);
	void sample_size(int cc);
	inline double rint() const { return (rint_); }
	inline void bandwidth(double bw) { bw_ = bw; ctrl_inv_bw_ = 1. / bw; }
	inline double bandwidth() { return (bw_); }
	inline void manager(ScubaSessionManager* m) { manager_ = m; }
	void startctrl();
 protected:
	void schedule_timer();
	double bw_;
	double ctrl_inv_bw_;
	double ctrl_avg_size_;	/* (estimated) average size of ctrl packets */
	double rint_;		/* current session report rate (in ms) */

	ScubaSessionManager* manager_;
};

class ScubaSessionManager {
public:
	virtual void recv(ScubaHandler*) = 0;
	virtual void announce(ScubaHandler*) = 0;
};

/*
 * Parameters controlling the SCUBA report rate timer.
 */
#define SCUBA_SESSION_BW_FRACTION (0.05)
#define SCUBA_MIN_RPT_TIME (1.)
#define SCUBA_SENDER_BW_FRACTION (0.25)
#define SCUBA_RECEIVER_BW_FRACTION (1. - SCUBA_SENDER_BW_FRACTION)
#define SCUBA_SIZE_GAIN (1./8.)

#endif

