/*
 * renderer.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/render/renderer.cc,v 1.20 2002/02/03 04:15:15 lim Exp $";
#ifdef LOG_DOEVENT
#include <sys/time.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include "renderer.h"
#include "renderer-window.h"
#include "vw.h"
#include "rv.h"

#include "color.h"
#include "tclcl.h"

#include "postdct.h"

Renderer::Renderer() :
	next_(0),
	now_(0),
	update_interval_(0),
	need_update_(1),
	heuristics_(1),
	last_update_(0)
{
}

int Renderer::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "update-interval") == 0) {
			setinterval(atoi(argv[2]));
			return (TCL_OK);
		}
		if (strcmp(argv[1], "color") == 0) {
			setcolor(atoi(argv[2]));
			return (TCL_OK);
		}
		if (strcmp(argv[1], "heuristics") == 0) {
		        setheuristics(atoi(argv[2]));
			return (TCL_OK);
		}
	}
	return (Module::command(argc, argv));
}

void Renderer::setinterval(u_int v)
{
	if (update_interval_ != v) {
		update_interval_ = v;
		if (update_interval_) {
			msched(v);
			need_update_ = 0;
		} else {
			cancel();
			need_update_ = 1;
		}
	}
}

void Renderer::setheuristics(u_int v) {
        heuristics_ = v;
}

void Renderer::timeout()
{
	need_update_ = 1;
	msched(update_interval_);
}

int BlockRenderer::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "irthresh") == 0) {
			irthresh_ = atoi(argv[2]);
			return (TCL_OK);
		}
	}
	return (Renderer::command(argc, argv));
}

void BlockRenderer::recv(Buffer* bp)
{
	recv(bp, CODEC_ANY, 0);
}

void BlockRenderer::recv(Buffer* bp, int codec, int quality)
{
	u_int age;

	const VideoFrame* vf = (VideoFrame*)bp;
	if (!samesize(vf))
		resize(vf->width_, vf->height_);
	YuvFrame* p = (YuvFrame*)vf;

	if (update_interval_) {
		if (!need_update_) return;
		need_update_ = 0;
		/*
		 * Render blocks that have arrived during update_interval_
		 * (last_update_ < ts[x] <= now).
		 */
		age = RV_AGE(p->ts_, last_update_) - 1;
	} else {
		/* Only render blocks that have just arrived (ts[x] == now). */
		age = 0;
	}

	// get the new "timestamp" from the decoder
	now_ = p->ts_;
	u_int now = now_;

	/* Remember last time we rendered a frame (now). */
	last_update_ = now;

	// count the number of blocks we need to update
	const u_int8_t* ts = p->crvec_;
	u_int bcnt = 0;
	int w = width_ >> 3;
	int y;
	for (y = height_ >> 3; --y >= 0; ) {
		for (int x = 0; x < w; ++x) {
			if (RV_AGE(now, ts[x]) <= age) {
				++bcnt;
			}
		}
		ts += w;
	}

	// if the number of blocks we have to update is smaller than a threshold 
	//	(default 150 blocks, which FYI is 9.5% of 1584, the total number of 
	//	blocks per frame in CIF - 38% in QCIF), we render only the blocks 
	//	that have changed, and in a separate way. Otherwise do full-frame 
	//	rendering (a single push call).
	int immed = bcnt < irthresh_;
#if defined(WIN32)
	// multiple pushing kills Microsoft Windows performance
	immed = 0;
#endif

	if (!immed) {
	        if (heuristics_) {
	  	        double t = get_threshold(codec, quality);
			deblock(p->bp_, 2*t, 2*t, 0.0, p->width_, p->height_);
		}
	  	render(p->bp_, 0, 0, p->width_, p->height_);
		push(p->bp_, 0, p->height_, 0, p->width_);
		sync();
	} else {


	int ymin = height_;
	int ymax = 0;
	ts = p->crvec_;
	for (y = 0; y < height_; y += 8) {
		for (int x = 0; x < width_; ) {

			// scan the conditional replenishment vector in zigzag looking for
			//	blocks which need be updated
			if (RV_AGE(now, ts[x>>3]) > age) {
				x += 8;
				continue;
			}
			int sx = x;

			// get the widest strip of blocks that need be updated
			// FIXME: currently the render optimization consists only of strips. 
			//	We could try to optimize more general subframes (i.e., clustering 
			//	blocks to render them together not only in the X axis but also 
			//	in the Y axis
			do {
				x += 8;
			} while ((x < width_) && RV_AGE(now, ts[x>>3]) <= age);

			// At this point:
			//
			// sx = how far into the image's row we have
			// to go before a block needs to be rendered.
			//
			// x = how far into the image's row we have to
			// render. e.g. we render between indices sx
			// and x.

			// render the strip
			int off = y * width_ + sx;
			if (heuristics_) {
			        double t = get_threshold(codec, quality);
			        deblock(p->bp_, 2*t, 2*t, 0.0, p->width_, 8, off, x - sx);
			}
			render(p->bp_, off, sx, x - sx, 8);

			// push the strip
			if (immed) {
				push(p->bp_, y, y + 8, sx, x);
			}

			// get the minimum and maximum y coordinate we've render'ed already
			if (y < ymin)
				ymin = y;
			if (y > ymax)
				ymax = y;
		}
		ts += width_ >> 3;
	}

	// if there was any block rendered...
	if (ymin <= ymax) {

		// and we were waiting for a full-frame push...
		if (!immed) {
			// push the full frame
			push(p->bp_, ymin, ymax + 8, 0, 0);
		}
		sync();
	}
	}
    /*
     * I added this to make sure that Tcl does not starve UI events.
     * It speeds up UI responses when decoding multiple streams.
     * I timed this on a PIII600MHz machine and each call takes < 50us.
     * So it should not affect the rendering performance too much.
     */
    Tcl_DoOneEvent(TCL_WINDOW_EVENTS | TCL_DONT_WAIT);
}
