/*
 * mb-pkt.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-pkt.h,v 1.9 2002/02/03 03:16:30 lim Exp $
 */

#ifndef mb_packet_H
#define mb_packet_H

#define MB_PKT_VER 1		/* current protocol version */

#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( disable : 4200 )
#endif

/* Packet types */
/* not being used currently, it will mostly end up being a subset of these,
   since some of these types are being superceded by SRM pkt types */
typedef enum {
    PT_Cmd=0,                   /* 0 drawing operation */
    PT_ID,                      /* 1 announcement packet */
    PT_REQUEST,                 /* 2 repair request */
    PT_REPLY,                   /* 3 repair reply */
    PT_KILL,                    /* 4 terminate participation */
    PT_PREQ,                    /* 5 page vector request */
    PT_PREP,                    /* 6 page vector reply */
} PacketType;

/* flags */
/* currently these are not being used */
typedef enum {
    PF_USER= 0x01,              /* hint that packet has interactive data */
    PF_VIS = 0x02,              /* only want visible draw ops */
    PF_PAD = 0x04               /* encryption added padding */
} Flags;

/*
 * A repair request.
 */
struct Pkt_request {
    SrcId  pr_sid;              /* source id of drawops to be repaired */
    PageId pr_page;		/* page of drawops */
    u_int32_t pr_sseq;		/* start seqno */
    u_int32_t pr_eseq;		/* end seqno*/
};

/*
 * A repair reply.
 */
struct Pkt_reply {
    SrcId pr_sid;        /* original site id of commands  */
    /* followed by a Pkt_PageHdr */
};

struct Pkt_PgStatus {
    PageId pageid;
    u_int32_t maxSn;
};

/*
 * An announcement packet.
 * It contains the site name and a vector of states of pages annotated by the
 * site.
 *
 */

struct Pkt_SA {
    SrcId srcid;                /* origin of data */
    u_int32_t numPgs;
    Pkt_PgStatus aPgStatus[0];  /* numPgs entries */
};

/* this packet follows Pkt_SA */
struct Pkt_RcvrInfo {
	PageId currPageId;          /* the page that a receiver is
				     * viewing */
};


/*
 * Format of the MediaBoard data packet header.
 */
struct Pkt_DataHdr {
    u_short ph_version;	/* mediaboard version number */
    u_char  ph_type;	/* packet type */
    u_char  ph_flags;	/* packet flags */
};

/*
 * Multiple commands can be sent in one packet.  Each one starts on a
 * an even multiple of CMD_ALIGN bytes, which must be a power of two.
 *
 * Order in Packet:
 *      Pkt_PageHdr
 *
 *      Pkt_CmdHdr      (Pkt_CmdGroupHdr->sseq)
 *      Pkt_Cmd??
 *      Pkt_CmdHdr      (Pkt_CmdGroupHdr->sseq+1)
 *      Pkt_Cmd??
 *      ...
 *      Pkt_CmdHdr      (Pkt_CmdGroupHdr->eseq)
 *      Pkt_Cmd??
 */

//#define PKT_NEXT(d) /* \ */
//((struct Pkt_CmdHdr*) /* \ */
// ((u_char *)(d) + CMD_ROUNDUP(ntohs((d)->dh_len) + sizeof(*(d)))))

#define PKT_ALIGN 4
/* ALIGN must be multiple of 4 */
#define ROUNDUP(x,ALIGN) ((((int)(x)) + (ALIGN - 1)) & ~(ALIGN - 1))
#define PKT_ROUNDUP(x)	ROUNDUP(x,PKT_ALIGN)

/* header that starts off a page */
struct Pkt_PageHdr {
    PageId	pd_page;	/* page that operations apply to */
    u_int32_t	pd_sseq;	/* start sequence number */
    u_int32_t	pd_eseq;	/* end sequence number */
    /* command packets follow */
};

struct Pkt_CmdHdr {
    u_int32_t dh_ts;		/* sender's timestamp */
    u_int16_t dh_len;		/* body length */
    u_char	dh_flags;       /* flags */
    u_char	dh_type;        /* body type */
    /* Pkt_Cmd* follows */
};

/*
 * Structure of a create message.
 */
struct Pkt_CmdCreate {
    u_int32_t itemType;                 /* pageitem type */
    /* followed by a coord packet */
    /* followed by a page Item packet */
};

struct Pkt_Point {
    float x;
    float y;
};

struct Pkt_Coord {
    u_int32_t nPoints;
    Pkt_Point aPoints[0];            // nPoints number of Point
};

struct MBColor {
    u_int16_t r;                /* red */
    u_int16_t g;                /* green */
    u_int16_t b;                /* blue */
    u_int16_t a;                /* transparency = 1 => transparent, 0 otherwise*/
};

struct Pkt_LineItem {
    u_int16_t   width_;
    u_int16_t   arrow_;
    MBColor fg_;
};

struct Pkt_PolyItem {
    u_int16_t   width_;
    u_int16_t   pad;
    MBColor fill_;
    MBColor outline_;
};

struct Pkt_TextItem {
    MBColor fillC_;
    u_int16_t lenFont;
    u_int16_t lenText;          /* total to lenFont & lenText is */
                                /* aligned at 4 bytes */
    // a variable sized text string containing the 2 text
    char achFontNText[0];
    /* followed by padding so that packet is aligned at 4 bytes */
};

/*
 * Structure of a multi-line message.
 */
struct Pkt_CmdGroup {
    u_int16_t groupType;        /* pageitem type */
    u_int16_t pad;              /* so that snStart is 4-byte aligned */
    u_int32_t snStart, snEnd;
    /* depends on groupType, possibly followed by a Pkt_Coord and maybe a Pkt_*Item */
};

struct Pkt_CmdPgName {
    u_int16_t nameLen;            // len of name
    char achName[0];              // nameLen characters of name
    /* followed by padding so that struct is aligned at 4 bytes */
};

#ifdef OLD
struct Pkt_CmdCoord {
    u_long targetId;
    int x1, y1, x2, y2;
};
#endif

struct Pkt_CmdDel {
    u_int32_t itemId;
};

struct Pkt_CmdDup {
    u_int32_t targetId;
};

struct Pkt_CmdMove {
    u_int32_t targetId;
    float dx, dy;
};

struct Pkt_CmdChar {
    u_int32_t targetItem;
    u_int16_t index;
    char chr;
    u_int8_t pad;
};

/* contains a fragment */
struct Pkt_CmdFrag {
    u_int16_t len;              // guaranteed to be a multiple of 4
    u_int16_t pad;              // align at 4 bytes
    Byte pData[0];
};

#ifdef _MSC_VER
#pragma warning( default : 4200 )
#endif

#endif // #ifndef mb_packet_H
