/*
 * mb-basecanv.cc --
 *
 *      MediaBoard Canvas
 *      This is now a wrapper around tkCanvas, ultimately, we want to implement
 *      our own canvas.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-basecanv.cc,v 1.4 2002/02/03 03:16:30 lim Exp $
 */

#ifndef MB_CANV_CC
#define MB_CANV_CC

#include "mb-canv.h"
#include "mb-string.h"
#include "mb-page.h"
#include "mb-cmd.h"
#include <tclcl.h>


MBBaseCanvas::MBBaseCanvas()
{
	assert(sizeof(MBCmd*) == sizeof(char*));
	Tcl_InitHashTable(&htCmds_, TCL_ONE_WORD_KEYS);
}

MBBaseCanvas::~MBBaseCanvas()
{
	/* no need to delete any since we did not allocate any entries */
	Tcl_DeleteHashTable(&htCmds_);
}


MBCanvItem::MBCanvItem(const char* szType, Point* arCoords, int count)
	: arCoords_(arCoords), count_(count), szType_(NULL), szProp_(NULL)
{
	if (szType) ::AllocNCopy(&szType_, szType);
}


MBCanvItem::~MBCanvItem() {
	delete[] szType_;
	delete[] arCoords_;
	delete[] szProp_;
}

// converts to a page item
PageItem* MBCanvItem::toPageItem()
{
	PageItem* pItem = PageItem::createItem(
		PageItem::strName2Type(getType()));
	if (!pItem) {
		SignalError(("Out of memory!"));
		return NULL;
	}
	Point* arPoints = new Point[count_];
	memcpy(arPoints, arCoords_, sizeof(Point)*count_);
	pItem->setPoints(arPoints, count_);
	int argc;
	char** argv;
	Tcl_SplitList(MB_Interp, getProp(), &argc, &argv);
	pItem->configure(argc, argv);
	Tcl_Free((char*)argv);
	return pItem;
}

/* returns 1 if new hash entry is created */
int MBBaseCanvas::assocItem(CanvItemId cid, MBCmd* pCmd)
{
	int created;
	Tcl_HashEntry* pEntry =
		Tcl_CreateHashEntry(&htCmds_, (char*)cid, &created);
	assert(pEntry || !"cannot create entry! out of memory?");
	Tcl_SetHashValue(pEntry, (ClientData)pCmd);
	return created;
}

/* returns FALSE if cannot find entry */
int MBBaseCanvas::forgetItem(CanvItemId cid)
{
	Tcl_HashEntry* pEntry =
		Tcl_FindHashEntry(&htCmds_, (char*)cid);
	if (!pEntry) {
		disperr("forgetItem called with unkown cid: %d\n",
			cid);
		assert(FALSE && "forgetItem called with unkown cid");
		return FALSE;
	}
	Tcl_DeleteHashEntry(pEntry);
	return TRUE;
}

/* return NULL if not found */
MBCmd* MBBaseCanvas::canvId2cmd(CanvItemId cid)
{
	Tcl_HashEntry* pEntry =
		Tcl_FindHashEntry(&htCmds_, (char*)cid);
	if (!pEntry) {
		MTrace(trcMB|trcVerbose,
		       ("canvId2Cmd called with unknown id: %d\n", cid));
		return (MBCmd*)NULL;
	}
	return (MBCmd*)Tcl_GetHashValue(pEntry);

}

ulong MBBaseCanvas::canvId2itemId(CanvItemId cid)
{
	MBCmd* pCmd = canvId2cmd(cid);
	if (pCmd)
		return pCmd->getSeqno();
	else
		return 0;
}

#endif /* #ifdef MB-CANV_CC */
