/*
 * fca-rreq.cc --
 *
 *      repair request and reply classes
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * fca_rreq.cc -- Helen J. Wang
 */

#include "fca-rreq.h"

static class FCARepairRequestClass : public TclClass {
public:
  FCARepairRequestClass() : TclClass ("FCARepairRequest") {
    Debug (dbgFCA, ("created FCARepairRequest class: %s \n", classname_));
  }
  TclObject* create (int /*argc*/, const char*const* /*argv*/) {
    return (new FCARepairRequest);
  }
} fcaRequest;


// cancel after asking for 10 times
// static const cNumMaxRreq = 20;
int FCARepairRequest::fill_ADU(u_char* pb, int len)
{
  if (this->Packetize(pb, len)==FALSE) {
    Debug (dbgFCA, ("unable to packetize repair request"));
    return 0;
  }
  static char buffer[10000];
  *buffer = '\0';
  for (int i=0; i<len; i++) {
    sprintf (buffer, "%s%02x ", buffer, pb[i]);
  }
//  Debug (dbgFCA, ("%s", buffer));
  return len;
}


int FCARepairRequest::command(int /*argc*/, const char*const* argv) {
  if (!strcmp(argv[1], "cancel")) {
    this->cancel();
    Tcl::instance().resultf("");
  }

  if (!strcmp(argv[1], "backoff")) {
    this->Backoff();
    Tcl::instance().resultf("");
  }
  return TCL_OK;
}



/***************************************************************/


static class FCARepairReplyClass : public TclClass {
public:
  FCARepairReplyClass () : TclClass ("FCARepairReply") {
    Debug (dbgFCA, ("created FCARepairReply class: %s \n", classname_));
  }
  TclObject* create (int /*argc*/, const char*const* /*argv*/) {
    return (new FCARepairReply);
  }
} fcaReply;


int FCARepairReply::fill_ADU(Byte* pb, int len)
{
  if (this->Packetize(pb, len)==FALSE) {
    Debug (dbgFCA, ("unable to packetize repair reply"));
    return 0;
  }
  Debug(dbgFCA, ("FCARepairReply::fill_ADU contains %d bytes:", len));
  static char buffer[10000];
  *buffer = '\0';
  for (int i=0; i<len; i++) {
    sprintf (buffer, "%s%02x ", buffer, pb[i]);
  }
//  Debug (dbgFCA, ("%s", buffer));
  return len;
}


int FCARepairReply::command(int /*argc*/, const char*const* argv) {
  if (!strcmp(argv[1], "cancel")) {
    this->cancel();
    Tcl::instance().resultf("");
  }

  if (!strcmp(argv[1], "backoff")) {
    this->Backoff();
    Tcl::instance().resultf("");
  }
  return TCL_OK;
}

