/*
 * mash-console.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/compat/mash-console.cc,v 1.7 2002/02/03 03:14:22 lim Exp $";
#endif

#include <windows.h>
#include "tclcl.h"
#include "console.h"
#include "misc/all-types.h"

#define IDM_SHOWHIDECONSOLE 9999


class OTclMashConsole : public TclObject {
public:
	OTclMashConsole() : TclObject() { };
	~OTclMashConsole();

	int show(int argc, const char *const *argv);
	int hide(int argc, const char *const *argv);
	int toggle(int argc, const char *const *argv);
	int set_title(int argc, const char *const *argv);
	int is_visible(int argc, const char *const *argv);
	int set_buffer_size(int argc, const char *const *argv);

	int alloc(int argc, const char *const *argv);
	int free(int argc, const char *const *argv);

	int destroy(int argc, const char *const *argv);

	int init(int argc, const char * const *argv) {
		if (instance_) {
			Tcl::instance().result("there is already one instance"
					       " of this class; multiple "
					       "instances are forbidden");
			return TCL_ERROR;
		}
		instance_ = this;
		return TCL_OK;
	}

	int create_sysmenu(int argc, const char *const *argv);
	static MashConsole mainConsole_;
private:
	static LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg,
					   WPARAM wParam, LPARAM lParam);

	HMENU sysMenu_;
	HWND attachedHwnd_;

	static WNDPROC origWindowProc_;
	static OTclMashConsole *instance_;
};


WNDPROC OTclMashConsole::origWindowProc_=NULL;
OTclMashConsole *OTclMashConsole::instance_=NULL;
MashConsole OTclMashConsole::mainConsole_;


DEFINE_OTCL_CLASS(OTclMashConsole, "MashConsole")
{
	INSTPROC_PUBLIC(show);
	INSTPROC_PUBLIC(hide);
	INSTPROC_PUBLIC(toggle);
	INSTPROC_PUBLIC(set_title);
	INSTPROC_PUBLIC(set_buffer_size);
	INSTPROC_PUBLIC(alloc);
	INSTPROC_PUBLIC(free);

	INSTPROC_PRIVATE(create_sysmenu);
	INSTPROC_PRIVATE(destroy);
}


OTclMashConsole::~OTclMashConsole()
{
	if (sysMenu_) {
		if (IsWindow(attachedHwnd_)) {
			SetWindowLong(attachedHwnd_, GWL_WNDPROC,
			      (LONG)origWindowProc_);
		}
		sysMenu_ = NULL;
		attachedHwnd_ = NULL;
		origWindowProc_ = NULL;
	}

	if (instance_==this) instance_=NULL;
}


int
OTclMashConsole::show(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	mainConsole_.Show(TRUE);
	return TCL_OK;
}


int
OTclMashConsole::hide(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	mainConsole_.Show(FALSE);
	return TCL_OK;
}


int
OTclMashConsole::toggle(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	Tcl::instance().resultf("%d", mainConsole_.Toggle());
	return TCL_OK;
}


int
OTclMashConsole::set_title(int argc, const char *const *argv)
{
	const char *title;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(title);
	END_PARSE_ARGS;
	mainConsole_.SetTitle(title);
	return TCL_OK;
}


int
OTclMashConsole::is_visible(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	Tcl::instance().resultf("%d", mainConsole_.IsVisible());
	return TCL_OK;
}


int
OTclMashConsole::set_buffer_size(int argc, const char *const *argv)
{
	u_int32_t size;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(size);
	END_PARSE_ARGS;
	int retval = mainConsole_.SetBufferSize(size);
	Tcl::instance().resultf("%d", retval);
	return TCL_OK;
}


int
OTclMashConsole::alloc(int argc, const char *const *argv)
{
	u_int32_t x, y, width, height;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG_DEFAULT(x, CW_USEDEFAULT);
	ARG_DEFAULT(y, CW_USEDEFAULT);
	ARG_DEFAULT(width,  CW_USEDEFAULT);
	ARG_DEFAULT(height, CW_USEDEFAULT);
	END_PARSE_ARGS;
	mainConsole_.Create(x, y, width, height);
	return TCL_OK;
}


int
OTclMashConsole::free(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	mainConsole_.Destroy();
	return TCL_OK;
}


int
OTclMashConsole::create_sysmenu(int argc, const char *const *argv)
{
	u_int32_t hwndId;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(hwndId);
	END_PARSE_ARGS;
	BOOL success = FALSE;

	attachedHwnd_ = (HWND) hwndId;
	if (attachedHwnd_) {
		HMENU sysMenu = GetSystemMenu(attachedHwnd_, FALSE);
		while (!sysMenu && attachedHwnd_) {
			attachedHwnd_ = GetParent(attachedHwnd_);
			if (attachedHwnd_ && (HINSTANCE)
			    GetWindowLong(attachedHwnd_, GWL_HINSTANCE)==
			    mainConsole_.hInstance_)
				sysMenu = GetSystemMenu(attachedHwnd_, FALSE);
		}

		if (sysMenu) {
			AppendMenu(sysMenu, MF_SEPARATOR, 0, NULL);
			AppendMenu(sysMenu, MF_STRING, IDM_SHOWHIDECONSOLE,
				   "Show Mash Co&nsole");

			sysMenu_ = sysMenu;
			origWindowProc_ = (WNDPROC)
				SetWindowLong(attachedHwnd_, GWL_WNDPROC,
					      (LONG)WindowProc);
			success = TRUE;
		}
	}

	Tcl::instance().resultf("%d", success);
	return TCL_OK;
}


int
OTclMashConsole::destroy(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	Tcl::instance().result("destroying the MashConsole object is not "
			       "permitted");
	return TCL_ERROR;
}


LRESULT CALLBACK OTclMashConsole::WindowProc(HWND hWnd, UINT msg,
					     WPARAM wParam, LPARAM lParam)
{
	BOOL isSysMenu;
	HMENU hmenu;
	MENUITEMINFO info;

	switch (msg) {
	case WM_INITMENUPOPUP:
		isSysMenu = (BOOL) HIWORD(lParam); // window menu flag
		hmenu = (HMENU) wParam;         // handle of submenu

		if (isSysMenu && instance_ && hmenu==instance_->sysMenu_) {
			info.cbSize        = sizeof(info);
			info.fMask         = MIIM_TYPE | MIIM_STATE;
			info.fType         = MFT_STRING;
			info.fState        = (mainConsole_.Exists() ?
					      MFS_ENABLED : MFS_GRAYED);
			info.wID           = IDM_SHOWHIDECONSOLE;
			info.hSubMenu      = NULL;
			info.hbmpChecked   = NULL;
			info.hbmpUnchecked = NULL;
			info.dwItemData    = NULL;

			if (mainConsole_.IsVisible()) {
				info.dwTypeData = "Hide Mash Co&nsole";
			} else {
				info.dwTypeData = "Show Mash Co&nsole";
			}
			info.cch = strlen(info.dwTypeData);

			SetMenuItemInfo(instance_->sysMenu_,
					IDM_SHOWHIDECONSOLE,
					FALSE, &info);
		}

		// always fall through to the orig proc
		break;

	case WM_SYSCOMMAND:
		switch (LOWORD(wParam)) {
		case IDM_SHOWHIDECONSOLE:
			mainConsole_.Toggle();
			return 0;
		}
		break;
	}

	if (origWindowProc_)
		return origWindowProc_(hWnd, msg, wParam, lParam);
	return 0;
}





extern "C"
void MashConsoleInit(HINSTANCE hInstance)
{
	OTclMashConsole::mainConsole_.Init(hInstance);
	OTclMashConsole::mainConsole_.Create();
}


extern "C"
void MashConsoleShow(BOOL show)
{
	OTclMashConsole::mainConsole_.Show(show);
}

extern "C"
void MashConsoleDoModal()
{
	OTclMashConsole::mainConsole_.DoModal();
}

extern "C"
BOOL MashConsoleAttach()
{
	OTclMashConsole *console =
		(OTclMashConsole*)TclObject::New("MashConsole");

	if (!console) return FALSE;
	Tcl_SetVar2(Tcl::instance().interp(), "mash", "console",
		    (char*) console->name(), TCL_GLOBAL_ONLY);
	return TRUE;
}
