/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.sun.tools.doclets.formats.html.markup;

/**
 * Enum representing HTML styles. The name map to values in the CSS file.
 *
 * @author Bhavesh Patel
 */
public enum HtmlStyle {
    aboutLanguage,
    altColor,
    bar,
    block,
    blockList,
    blockListLast,
    bottomNav,
    classUseContainer,
    colFirst,
    colLast,
    colOne,
    constantValuesContainer,
    contentContainer,
    description,
    details,
    header,
    horizontal,
    footer,
    indexContainer,
    indexHeader,
    inheritance,
    legalCopy,
    nameValue,
    navBarCell1Rev,
    navList,
    overviewSummary,
    packageSummary,
    rowColor,
    serializedFormContainer,
    sourceContainer,
    sourceLineNo,
    strong,
    subNav,
    subNavList,
    subTitle,
    summary,
    tabEnd,
    title,
    topNav;
}
