<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/SitePlugin.class.inc");

function parse_music_tracks($pageBuffer, $title, $disc_no)
{
	$tracks = NULL;

	//<b class="h1">Listen to Samples</b><br />
	if(preg_match("!<b class=\"h1\">".preg_quote($title, "!")."</b>(.*)<hr noshade size=1>!Usi", $pageBuffer, $regs))
	{
		// Only parse for the disc number if disc_no specified
		if(!is_numeric($disc_no) || preg_match("!<b>Disc: $disc_no</b>(.*)</table>!Usi", $regs[1], $regs2))
		{
			if(preg_match_all("!<span class=tiny>[\s]*[0-9]+\.[\s]+(.*)</span>!Usi", is_numeric($disc_no)?$regs2[1]:$regs[1], $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					if(preg_match("!<a href=[^>]*>([^<]*)<img!i", $matches[1][$i], $regs3))
						$track = $regs3[1];
					else
						$track = $matches[1][$i];

					if(strlen($track)>0)
					{
						$track = convert_html_numeric_codes(strip_tags($track));
						$track = trim(strtr($track, array_flip(get_html_translation_table(HTML_ENTITIES, ENT_QUOTES))));

						$tracks[] = $track;
					}
				}
			}
		}
	}
	return $tracks;
}//function parse_music_tracks($pageBuffer, $title, $disc_no)

class amazon extends SitePlugin
{
	function amazon($site_type)
	{
		parent::SitePlugin($site_type);
	}

	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazonasin'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('amazonasin'=>$search_vars_r['amazonasin']));
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));

			if($index_type == 'videogames') // not sure whether this will always work, but it does return data similiar to that for the other types, including most popular and the rest.
				$queryUrl = "http://www.amazon.com/exec/obidos/search-handle-url/field-keywords=".rawurlencode($search_vars_r['title'])."&index=videogames&search-type=ss&sz=$items_per_page&pg=$page_no/ref=sr_1_4_etk-vg_all";
			else
				$queryUrl = "http://www.amazon.com/exec/obidos/external-search?index=".$index_type."&keyword=".rawurlencode($search_vars_r['title'])."&sz=$items_per_page&pg=$page_no";

			$pageBuffer = $this->fetchURI($queryUrl);
		}

		if(strlen($pageBuffer)>0)
		{
			$amazonasin = FALSE;

			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $pageBuffer, $regs))
				{
					$amazonasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($pageBuffer), $regs))
				{
					$amazonasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazonasin = trim ($regs[1]);
				}
			}

			// exact match
			if($amazonasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazonasin'=>$amazonasin));

				return TRUE;
			}
			else
			{
				if(preg_match("/All[\s]*([0-9]+)[\s]*results for/i", $pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);

					$start_of_block = strpos($pageBuffer, "results for", $start_of_block);
					if($start_of_block!==FALSE)
					{
						// Video game format does have to be different!
						if($index_type == 'videogames')
						{
							$title_regs_pattern = ":<b><a href=/exec/obidos/tg/detail/-/([^/]*)/[^>]*>([^<]*)</a></b>:U";
						}
						else
						{
							$title_regs_pattern = ":<b><a href=/exec/obidos/tg/detail/-/([^/]*)/[^>]*>([^<]*)</a></b>:U";
						}

						$parseblock = substr($pageBuffer, $start_of_block);
						if(preg_match_all($title_regs_pattern, $parseblock, $matches))
						{
							for ($i = 0; $i < count($matches[1]); $i++)
							{
								$thumbimg = NULL;

								if(preg_match("!<img src=\"(http://.*".$matches[1][$i].".*jpg\")[^<]*>!U", $parseblock, $regs))
									$thumbimg = $regs[1];

								$this->addListingRow($matches[2][$i].' '.trim($matches[3][$i]), $thumbimg, NULL, array('amazonasin'=>$matches[1][$i]));
							}

							return TRUE;
						}
					}
				}
			}

			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	/**
	*
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		// assumes we have an exact match here
		$pageBuffer = $this->fetchURI("http://www.amazon.com/gp/product/".$search_attributes_r['amazonasin']);
			
		// no sense going any further here.
		if(strlen($pageBuffer)==0)
			return FALSE;

		// The location of the title is the same for all formats.
		//<title>Amazon.com: Big Fish: DVD</title>
		if(preg_match("/<title>.*Amazon\.com: ([^:]*):(.*)<\/title>/s", $pageBuffer, $regs))
		{
		    $title = trim($regs[1]);

			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\([0-9]+\)$/", $title, $regs2))
				$title = $regs2[1];

			$this->addItemAttribute('title', convert_html_numeric_codes(strip_tags(trim(str_replace("\"", "", $title)))));
		}

		$imageBuffer = $this->fetchURI("http://www.amazon.com/gp/product/images/".$search_attributes_r['amazonasin']."/");
		if($imageBuffer!==FALSE)
	    {
	        //<img src="http://ec1.images-amazon.com/images/P/B0001KU8ZG.01._SCLZZZZZZZ_.jpg" width="279" height="500" border="0" />
	        if(preg_match("!<img src=\"([^\"]+)\"!", $imageBuffer, $regs))
	        {
	        	$this->addItemAttribute('imageurl', $regs[1]);
	        }
	    }

		// Image src extraction block
		// <a href="http://images.amazon.com/images/P/B0000640S2.01.LZZZZZZZ.jpg">
		if (preg_match_all("!\"(http://images.amazon.com/[^\"]+".$search_attributes_r['amazonasin']."[^\"]+)\"!", $pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;

			// try for a big image first, otherwise get the smaller one.
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}

				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}

			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;

			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}

			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}

		if(preg_match("/<span class=listprice>\\\$([^<]*)<\/span>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if(preg_match("/<td class=\"listprice\">\\\$([^<]*)<\/td>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		else if(preg_match("/<b>List Price:<\/b>[^\\$]+\\$([0-9\.]+)/m", $pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}

		// amazon price value
		if(preg_match("/<td><b class=\"price\">\\\$([^<]*)<\/b>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('price', $regs[1]);
		}

		// Get the mapped AMAZON index type
		$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));

		switch($index_type)
		{
			case 'dvd':
			case 'vhs':
				$this->parse_amazon_video_data($search_attributes_r, $s_item_type, $pageBuffer);
				break;

			case 'videogames':
				$this->parse_amazon_game_data($search_attributes_r, $pageBuffer);
				break;

			case 'books':
				$this->parse_amazon_books_data($search_attributes_r, $pageBuffer);
				break;

			case 'music':
				$this->parse_amazon_music_data($search_attributes_r, $pageBuffer);
				break;

			default://Not much here, but what else can we do?
				break;
		}

	//echo "<pre>";
	//print_r($this->getItemData());
	//echo "</pre>";

		return TRUE;
	}

	/**
		Will return an array of the following structure.
			array(
				"gamepblshr"=>game publisher,
				"gamesystem"=>game platform,
				"gamerating"=>esrb rating
				"features"=>features listing for game,
			);
	*/
	function parse_amazon_game_data($search_attributes_r, $pageBuffer)
	{
		// Publisher extraction block
		if (preg_match("/Other products by <a.*>(.*)<\/a><br>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('gamepblshr', $regs[1]);
		}

		// Platform extraction block
		if (preg_match("/<b>Platform:[\s]*<\/b>(.+?)<br>/si", $pageBuffer, $regs))
		{
			if(preg_match(":&nbsp;[\s](.*):", $regs[1], $regs2))
			{
				// Different combo's of windows, lets treat them all as windows.
				if(strpos($regs2[1], "Windows")!==FALSE)
					$platform = "Windows";
				else
					$platform = trim($regs2[1]);

				$this->addItemAttribute('gamesystem', $platform);
			}
			else
			{
				$this->addItemAttribute('gamesystem', $regs[1]);
			}
		}

		// Rating extraction block
		if (preg_match("/<b>ESRB Rating:[\s]*<\/b>(.+?)<br>/si", $pageBuffer, $regs))
		{
			if(preg_match(":videogames/ratings/esrb-(.*).gif:", $regs[1], $regs2))
				$this->addItemAttribute('gamerating', $regs2[1]);
			else
				$this->addItemAttribute('gamerating', strtoupper($regs[1]));
		}

		// Features extraction block
		if(preg_match("/<b>Features:<\/b>[\s]<ul>(.+?)<\/ul>/si", $pageBuffer, $featureblock))
		{
			if(preg_match_all("/<li.*?>(.*?)<\/li>/si", $featureblock[1], $matches))
			{
				$features = "";
				// generate a list of features
				for($i = 0; $i < count($matches[1]); $i++)
				{
					$features .= strip_tags($matches[1][$i])."\n";
				}

				if(strlen($features)>0)
				{
					$this->addItemAttribute('features', $features);
				}
			}
		}
	}

	/*
	* 	Parse Amazon.com CD item
	*
	* 	Will return
	* 	Array(
	* 		'artist'=>'',
	* 		'release_dt'=>'',
	* 		'year'=>'',
	* 		'musiclabel'=>'',
	* 		'no_discs'=>'',
	* 		'cdtrack'=>Array(...)
	* 	);
	*/
	function parse_amazon_music_data($search_attributes_r, $pageBuffer)
	{
		//<meta name="description" content="Dangerous [Remastered], Michael Jackson">
		//<meta name="keywords" content="Dangerous [Remastered], Music, Michael Jackson">

		//<meta name="description" content="Up!, Shania Twain">
		//<meta name="keywords" content="Up!, Music, Shania Twain, Country, Pop">

		//<meta name="description" content="Essential Mozart: 32 Of His Greatest Masterpieces, Wolfgang Amadeus Mozart, Neville Marriner, Uri Segal, Gyorgy Fischer, Stephen Cleobury, David Hill, Christopher Hogwood, Georg Solti, Willi Boskovsky, Herbert von Karajan, Christoph von Dohnanyi, Myung-Whun Chung, Jack Brymer, Peter Maag, George Guest, Radu Lupu, Cecilia Bartoli, Fritz Dolezal, Werner Hink, Hubert Kroisamer, Peter Schmidl, James Vivian, Emma Kirkby, Lisa Beznosiuk, Frances Kelly, Renee Fleming, Barry Tuckwell, Bryn Terfel, Vladimir Ashkenazy, Andras Schiff, Sumi Jo, Franklin Cohen, Hermann Prey, Kiri Te Kanawa, Joshua Bell, Margaret Marshall, Leontyne Price">
		//<meta name="keywords" content="Essential Mozart: 32 Of His Greatest Masterpieces, Music, Wolfgang Amadeus Mozart, Neville Marriner, Uri Segal, Gyorgy Fischer, Stephen Cleobury, David Hill, Christopher Hogwood, Georg Solti, Willi Boskovsky, Herbert von Karajan, Christoph von Dohnanyi, Myung-Whun Chung, Jack Brymer, Peter Maag, George Guest, Radu Lupu, Cecilia Bartoli, Fritz Dolezal, Werner Hink, Hubert Kroisamer, Peter Schmidl, James Vivian, Emma Kirkby, Lisa Beznosiuk, Frances Kelly, Renee Fleming, Barry Tuckwell, Bryn Terfel, Vladimir Ashkenazy, Andras Schiff, Sumi Jo, Franklin Cohen, Hermann Prey, Kiri Te Kanawa, Joshua Bell, Margaret Marshall, Leontyne Price">

		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $pageBuffer, $regs))
		{
			$contents = explode(",", $regs[1]);
			if(is_not_empty_array($contents))
			{
				// the artist is the last entry in the description.
				$this->addItemAttribute('artist', trim($contents[count($contents)-1]));
			}
		}

		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->addItemAttribute('comments', str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx)));
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
		}

		if(preg_match("!<b>Audio CD</b>.*\(([^\)]+)\)<br>!sU", $pageBuffer, $regs))
		{
			$this->addItemAttribute('release_dt', $regs[1]);
			if(preg_match("!([0-9]+)$!", $this->getItemAttribute('release_dt'), $regs2))
			{
				$this->addItemAttribute('year', $regs2[1]);
			}
		}

		if(preg_match("!<b>Label:</b>([^<]+)<li>!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('musiclabel', $regs[1]);
		}

		if(preg_match("!<b>Number of Discs: </b>([0-9]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}

		if(is_numeric($this->getItemAttribute('no_discs')) && $this->getItemAttribute('no_discs') > 1)
		{
			for($i=0; $i<$this->getItemAttribute('no_discs'); $i++)
			{
				$cdtracks[$i] = parse_music_tracks($pageBuffer, "Track Listings", $i+1);
				if($cdtracks[$i] == NULL)
					$cdtracks[$i] = parse_music_tracks($pageBuffer, "Listen to Samples", $i+1);
			}

			// Now coalesce into single cdtracks array
			if(is_not_empty_array($cdtracks))
			{
				for($i=0; $i<count($cdtracks); $i++)
				{
					if(is_not_empty_array($cdtracks[$i]))
					{
						for($j=0; $j<count($cdtracks[$i]); $j++)
						{
							$this->addItemAttribute('cdtrack', $cdtracks[$i][$j]);
						}
					}
				}
			}
		}
		else
		{
			// one disc
			$this->addItemAttribute('cdtrack', parse_music_tracks($pageBuffer, "Track Listings", NULL));
			if($this->getItemAttribute('cdtrack') === FALSE)
				$this->addItemAttribute('cdtrack', parse_music_tracks($pageBuffer, "Listen to Samples", NULL));
		}
	}

	/**
		Will return an array of the following structure.
			array(
				"author"=>author,
				"publisher"=>publisher,
				"pub_date"=>date published,
				"isbn"=>ISBN number,
				"listprice"=>Regular price,
			);

		If nothing parsed correctly, then this function will returned
		unitialised array.
	*/
	function parse_amazon_books_data($search_attributes_r, $pageBuffer)
	{
		// Author extraction
		//<meta name="description" content="Amazon.com: Books: Managing and Using MySQL (2nd Edition) by George Reese,Randy Jay Yarger,Tim King" />
		// Author extraction
		//<meta name="description" content="Amazon.com: The Da Vinci Code: Books: Dan Brown by Dan Brown" />
		
		if (preg_match('!<meta name="description" content="Amazon.com:.* Books: .* by ([^"]*)"!siU', $pageBuffer, $regs))
		{
			$authors = explode(",", trim($regs[1]));
			if(is_array($authors) && count($authors)>0)
			{
				$author = '';
				for($i=0; $i<count($authors); $i++)
				{
					if(strlen($author)>0)
						$author .= ', ';

					$author .= $authors[$i];
				}

				$this->addItemAttribute('author', initcap($author));
			}
			else
			{
				$this->addItemAttribute('author', initcap($regs[1]));
			}
		}

		//<b>Publisher:</b> Overlook Press; Reissue edition (November 1997)
		$startIndex = strpos($pageBuffer, '<b class="h1">Product Details</b><br />');
		if($startIndex !== FALSE)
		{
			$startIndex += strlen('<b class="h1">Product Details</b><br />');

			$endIndex = strpos($pageBuffer, '</ul>', $startIndex);
			if($endIndex !== FALSE)
			{
				$productDetails = unhtmlentities(trim(substr($pageBuffer, $startIndex, $endIndex-$startIndex)));
				if(preg_match("!<li><b>ISBN:</b>([^<]*)</li>!mU", $productDetails, $regs2))
				{
					$this->addItemAttribute('isbn', $regs2[1]);
				}

				if(preg_match("/([0-9]+) pages/", $productDetails, $regs2))
				{
					$this->addItemAttribute('nb_pages', $regs2[1]);
				}

				if(preg_match("!<li><b>Publisher:</b>[\s]*([^<]*)</li>!m", $productDetails, $regs2))
				{
					if(preg_match("/([^\(]+)\(([^\)]+)\)/", $regs2[1], $regs2))
					{
						// All we want is the year here.
						if (preg_match("/([0-9]+)$/", $regs2[2], $regs3))
						{
							$this->addItemAttribute('pub_date', $regs3[1]);
						}

						if(preg_match("/([^;]+);([^$]+)$/", $regs2[1], $regs3))
						{
							$this->addItemAttribute('publisher', $regs3[1]);
							$this->addItemAttribute('edition', $regs3[2]);
						}
						else
						{
							$this->addItemAttribute('publisher', $regs2[1]);
						}
					}
					else
					{
						$this->addItemAttribute('publisher', $regs2[1]);
					}
				}
			}
		}

		// Editorial reviews
//		http://www.amazon.com/gp/product/product-description/0345447565/ref=dp_proddesc_0/104-5908506-1204717?%5Fencoding=UTF8&n=283155
		if(preg_match("!<a href=\"http://www.amazon.com/gp/product/product-description/".$search_attributes_r['amazonasin']."/!", $pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.com/gp/product/product-description/".$search_attributes_r['amazonasin']."/");
			if(strlen($reviewPage)>0)
			{
				//<b class="h1">Editorial Reviews</b>
				$start = strpos($reviewPage, "<b class=\"h1\">Editorial Reviews</b>");
				if($start !== FALSE)
				{
					$start = strpos($reviewPage, "<div class=\"content\">", $start);
					if($start !== FALSE)
					{
						$end = strpos($reviewPage, "</div>", $start);
						if($end !== FALSE)
							$reviewPage = substr($reviewPage,$start,$end-$start);
						else
							$reviewPage = substr($reviewPage,$start);

						// If still something to parse.
						if(strlen($reviewPage)>0)
						{
							//<b>The Times of London</b><br />
							if(preg_match_all("!<b>(.*?)</b>!m", $reviewPage, $matches))
							{
								for($i=0; $i<count($matches[0]); $i++)
								{
									$block = NULL;
									
									$start = strpos($reviewPage, $matches[0][$i]);
									if($start!==FALSE)
									{
										$start += strlen($matches[0][$i]);
										
										$start = strpos($reviewPage, "<br />", $start);
										if($start!=FALSE)
										{
											$start += strlen("<br />");
											
											$end = strpos($reviewPage, "<br />", $start);
											
											if($end !== FALSE)
											{
												$block = substr($reviewPage, $start, $end - $start);
											}
										}
									}
									
									if(strlen($block)>0)
									{
										// The author, is the first match, the actual review the second one.
										$author = trim(unhtmlentities(strip_tags($matches[1][$i])));
	
										if($author != 'About the Author') // a hack!
										{
											// trim copyright notice.
											if(($copyidx = strpos($matches[2][$i], "-- <I>Copyright"))!==FALSE)
											{
												$block = trim(substr($block,0,$copyidx));
											}
	
											$review = $block;
	
											// some specific fucked up review formatting to deal with!!!
											$review = preg_replace("/<p>/i", "\n\n", $review);
											$review = preg_replace("/<br>/i", "\n", $review);
											$review = str_replace("&#149;", "*", $review);
											$review = str_replace("&#8220;", "\"", $review);
											$review = str_replace("&#8221;", "\"", $review);
											$review = str_replace("&#8217;", "'", $review);
											$review = str_replace("&#8211;", "-", $review);
											$review = str_replace("&#8212;", "-", $review);
											$review = str_replace("&ndash;", "-", $review);
	
											$review = trim(unhtmlentities(convert_html_numeric_codes(strip_tags($review))));
	
											// some extra processing to try and remove as many duplicate reviews as possible
											$review = str_replace("\"", "", $review);
											$review = preg_replace("/[ \t]+/i", " ", $review);
											$review = str_replace("\n ", "\n", $review);
	
											if(strlen($author)>0 &&
													$author != 'Amazon.com' &&
													$author != 'Book Info' &&
													$author != 'Product Description:')
											{
												$review .= "\n-- $author";
											}
	
											$this->addItemAttribute('blurb', $review);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	/**
		Will return an array of the following structure.
			array(
				"year"=>year,
				"age_rating"=>age_rating,
				"dvd_region"=>dvd_region, // not applicable for VHS,DIVX,etc
				"ratio"=>ration,
				"audio_lang"=>spoken languages,
				"subtitles"=>subtitles,
				"run_time"=>runtime,
				"director"=>director,
				"actors"=>actors,
			);

		If nothing parsed correctly, then this function will returned
		unitialised array.
	*/
	function parse_amazon_video_data($search_attributes_r, $s_item_type, $pageBuffer)
	{
		//Amazon.com: DVD: First Blood (Special Edition) (1982)
		// Need to escape any (, ), [, ], :, .,
		if (preg_match("/".preg_quote($this->getItemAttribute('title'), "/")." \(([0-9]*)\)/s", $pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}

        // All Amazon.com (US) items should be NTSC!
		$this->addItemAttribute('vid_format', 'NTSC');

		// Actor extraction block
		$startidx = strpos($pageBuffer, "<li><b>Actors:</b>");
		if($startidx!==FALSE)
		{
		    $startidx += strlen("<li><b>Actors:</b>");
			$endidx = strpos($pageBuffer, "</li>", $startidx);
			if($endidx!==FALSE)
			{
			    $actorBlock = substr($pageBuffer, $startidx, $endidx-$startidx);

				$actors = "";
				if(preg_match_all("/<a href=([^>]+)>([^<]+)<\/a>/", $actorBlock, $matches))
				{
					for($i=0; $i<count($matches[1]); $i++)
					{
						if(strpos($matches[2][$i], "See more")!==FALSE)
						{
							// should we get complete cast list here
							$actorPage = $this->fetchURI('http://www.amazon.com/gp/product/cast-crew/'.$search_attributes_r['amazonasin']);

							//<b class="h1">Cast and Crew</b><a name="cast_crew"/><br />
							$startIndex = strpos($actorPage, "<b class=\"h1\">Cast and Crew</b><a name=\"cast_crew\"/>");
							if($startIndex!==FALSE)
							{
							    $startIndex += strlen("<b class=\"h1\">Cast and Crew</b><a name=\"cast_crew\"/>");

								$endIndex = strpos($actorPage, "<hr noshade size=1>", $startIndex);
								if($endIndex!==FALSE)
									$actorsPage = substr($actorPage, $startIndex, $endIndex-$startIndex);
								else
									$actorsPage = substr($actorPage, $startIndex);

								//<a href="/gp/imdb/actor/nm0000191/ref=imdbdpccav_a0_0/103-0125766-4504675"><b>Ewan McGregor</b></a><i>...Ed Bloom (Young)</i><br />
								if(preg_match_all("/<a href=\"[^\"]+\"><b>([^<]+)<\/b><\/a>[^<]*<i>([^<]+)<\/i>/mi", $actorsPage, $matches))
								{
									// reset at this point.
									$actors = "";

									for($i=0; $i<count($matches[1]); $i++)
									{
										if(strlen($actors)>0)
											$actors .= ", ";
										$actors .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[1][$i]))));
									}
								}
							}
						}
						else
						{
						    if(strlen($actors)>0)
								$actors .= ", ";
							$actors .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[2][$i]))));
						}
					}
				}

				if(strlen($actors)>0)
				{
					$this->addItemAttribute('actors', $actors);
				}
			}
		}

		$startidx = strpos($pageBuffer, "<li><b>Directors:</b>");
		if($startidx!==FALSE)
		{
		    $startidx += strlen("<li><b>Directors:</b>");
			$endidx = strpos($pageBuffer, "</li>", $startidx);
			if($endidx!==FALSE)
			{
			    $actorBlock = substr($pageBuffer, $startidx, $endidx-$startidx);

				$directors = "";
				if(preg_match_all("/<a href=([^>]+)>([^<]+)<\/a>/", $actorBlock, $matches))
				{
					for($i=0; $i<count($matches[1]); $i++)
					{
						if(strpos($matches[2][$i], "See more")===FALSE)
						{
						    if(strlen($directors)>0)
								$directors .= ", ";
							$directors .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[2][$i]))));
						}
					}
				}

				if(strlen($directors)>0)
				{
					$this->addItemAttribute('director', $directors);
				}
			}
		}

		// Region extraction block
		//<li><b>Region: </b>Region 1
		if (preg_match("/<li><b>Region:[\s]*<\/b>Region ([0-6])/", $pageBuffer, $regs))
		{
			$this->addItemAttribute('dvd_region', $regs[1]);
		}

		// Ratio
		//<li><b>Aspect Ratio:</b> 1.85:1</li>
		if(preg_match("!<li><b>Aspect Ratio:</b>(.*)<\/li>!", $pageBuffer, $regs))
		{
			if(preg_match_all("/([0-9]{1}\.[0-9]+):1/", $regs[1], $matches))
			{
				$this->addItemAttribute('ratio', $matches[1]);
			}
		}

        if(preg_match("/<li><b>Number of discs:[\s]*<\/b>[\s]*([0-9]+)/", $pageBuffer, $regs2))
		{
			$this->addItemAttribute('no_discs', $regs2[1]);
   		}

        //<li><b>Rated:</b> <img src="http://g-images.amazon.com/images/G/01/detail/pg-13.gif" width=35 height=11 width=35 height=11>
		// Rating extraction block
		if (preg_match("/<b>Rated:[\s]*<\/b>[\s]*<img src=\"([^\"]+)\"/mi", $pageBuffer, $regs))
		{
			//if(preg_match("/<img src=.* alt=\"(.*)\">/", trim($regs[1]), $regs2))
			if(preg_match("!detail/([^\.]+)\.gif!", $regs[1], $regs2))
			{
				$age_rating = strtoupper(trim($regs2[1]));

				// A very strange problem with an age rating of 'PG-13 \"'
				$indexOfSpace = strpos($age_rating," ");
				if($indexOfSpace!==FALSE)
					$age_rating = substr($age_rating,0,$indexOfSpace);

				$this->addItemAttribute('age_rating', $age_rating);
			}
			else
			{
				$this->addItemAttribute('age_rating', $regs[1]);
			}
		}

		if (preg_match("/<b>Studio:<\/b>(.*)<\/li>/", $pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}

		//<li><b>DVD Release Date:</b> April 27, 2004</li>
		if(preg_match("/<b>DVD Release Date:<\/b>([^<]+)<\/li>/i", $pageBuffer, $regs))
		{
			// Get year only, for now.  In the future we may add ability to
			// convert date to local date format.
			if(preg_match("/([0-9]+)$/m", $regs[1], $regs2))
			{
				$this->addItemAttribute('dvd_rel_dt', $regs2[1]);

				// if year not defined, use dvd_rel_dt
				if($this->getItemAttribute('year') === FALSE)
				{
					$this->addItemAttribute('year', $regs2[1]);
				}
			}
		}

        // Duration extraction block
		//<li><b>Run Time:</b> 125 minutes </li>
		if (preg_match("/<li><b>Run Time:<\/b> ([0-9]+) minutes/i", $pageBuffer, $regs))
		{
   			$this->addItemAttribute('run_time', $regs[1]);
		}

		//<li><b>Average Customer Review:</b> <img src="http://g-images.amazon.com/images/G/01/x-locale/common/customer-reviews/stars-4-0.gif" width="64" align="absbottom" height="12" border="0" /> Based on 385 Reviews</li>
        if (preg_match("/<li><b>Average Customer Review:<\/b>(.*)<\/li>/i", $pageBuffer, $regs))
		{
		    if(preg_match("/customer-reviews\/stars-([0-9]+)/",$regs[0], $matches))
		    {
		        $this->addItemAttribute('amazon_review', $matches[1]);
		    }
		}

        // Get the anamorphic format attribute - Thanks to Andr Monz <amonz@users.sourceforge.net
		if(preg_match("/anamorphic/",$pageBuffer))
		{
			$this->addItemAttribute('anamorphic', 'Y');
   		}

        if (preg_match("/THX Certified/i", $pageBuffer))
		{
			$this->addItemAttribute('audio_lang', 'ENGLISH_THX');
		}

        // Spoken languages
        //<li>Available Audio Tracks:  English (Dolby Digital 5.1), French (Dolby Digital 2.0 Surround)</li>
		if(preg_match("/<li>Available Audio Tracks:[\s]*(.*)<\/li>/i", $pageBuffer, $regs))
		{
			$audio_lang_r = explode(',', $regs[1]);

			// this is a bit of a hack I hope to make configurable some time soon.
			$amazon_video_audio_lang_map = array(
						"ENGLISH_2.0"=>array("English", "2.0"),
						"ENGLISH_5.0"=>array("English", "5.0"),
						"ENGLISH_5.1"=>array("English", "5.1"),
						"ENGLISH_6.1_EX"=>array("English", "6.1", "EX"), // Dolby Digital 6.1 EX
						"ENGLISH_6.1_DTS_ES"=>array("English", "6.1", "DTS", "ES"), // English (6.1 DTS ES)
						"ENGLISH_6.1"=>array("English", "6.1"),
						"ENGLISH_DTS"=>array("English", "DTS"),
						"FRENCH"=>array("French"),
						"SPANISH"=>array("Spanish"),
						"GERMAN"=>array("German"));

			// Now we can process each separate language value.
			while(list(,$audio_lang) = @each($audio_lang_r))
			{
				reset($amazon_video_audio_lang_map);
				while(list($key,$find_r) = @each($amazon_video_audio_lang_map))
				{
					// all components of the $find_r have to be present for a match to occur
					$found = TRUE;
					while(list(,$srch) = each($find_r))
					{
						if (strpos($audio_lang, $srch) === FALSE)
						{
							$found=FALSE;
							break;
						}
					}

					if($found)
					{
						$this->addItemAttribute('audio_lang', strtoupper($key));
						break;
					}
				}
			}
		}

		// Subtitles
		//<li>Available Subtitles: English, French</li>
		if (preg_match("/<li>Available Subtitles:[\s]*(.*)<\/li>/i", $pageBuffer, $regs))
		{
			// this is a bit of a hack I hope to make configurable some time soon.
			$amazon_video_subtitle_map = array("English", "French", "Spanish", "German");
			while(list(,$subtitle) = @each($amazon_video_subtitle_map))
			{
				if (strpos($regs[1], $subtitle)!==FALSE)
				{
					$this->addItemAttribute('subtitles', strtoupper($subtitle));
				}
			}
		}

        // Edition details block - 'dvd_extras' attribute
		if(preg_match("/<li><b>DVD Features:<\/b><ul>(.+?)<\/ul>/si", $pageBuffer, $regs))
		{
		    $dvdFeaturesBlock = $regs[1];

			if(preg_match_all("/<li>(.*)<\/li>/mUi", $dvdFeaturesBlock, $matches))
			{
				$dvd_extras = '';

				while(list(,$item) = @each($matches[1]))
				{
					$item = unhtmlentities(convert_html_numeric_codes(strip_tags($item)));

					// We may have a hard space here, so get rid of it.
					$item = trim(strtr($item, chr(160), ' '));

					// Don't include anamorphic, subtitles, audio tracks, etc
					if(strpos($item, "anamorphic")===FALSE &&
								strpos($item, "Available Subtitles")===FALSE &&
								strpos($item, "Available Audio Tracks")===FALSE)
					{
						$dvd_extras .= $item."\n";
					}
				}

				if(strlen($dvd_extras)>0)
				{
					$this->addItemAttribute('dvd_extras', $dvd_extras);
				}
			}
		}

        $startIndex = strpos($pageBuffer, "<b class=\"h1\">Editorial Reviews</b><br />");
		if($startIndex!==FALSE)
		{
		    $startIndex += strlen("<b class=\"h1\">Editorial Reviews</b><br />");
			$startIndex = strpos($pageBuffer, "<b>Amazon.com</b><br />", $startIndex);
			if($startIndex!==FALSE)
			{
			    $startIndex += strlen("<b>Amazon.com</b><br />");
			    $endIndex = strpos($pageBuffer, "<br />", $startIndex);
			    if($endIndex!==FALSE)
			    {
			        $reviewBlock = substr($pageBuffer, $startIndex, $endIndex - $startIndex);
					$this->addItemAttribute('blurb', unhtmlentities(convert_html_numeric_codes(strip_tags($reviewBlock))));
				}
			}
		}

		// IMDB ID block
		//<A HREF="http://amazon.imdb.com/title/tt0319061/">
		//http://www.amazon.com/gp/redirect.html/103-0177494-1143005?location=http://amazon.imdb.com/title/tt0319061&token=F5BF95E1B869FD4EB1192434BA5B7FECBA8B3718
		//http://amazon.imdb.com/title/tt0319061
		if(preg_match("!http://amazon.imdb.com/title/tt([0-9]+)!is", $pageBuffer, $regs))
		{
			$this->addItemAttribute('imdb_id', $regs[1]);
		}

		// Attempt to include data from IMDB if available - but only for DVD, VHS, etc
		// as IMDB does not work with BOOKS or CD's.
		if(is_numeric($this->getItemAttribute('imdb_id')))
		{
			$sitePlugin =& get_site_plugin_instance('imdb');
			if($sitePlugin !== FALSE)
			{
				if($sitePlugin->queryItem(array('imdb_id'=>$this->getItemAttribute('imdb_id')), $s_item_type))
				{
					// no mapping process is performed here, as no $s_item_type was provided.
					$itemData = $sitePlugin->getItemData();
					if(is_array($itemData))
	      			{
						// merge data in here.
						while(list($key,$value) = each($itemData))
						{
							if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'director')
								$this->replaceItemAttribute('director', $value);
							else if($key == 'year')
								$this->replaceItemAttribute('year', $value);
							else if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'genre')
								$this->replaceItemAttribute('genre', $value);
							else if($key == 'plot') //have to map from imdb to amazon attribute type.
								$this->addItemAttribute('blurb', $value);
							else if($key != 'age_rating' && $key != 'run_time')
								$this->addItemAttribute($key, $value);
						}
					}
				}
			}
		}
	}
}
?>
