###################################################################
# Support for DIVX
#
# For existing users to update their DIVX definition without having
# to reinstall the OpenDb.sql script.
###################################################################
#

#
# Cleanup first.
#
DELETE FROM s_item_type WHERE s_item_type = 'DIVX';
DELETE FROM s_item_attribute_type WHERE s_item_type = 'DIVX';
DELETE FROM s_attribute_type WHERE s_attribute_type IN('DIVXVIDVER', 'DIVXAUDVER', 'DIVXQUALIT');
DELETE FROM s_attribute_type_lookup WHERE s_attribute_type  IN('DIVXVIDVER', 'DIVXAUDVER', 'DIVXQUALIT');

#
# System Item type definition
#
INSERT INTO s_item_type (s_item_type, description, image, order_no) VALUES ( 'DIVX', 'DivX Video', 'divX.gif', '3');

#
# DIVX attributes
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXVIDVER', 'Video Codec Version', 'Video Codec', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXAUDVER', 'Audio Codec Version', 'Audio Codec', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'DIVXQUALIT', 'DIVX Quality', 'Quality', 'single_select(%display%)', 'display(%display%, list-link)', NULL, NULL); 


#
# s_item_attribute_type relationships
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'MOVIE_PLOT', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIRECTOR', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'ACTORS', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'MOVIEGENRE', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'YEAR', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'RUN_TIME', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AUDIO_LANG', '80', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'SUBTITLES', '90', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AGE_RATING', '100', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'RATIO', '110', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXVIDVER', '120', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXAUDVER', '130', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DIVXQUALIT', '140', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DVD_FORMAT', '150', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'DVD_EXTRAS', '160', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'S_STATCMNT', '255', NULL, NULL);

#
# s_attribute_type_lookup values
#

# DIVX Audio codec
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp3', 'Mp3', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp2', 'Mp2', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'ogg', 'Ogg', NULL, NULL);

# DIVX Video codec
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx3', 'Divx3 3.11 Alpha', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx4', 'Divx4', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx5', 'Divx5', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'xvid', 'Xvid', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'angelpotion', 'Angel Potion Codec', NULL, NULL);

# DIVX Quality
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'poor', 'Poor', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'medium', 'Medium', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'Good', 'Good', NULL, NULL);
