<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/widgets.php");
include_once("./functions/user.php");
include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/chart.php");
include_once("./functions/item_type.php");

// ---------------------------------------------------------------------------------------
// Include functions here, as this is the only place they are to be used....
// ---------------------------------------------------------------------------------------

function build_owner_item_chart_info($s_item_type, $total_items)
{
	if(!is_numeric($total_items))
	{
		$total_items = fetch_item_instance_cnt($s_item_type);
	}
	
	$result = fetch_user_rs(get_owner_user_types_r()); // fetch a list of owners
	if($result)
	{
		$ix=0;
		while ($user_r = mysql_fetch_array($result, MYSQL_ASSOC)) // next user..
		{
			$num_total = fetch_owner_item_cnt($user_r['user_id'], $s_item_type);
			if($num_total>0 && $total_items>0)
			{
				$info[$ix][0] = $user_r['fullname'];	           // caption
				$info[$ix][1] = ( $num_total * 100) / $total_items;  // calculate %
				$ix++;
			}
		}
		mysql_free_result($result);
	}

	return $info;
}

/**
	Returns an array for chart.php, contents of categories for items of s_item_type

	The Category percentages are based on total category occurences, not the
	number of items.  This is because more than one category may be present
	in a item category column.
*/
function build_item_category_chart_info($s_item_type, $total_items)
{
	global $CONFIG_VARS;

	// Must be explicitly set!
	if($CONFIG_VARS['stats.category_barchart'] === TRUE)
	{
		$barchart = TRUE;
		$max_label_chars = 18; // Bar chart has tonnes of room
	}
	else
	{
		$barchart = FALSE;
		$max_label_chars = 15; // "Science Fiction" == 15 chars
	}
	
	if(!is_numeric($total_items))
	{
		$total_items = fetch_item_instance_cnt($s_item_type);
	}
	
	$category_attribute_type = fetch_sfieldtype_item_attribute_type($s_item_type, 'CATEGORY');
	if($category_attribute_type)
	{
		$results = fetch_attribute_type_lookup_rs($category_attribute_type);
		if($results)
		{
			$ix=0;
			while($attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC)) // next category...
			{
				$num_total = fetch_category_item_cnt($attribute_type_r['value'], $s_item_type);
				if($num_total>0)
				{
					$category = $attribute_type_r['display'];
					if( strlen($category)>$max_label_chars )
						$caption  = substr($category, 0, $max_label_chars-3)."...";
					else
						$caption = $category;

					$info[$ix][0] = $caption;                          	// caption
					$info[$ix][1] = ( $num_total * 100) / $total_items; // calculate %
					$num_totals[$ix] = $num_total;
					$num_items += $num_total;

					$ix++;
				}
			}
			mysql_free_result($results);

			// Calculate percentage based on number of occurences of the category.
			// For instance 'Action / Adventure' is counted as 2.
			if(!$barchart)
			{
				// Now calculate the percentages.
				$ix = 0;
				while(list(,$num_total) = @each($num_totals))
				{
					$info[$ix][1] = ( $num_total * 100) / $num_items; // calculate %
					$ix++;
				}
			}
		}
	}
	return $info;
}

function build_item_types_chart_info($total_items)
{
	if(!is_numeric($total_items))
	{
		$total_items = fetch_item_instance_cnt();
	}
	
	$ix=0;// temporary array index
	$results = fetch_item_type_rs();
	while( $item_type_r = mysql_fetch_array($results, MYSQL_ASSOC) )
	{
		$num_total = fetch_item_instance_cnt($item_type_r['s_item_type']);
		if($num_total>0 && $total_items>0)
		{
			$info[$ix][0] = $item_type_r['s_item_type']; // caption
			$info[$ix][1] = ( $num_total * 100) / $total_items;  // calculate %
			$ix++;
		}
	}
	mysql_free_result($results);

	return $info;
}

function build_item_ownership_chart_info($total_items)
{
	if(!is_numeric($total_items))
	{
		$total_items = fetch_item_instance_cnt();
	}
				
	$results = fetch_status_type_rs(TRUE);
	if($results)
	{
		while ($status_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			// Will be used by stats graph!
			$status_type_r['total'] = 0;
			$status_type_rs[] = $status_type_r;
		} 
		mysql_free_result($results);
	}
		
	$ix = 0;
	$results = fetch_user_rs(get_owner_user_types_r());//only ACTIVE owner users!
	if($results)
	{
		while ($user_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$num_total = 0;
			if(is_not_empty_array($status_type_rs))
			{
				reset($status_type_rs);
	    		while(list($key, $status_type_r) = each($status_type_rs))
				{
					$status_total = fetch_owner_s_status_type_item_cnt($user_r['user_id'], $status_type_r['s_status_type']);
					$num_total += $status_total;
				}
				$sum_total += $num_total;
			}

			// pie chart data
			if($num_total>0)
			{
				$info[$ix][0] = $user_r['fullname'];	           // caption
				$info[$ix][1] = ( $num_total * 100) / $total_items;  // calculate %
				$ix++;
			}
		}//while ($user_r = mysql_fetch_array($result, MYSQL_ASSOC))
		mysql_free_result($results);
	}
	return $info;
}

session_start();
if (is_opendb_valid_session())
{
	if($HTTP_VARS['op'] == 'graph')
	{
		// Load GD Library if not already loaded
		// Thanks to Laurent CHASTEL (lchastel)
		if (!@extension_loaded('gd'))
		{
			if((boolean)@ini_get('enable_dl'))// is dynamic load enabled
			{ 
				if(strlen($CONFIG_VARS['chart.gd.library'])>0)
				@dl($CONFIG_VARS['chart.gd.library']);
			} // enable_dl
		} // gd

		//----------------------------------------------------------------
		// Here we are going to access the theme configuration for graphs
		// See docs/misc/chart.colors.txt for more information
		//----------------------------------------------------------------
		$graphCfg = _theme_graph_config();
	
		// Defines the image type to use.  'png', 'jpeg'/'jpg' supported!
		$imgType = strlen($CONFIG_VARS['stats.image_type'])>0? $CONFIG_VARS['stats.image_type'] : "png";
		
		// standard threshold.
		$chartOptions['threshold'] = 3;

		// Default pie chart options.		
		if(strcasecmp($CONFIG_VARS['stats.piechart_sort'],"asc")===0 || strcasecmp($CONFIG_VARS['stats.piechart_sort'],"desc")===0)
			$sortorder = strtolower($CONFIG_VARS['stats.piechart_sort']);
				
		if($CONFIG_VARS['stats.piechart_12oclock'] === TRUE)
			$chartOptions['12oclock'] = TRUE;
		else
			$chartOptions['12oclock'] = FALSE;

		if($CONFIG_VARS['stats.piechart_striped'] === TRUE)
			$chartOptions['striped'] = TRUE;
		else
			$chartOptions['striped'] = FALSE;
		
		switch($HTTP_VARS['graphtype'])
		{
			case 'item_ownership':
				build_and_send_graph(
					build_item_ownership_chart_info($HTTP_VARS['total_items']), 
					$sortorder, 
					'piechart', //chartype
					$chartOptions, 
					$graphCfg, 
					$imgType);
				break;
			
			case 'item_types':
				build_and_send_graph(
					build_item_types_chart_info($HTTP_VARS['total_items']), 
					$sortorder, 
					'piechart', //chartype
					$chartOptions, 
					$graphCfg, 
					$imgType);
				break;
			
			case 'item_type_ownership':
				build_and_send_graph(
					build_owner_item_chart_info($HTTP_VARS['s_item_type'], $HTTP_VARS['total_items']), 
					$sortorder, 
					'piechart', //chartype
					$chartOptions, 
					$graphCfg, 
					$imgType);
				break;
			
			case 'item_type_category':
				if($CONFIG_VARS['stats.category_barchart'] === TRUE)
				{
					// Is the barchart being sorted.
					if(strcasecmp($CONFIG_VARS['stats.barchart_sort'],"asc")===0 || strcasecmp($CONFIG_VARS['stats.barchart_sort'],"desc")===0)
						$sortorder = strtolower($CONFIG_VARS['stats.barchart_sort']);
				
					// These options are currently ignored for barcharts
					$chartOptions['striped'] = FALSE;
					$chartOptions['12oclock'] = FALSE;
					
					build_and_send_graph(
						build_item_category_chart_info($HTTP_VARS['s_item_type'], $HTTP_VARS['total_items']),
						$sortorder, 
						'barchart', //chartype
						$chartOptions, 
						$graphCfg, 
						$imgType);
				}
				else
				{
					build_and_send_graph(
						build_item_category_chart_info($HTTP_VARS['s_item_type'], $HTTP_VARS['total_items']), 
						$sortorder, 
						'piechart', //chartype
						$chartOptions, 
						$graphCfg, 
						$imgType);
				}
				break;
			
			default:
				// what to do here!
		}
	}
	else
	{
		echo _theme_header($LANG_VARS['statistics']);
		echo("<h2>".$LANG_VARS['statistics']."</h2>");

		echo("<div class=\"prompt\">- ".$LANG_VARS['general_facts'].":</div><br>");
		echo("<div class=\"colortext\">");

		$num_users = fetch_user_cnt(get_owner_user_types_r());//only users who can own
	
		// This count should not include owner's items, where the owner has been DEACTIVATED.
		$total_items = fetch_item_instance_cnt();
		echo($LANG_VARS['owner(s)'].": ".$num_users."\n<br>");
		echo($LANG_VARS['item(s)'].": ".$total_items."\n<br>");

		$avgrate = fetch_review_rating();
		if($avgrate>0)
		{
			$num_review = fetch_review_cnt();
			echo($LANG_VARS['review(s)'].": ".$num_review."<br>\n");
		
			echo($LANG_VARS['average_rating'].":\n");
			$attribute_type_r = fetch_attribute_type_r("S_RATING");
			echo get_display_field($attribute_type_r['s_attribute_type'], 
							NULL, 
							'review()',
							$avgrate,
							FALSE);
		}
	
		// Get the list of valid status_types, which we can display
	    // in this statistics page.
	    $results = fetch_status_type_rs(TRUE);
	    if ($results)
		{
	        while ($status_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$status_type_r['total'] = 0;
	            $status_type_rs[] = $status_type_r;
	        } 
	        mysql_free_result($results);
	    }

	    echo("\n</div><br><br>".
			"\n<div class=\"prompt\">- ".$LANG_VARS['owner_information'].":&nbsp;</div><br>".
			"\n<table width=100% cellspacing=1 cellpadding=1 border=0 frameborder=0>".
			"\n<tr>");

		echo("\n<td class=\"navbar\" rowspan=2>".$LANG_VARS['owner']."</td>");
		
		if($CONFIG_VARS['borrow.enable'] !== FALSE)
		{
			echo("\n<td class=\"navbar\" colspan=2>".$LANG_VARS['borrow_stats']."</td>");
		}
		
		if(is_not_empty_array($status_type_rs))
		{
			echo("\n<td class=\"navbar\" colspan=" .(count($status_type_rs)+1).">".$LANG_VARS['status_stats']."</td>".
				"\n</tr>".
				"\n<tr>");
		}
		
		if($CONFIG_VARS['borrow.enable'] !== FALSE)
		{
			echo("\n<td class=\"navbar\">"._theme_image('reserved.gif', $LANG_VARS['reserved'], NULL, NULL, "borrowed_item")."</td>");
			echo("\n<td class=\"navbar\">"._theme_image('borrowed.gif', $LANG_VARS['borrowed'], NULL, NULL, "borrowed_item")."</td>");
		}			

		if(is_not_empty_array($status_type_rs))
		{
		    reset($status_type_rs);
		    while(list(, $status_type_r) = each($status_type_rs))
			{
				echo("\n<td class=\"navbar\">".
					_theme_image($status_type_r['img'], $status_type_r['description'], NULL, NULL, "borrowed_item").
					"</td>");
			}
			echo("\n<td class=\"navbar\">&nbsp;".$LANG_VARS['total']."&nbsp;</td></tr>");
		}

		$result = fetch_user_rs(get_owner_user_types_r());//only ACTIVE owner users!
		if($result)
		{
			$toggle=TRUE;

			// Totals.
			$sum_loaned = 0;
			$sum_reserved = 0;

			while ($user_r = mysql_fetch_array($result, MYSQL_ASSOC))
			{
				if($toggle)
					$color="top";
				else
			 		$color="top2";
				$toggle = !$toggle;

				$user_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", $user_r['fullname']), 'user_id'=>$user_r['user_id']), $LANG_VARS['user_name']);
				echo("<tr>\n<td align=\"center\" class=\"$color\"><a href=\"listings.php?owner_id=".$user_r['user_id']."&s_status_type=ALL&order_by=title&sortorder=ASC\">".$user_name."</a></td>\n");
			
				if($CONFIG_VARS['borrow.enable'] !== FALSE)
				{
					$reserved_total = fetch_owner_reserved_item_cnt($user_r['user_id']);
					$sum_reserved += $reserved_total;
				
					echo("\n<td align=\"center\" class=\"$color\">");
					if($reserved_total>0)
						echo($reserved_total);
					else
						echo("-");
					echo("</td>\n");
				
					$loan_total = fetch_owner_borrowed_item_cnt($user_r['user_id']);
					$sum_loaned += $loan_total;
				
					echo("\n<td align=\"center\" class=\"$color\">");
					if($loan_total>0)
						echo($loan_total);
					else
						echo("-");
					echo("</td>\n");
				}
			
				$num_total = 0;
				if(is_not_empty_array($status_type_rs))
				{
					reset($status_type_rs);
		    		while(list($key, $status_type_r) = each($status_type_rs))
					{
						$status_total = fetch_owner_s_status_type_item_cnt($user_r['user_id'], $status_type_r['s_status_type']);
						$status_type_rs[$key]['total']  += $status_total;
				
						echo("\n<td align=\"center\" class=\"$color\">");
						if($status_total>0)
							echo("<a href=\"listings.php?owner_id=".$user_r['user_id']."&s_status_type=".$status_type_r['s_status_type']."&order_by=title&sortorder=ASC\">$status_total</a>");
						else
							echo("-");
						echo("</td>\n");
				
						$num_total += $status_total;
					}
					$sum_total += $num_total;
				
					echo("\n<td align=\"center\" class=\"$color\">".$num_total."</td>\n");
				}
			
				echo("</tr>\n");
			}//while ($user_r = mysql_fetch_array($result, MYSQL_ASSOC))
			mysql_free_result($result);
		
			echo("<tr>\n<td class=\"navbar\">&nbsp;</td>\n");

			// sum loaned.
			if($CONFIG_VARS['borrow.enable'] !== FALSE)
			{
				echo("<td class=\"navbar\">".$sum_reserved."</td>\n");
				echo("<td class=\"navbar\">".$sum_loaned."</td>\n");
			}
		
			if(is_not_empty_array($status_type_rs))
			{
				reset($status_type_rs);
	    		while(list(, $status_type_r) = each($status_type_rs))
				{
					echo("<td class=\"navbar\">".$status_type_r['total']."</td>\n");
				}
				echo("<td class=\"navbar\">".$sum_total."</td>\n");
			}
			echo("</tr>\n");
		}
		echo("</table>\n");

		echo(format_help_block($LANG_VARS['stats_help']).
			'<br><br>');

		echo("<div class=\"prompt\">- ".$LANG_VARS['all_item_breakdown'].":&nbsp;</div><br>\n");
		echo("<table width=100%><tr>\n");

		// Show ownership graph
		echo("<td width=50%>\n");
		echo("<div class=\"fineprint\">".$LANG_VARS['item_ownership'].":&nbsp;</div>");
		echo("<img class=\"graph\" src=\"stats.php?op=graph&graphtype=item_ownership&total_items=$total_items\" title=\"".$LANG_VARS['database_ownership_piechart']."\" alt=\"".$LANG_VARS['database_ownership_piechart']."\" border=1>");
		echo("</td>\n");

		// Show media types graph!
		echo("<td width=50%>\n");
		echo("<div class=\"fineprint\">".$LANG_VARS['item_types'].":&nbsp;</div>");
		echo("<img class=\"graph\" src=\"stats.php?op=graph&graphtype=item_types&total_items=$total_items\" title=\"".$LANG_VARS['database_itemtype_piechart']."\" alt=\"".$LANG_VARS['database_itemtype_piechart']."\" border=1>");
		echo("</td>\n");
		echo("</tr></table>\n");
		unset($info);

		echo("<br><br>\n");

		// Graph breakdowns by $s_item_type
		$itemresults = fetch_item_type_rs();
		while( $item_type_r = mysql_fetch_array($itemresults, MYSQL_ASSOC) )  // cycle through all s_item_type's
		{
			$type_total_items = fetch_item_instance_cnt($item_type_r['s_item_type']);
			if( $type_total_items>0 ) // omit empty s_type graphs
			{
        	    echo("<div class=\"prompt\">- ".replace_lang_vars(array('desc'=>$item_type_r['description'],'s_item_type'=>$item_type_r['s_item_type']), $LANG_VARS['itemtype_breakdown']).":&nbsp;</div></div><br>\n");
				echo("<div class=\"colortext\">".get_item_image($item_type_r['s_item_type'])." (".replace_lang_var("count", $type_total_items, $LANG_VARS['itemtype_items']).")</div>\n");
				echo("<table width=100%><tr>\n");

				echo("<td width=50%>\n");
				echo("<div class=\"fineprint\">".replace_lang_var("s_item_type", $item_type_r['s_item_type'], $LANG_VARS['itemtype_ownership']).":&nbsp;</div>");
				$itemtype_ownership_piechart_alt_text = replace_lang_var("s_item_type", $item_type_r['s_item_type'], $LANG_VARS['itemtype_ownership_piechart']);
				echo("<img class=\"graph\" src=\"stats.php?op=graph&graphtype=item_type_ownership&s_item_type=".urlencode($item_type_r['s_item_type'])."&total_items=$type_total_items\" title=\"$itemtype_ownership_piechart_alt_text\" alt=\"$itemtype_ownership_piechart_alt_text\" border=1>");
				echo("</td>\n");

				echo("<td width=50%>\n");
				echo("<div class=\"fineprint\">".replace_lang_var("s_item_type", $item_type_r['s_item_type'], $LANG_VARS['itemtype_category']).":&nbsp;</div>");
				$itemtype_category_piechart_alt_text = replace_lang_var("s_item_type", $item_type_r['s_item_type'], $LANG_VARS['itemtype_category_piechart']);
				echo("<img class=\"graph\" src=\"stats.php?op=graph&graphtype=item_type_category&s_item_type=".urlencode($item_type_r['s_item_type'])."&total_items=$type_total_items\" title=\"$itemtype_category_piechart_alt_text\" alt=\"$itemtype_category_piechart_alt_text\" border=1>");
				echo("</td>\n");
				echo("</tr></table>\n");
				unset($info);

				echo("<br><br>\n");
			}
		}
		echo _theme_footer();
	}
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
