<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

session_start();
if (is_opendb_valid_session())
{
	$show_error=TRUE;	
	if($HTTP_VARS['op'] == "search" && strlen($HTTP_VARS['words'])>0)
   	{
	    echo "<p>".replace_lang_var("search", $HTTP_VARS['words'], $LANG_VARS['you_searched_for'])."</p>";
			
		// Allow configuration of how many entries will be displayed.
		if(!is_numeric($max_titles_list))
			$max_titles_list = 50;
		
		$entries = get_freedb_list_of_titles($HTTP_VARS['words'], $max_titles_list, $HTTP_VARS['offset']);
		if(is_not_empty_array($entries))
		{
			echo get_freedb_entry_chooser($entries, $HTTP_VARS['offset'], $HTTP_VARS);
			$show_error=FALSE;

			$url = get_url_string($HTTP_VARS, NULL, array('offset'));

			echo("<div class=\"footer\" align=\"center\">");
			// Include a back link - only where we have a current offset at least as large as the
			// $max_titles_list to indicate we can go back.
			if(is_numeric($HTTP_VARS['offset']) && $HTTP_VARS['offset']>=$max_titles_list)
			{
				echo(_theme_image("left.gif", "<=", NULL, "absmiddle")." <a href=\"site.php?$url&offset=".($HTTP_VARS['offset']-$max_titles_list)."\" class=\"footer\">".$LANG_VARS['previous_page']."</a>");
				$previous_page_visible=TRUE;
			}

			// Only if it seems like there might be more entries.
			if(count($entries) >= $max_titles_list)
			{
				if($previous_page_visible)
					echo("&nbsp;/&nbsp;");
				echo("<a href=\"site.php?$url&offset=".($HTTP_VARS['offset']+$max_titles_list)."\" class=\"footer\">".$LANG_VARS['next_page']." "._theme_image("right.gif", "=>", NULL, "absmiddle")."</a>");
			}
			echo("</div>");
		}
		//else - No title found
		// But $show_error=TRUE; so error will be displayed for us by site.php
	}
	else if ($HTTP_VARS['op'] == "choose" && isset($HTTP_VARS['id']) && isset($HTTP_VARS['category']))
	{
		$entry = get_freedb_entry_details($HTTP_VARS['category'], $HTTP_VARS['id']);
		if($entry)
		{			
			// Add artist,title,cddbgenre,title_attribute to $entry array.
			$entry['cddbgenre'] = $HTTP_VARS['category'];
			$entry['artist'] = $HTTP_VARS['artist'];
			$entry['freedb_id'] = $HTTP_VARS['id'];

			if(strlen($HTTP_VARS['title']) > strlen($entry['title']))
				$entry['title'] = $HTTP_VARS['title'];

			//Add the title_attribute (ALT_TITLE) here!
			if(strlen($title_attribute)>0)
				$entry[$title_attribute] = $entry['title'];

			// Ensure that we have a valid genre defined.
			if(strlen($entry['genre'])==0)
				$entry['genre'] = $HTTP_VARS['category'];

			// In the case of freedb, there are no plots so this function will automatically
			// load the item_add.php script.
			echo get_site_blurb_chooser(
						"freedb", 
						$entry,
						'plot', // plot or review
						$HTTP_VARS, 
						array('id','artist','title','category'));
			
			// No search link.
			$show_new_search_link=FALSE;
			$show_error=FALSE;
		}
    }
		
	if($show_error)
	{
		echo ("<h3>".$LANG_VARS['no_matches_found']."</h3>");
	}
}
?>
