<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/function.php");
include_once("./functions/item_type.php");
include_once("./functions/item.php");
include_once("./functions/item_attribute.php");
include_once("./functions/user.php");
include_once("./functions/widgets.php");
include_once("./functions/utils.php");
include_once("./functions/export.php");

$item_level = 0;

/*
* This function exports a single Item, and will
* be recursively called for child items.  Child
* items do not have children.
*/
function export_type_item($item_id, $instance_no, $s_item_type, $title, $category, $owner_id, $linked_items=NULL, $isChild=FALSE)
{
	global $item_level;
	
	$buffer = "";
	
	$buffer .= start_item($item_level++, $item_id, $s_item_type, $title, $category);
	if($isChild!==TRUE)
	{
		if(is_numeric($instance_no))
		{
			$item_instance_r = fetch_item_instance_r($item_id, $instance_no);
			if(is_not_empty_array($item_instance_r))
				$buffer .= item_instance($item_level, $item_instance_r['item_id'], $item_instance_r['instance_no'], $item_instance_r['owner_id'], $item_instance_r['borrow_duration'], $item_instance_r['s_status_type'], $item_instance_r['status_comment']);
		}
		else
		{
			$iiresults = fetch_item_instance_rs($item_id, $owner_id);
			if($iiresults)
			{
				while($item_instance_r = mysql_fetch_array($iiresults))
				{
					$buffer .= item_instance($item_level, $item_instance_r['item_id'], $item_instance_r['instance_no'], $item_instance_r['owner_id'], $item_instance_r['borrow_duration'], $item_instance_r['s_status_type'], $item_instance_r['status_comment']);
				}
				mysql_free_result($iiresults);
			}
		}
		
		if($linked_items != 'exclude')
		{
			$childresults = fetch_child_item_rs($item_id);
			if($childresults)
			{
				while($child_item_r = mysql_fetch_array($childresults))
				{
					// recursive call.
					$buffer .= export_type_item($child_item_r['item_id'], NULL, $child_item_r['s_item_type'], $child_item_r['title'], $child_item_r['category'], NULL, NULL, TRUE);
				}
			
				mysql_free_result($childresults);
			}
		}
	}
		
	//export attributes.
	$attresults = fetch_item_attribute_type_with_val_rs($s_item_type, $item_id, FALSE, TRUE);
	if($attresults)
	{
		while($item_attribute_r = mysql_fetch_array($attresults))
		{
			// Only attribute specific s_field_type's should be exported as XML.
			if(strlen($item_attribute_type_r['s_field_type'])==0 || $item_attribute_type_r['s_field_type'] == 'IMAGE')
				$buffer .= item_attribute($item_level, $item_id, $item_attribute_r['s_attribute_type'], $item_attribute_r['order_no'], $item_attribute_r['attribute_val']);
		}
		mysql_free_result($attresults);
	}
	
	$buffer .= end_item(--$item_level, $item_id);
	return $buffer;
}

function get_data_header($s_item_type)
{
	$headings[] = 'item_id';
	$headings[] = 'instance_no';
	$headings[] = 'owner_id';
	$headings[] = 'parent_id';
	$headings[] = 's_item_type';
		
	// Get the item_attribute headings.
	$results = fetch_item_attribute_type_rs($s_item_type, TRUE, TRUE);
	if($results)
	{
		while($item_attribute_type_r = mysql_fetch_array($results))
		{
			// Only legal s_field_type's - ignore ITEM_ID!!!
			if(strlen($item_attribute_type_r['s_field_type'])==0 || 
						$item_attribute_type_r['s_field_type'] == 'TITLE' || 
						$item_attribute_type_r['s_field_type'] == 'DURATION' ||
						$item_attribute_type_r['s_field_type'] == 'STATUSTYPE' ||
						$item_attribute_type_r['s_field_type'] == 'STATUSCMNT' ||
						$item_attribute_type_r['s_field_type'] == 'CATEGORY' || 
						$item_attribute_type_r['s_field_type'] == 'IMAGE')
			{						
				$headings[] = strtolower($item_attribute_type_r['s_attribute_type']."_".$item_attribute_type_r['order_no']);
			}
		}
		mysql_free_result($results);
	}
	
	return $headings;
}

function get_prompt_header($s_item_type)
{
	global $LANG_VARS;

	$headings[] = $LANG_VARS['item_id'];
	$headings[] = $LANG_VARS['instance_no'];
	$headings[] = $LANG_VARS['owner_id'];
	$headings[] = $LANG_VARS['parent_id'];
	$headings[] = $LANG_VARS[ 's_item_type'];
		
	// Get the item_attribute headings.
	$results = fetch_item_attribute_type_rs($s_item_type, TRUE, TRUE);
	if($results)
	{
		while($item_attribute_type_r = mysql_fetch_array($results))
		{
			// Only legal s_field_type's - ignore ITEM_ID!!!
			if(strlen($item_attribute_type_r['s_field_type'])==0 || 
						$item_attribute_type_r['s_field_type'] == 'TITLE' || 
						$item_attribute_type_r['s_field_type'] == 'DURATION' ||
						$item_attribute_type_r['s_field_type'] == 'STATUSTYPE' ||
						$item_attribute_type_r['s_field_type'] == 'STATUSCMNT' ||
						$item_attribute_type_r['s_field_type'] == 'CATEGORY' || 
						$item_attribute_type_r['s_field_type'] == 'IMAGE')
			{
				$headings[] = $item_attribute_type_r['prompt'];
			}
		}
		mysql_free_result($results);
	}
	
	return $headings;
}

function get_row_array($item_id, $instance_no, $owner_id, $parent_id, $s_item_type, $title, $category, $borrow_duration, $s_status_type, $status_comment)
{
	$row[] = $item_id;
	$row[] = $instance_no;
	$row[] = $owner_id;
	$row[] = $parent_id;
	$row[] = $s_item_type;
			
	$results = fetch_item_attribute_type_with_val_rs($s_item_type, $item_id, TRUE, TRUE);
	if($results)
	{
		while($item_attribute_type_r = mysql_fetch_array($results))
		{
			if($item_attribute_type_r['s_field_type'] == 'TITLE')
				$row[] = $title;
			else if($item_attribute_type_r['s_field_type'] == 'DURATION')
				$row[] = $borrow_duration;
			else if($item_attribute_type_r['s_field_type'] == 'STATUSTYPE')
				$row[] = $s_status_type;
			else if($item_attribute_type_r['s_field_type'] == 'STATUSCMNT')
				$row[] = $status_comment;
			else if($item_attribute_type_r['s_field_type'] == 'CATEGORY')
				$row[] = $category;
			else if($item_attribute_type_r['s_field_type'] != 'ITEM_ID')
				$row[] = $item_attribute_type_r['attribute_val'];
		}
		mysql_free_result($results);
	}
	return $row;
}

function export_linked_row_items($item_id)
{
	$buffer = "";
	
	$childresults = fetch_child_item_rs($item_id);
	if($childresults)
	{
		while($child_item_r = mysql_fetch_array($childresults))
		{
			echo item_row(
				get_row_array($child_item_r['item_id'], NULL, NULL, $item_id, $child_item_r['s_item_type'], $child_item_r['title'], $child_item_r['category'], NULL, NULL, NULL));
		}
		mysql_free_result($childresults);
	}
	
	return $buffer;
}

/*
* Output content, in correct 'send_as_format'.  if the
* Send_as_format is not 'file' we assume it should be
* streamed directly to the browser.
*/
function echo_output($send_as_format, $buffer)
{
	if($send_as_format == 'file')
		return $buffer;
	else
		return str_replace("\t", str_repeat("&nbsp;",8), htmlspecialchars($buffer));
}

function echo_output_header($title, $send_as_format)
{
	if($send_as_format == 'file')
	{
		// hard code for now
		$filename_prefix = 'export';
	
		if(function_exists('file_extension'))
			$filename = "$filename_prefix.".file_extension();
		else
			$filename = "$filename_prefix.txt";
									
		if(function_exists('file_content_type'))
			$content_type = file_content_type();
		else
			$content_type = 'application/octetstream';

		header("Cache-control: no-store");
		header("Pragma: no-store");
		header("Expires: 0");
		header("Content-disposition: attachment; filename=$filename");
		header("Content-type: $content_type");
		
		if(function_exists('file_header'))
			echo file_header($title);
	}
	else
	{
		echo _theme_header($title);
		echo("<h2>".$title."</h2>");
									
		echo("<pre>");
	}			
}

function echo_output_footer($send_as_format)
{
	if($send_as_format == 'file')
	{
		if(function_exists('file_footer'))
			echo file_footer();
	}
	else
	{
		echo("</pre>");
		echo _theme_footer();
	}
}

/*
* Export Type 
* 
* @param linked_items - 'include' or 'exclude'
*/
function export_type_items($title, $send_as_format, $s_item_type, $item_id, $instance_no, $owner_id, $linked_items)
{
	global $item_level;

	$itemresults = fetch_export_item_rs($s_item_type, $item_id, $owner_id);
	if($itemresults)
	{
		echo_output_header($title, $send_as_format);
		while($item_r = mysql_fetch_array($itemresults))
		{
			$item_level = 0;
			echo echo_output(
					$send_as_format, 
					export_type_item($item_r['item_id'],
								$instance_no,
								$item_r['s_item_type'],
								$item_r['title'],
								$item_r['category'],
								$owner_id,
								$linked_items));
		}
		mysql_free_result($itemresults);
		
		echo_output_footer($send_as_format);
		return TRUE;
	}
	else
		return FALSE;
}

function export_row_items($title, $send_as_format, $s_item_type, $owner_id, $linked_items)
{
	$iiresults = fetch_export_item_instance_rs($s_item_type, $owner_id);
	if($iiresults)
	{
		echo_output_header($title, $send_as_format);
		if(function_exists('prompt_header'))
			echo echo_output($send_as_format, prompt_header(get_prompt_header($s_item_type)));
		else if(function_exists('data_header'))
			echo echo_output($send_as_format, data_header(get_data_header($s_item_type)));
		
		$item_instance_r2 = NULL;
		while($item_instance_r = mysql_fetch_array($iiresults))
		{
			// If we have changed item_id's then we need to do the child items, before continuing.
			if($linked_items !== 'exclude' && $item_instance_r2!=NULL && $item_instance_r2['item_id'] != $item_instance_r['item_id'])
				echo echo_output($send_as_format, export_linked_row_items($item_instance_r2['item_id']));
					
			echo echo_output(
						$send_as_format, 
						item_row(get_row_array($item_instance_r['item_id'], $item_instance_r['instance_no'], $item_instance_r['owner_id'], NULL, $item_instance_r['s_item_type'], $item_instance_r['title'], $item_instance_r['category'], $item_instance_r['borrow_duration'], $item_instance_r['s_status_type'], $item_instance_r['status_comment'])));
						
			$item_instance_r2 = $item_instance_r;
		}
		
		// If we have changed item_id's then we need to do the child items, before continuing.
		if($linked_items !== 'exclude' && $item_instance_r!=NULL)
			echo echo_output($send_as_format, export_linked_row_items($item_instance_r2['item_id']));
		
		mysql_free_result($iiresults);
		
		// If get_buffer exists, then the plugin is keeping an internal buffer, and the
		// data_header / prompt_header / item_row functions are all returning NULL.
		if(function_exists('get_export_buffer'))
			echo echo_output($send_as_format, get_export_buffer());
		
		if(function_exists('close_export'))
			echo echo_output($send_as_format, close_export());

		echo_output_footer($send_as_format);
		return TRUE;
	}
	else
		return FALSE;
}

session_start();
if(is_opendb_valid_session())
{
	if ( is_user_allowed_to_own($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) )
	{
		if($HTTP_VARS['op'] == 'export')
		{
			if(is_legal_export_type($HTTP_VARS['type']))
			{
				// Either owner_id not specified, in which case we would export for current user, or owner_id is specified
				// and is the same as current user or user is admin, where no item_id specified.
				if(is_numeric($HTTP_VARS['item_id']) ||
						(!is_numeric($HTTP_VARS['item_id']) && (strlen($HTTP_VARS['owner_id'])==0 || $HTTP_VARS['owner_id']==$HTTP_SESSION_VARS['user_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))))
				{
					if((strlen($HTTP_VARS['s_item_type'])==0 && is_numeric($HTTP_VARS['item_id'])) || is_valid_item_type_structure($HTTP_VARS['s_item_type']))
					{
						@set_time_limit(600);
						
						// Now include the plugin code.
						include("./export/".$HTTP_VARS['type'].".php");
						
						// If the 'item_row' function is defined, then we assume that we are
						// working with a row orientated plugin.  Otherwise 
						if(function_exists('item_row'))
						{
							// Work out page title.
							if(strlen($HTTP_VARS['owner_id'])>0)
								$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id'], 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_name_item_type']);
							else
								$page_title = replace_lang_var("type", get_display_export_type($HTTP_VARS['type']), $LANG_VARS['type_export']);
							
							if(!export_row_items($page_title, $HTTP_VARS['send_as_format'], $HTTP_VARS['s_item_type'], $HTTP_VARS['owner_id'], $HTTP_VARS['linked_items']))
							{
								echo _theme_header($page_title);
								echo("<h2>".$page_title."</h2>");
								echo format_error_block(array('error'=>$LANG_VARS['no_records_found'],'detail'=>''));
								echo _theme_footer();
							}
						}
						else // XML 'type' export.
						{
							// Work out page title.
							if(strlen($HTTP_VARS['owner_id'])>0 || is_numeric($HTTP_VARS['item_id']))
							{
								if(strlen($HTTP_VARS['owner_id'])>0 && strlen($HTTP_VARS['s_item_type'])>0)
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'fullname'=>fetch_user_name($HTTP_VARS['owner_id']),'user_id'=>$HTTP_VARS['owner_id'], 's_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_name_item_type']);
								else if(strlen($HTTP_VARS['s_item_type'])>0)
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'s_item_type'=>$HTTP_VARS['s_item_type']), $LANG_VARS['type_export_for_item_type']);
								else if(is_numeric($HTTP_VARS['item_id']) && is_numeric($HTTP_VARS['instance_no']))
								{
									$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'item_id'=>$HTTP_VARS['item_id'],'instance_no'=>$HTTP_VARS['instance_no'],'title'=>expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['type_export_for_item_instance']);
								}
								else if(is_numeric($HTTP_VARS['item_id']))
								{
									// Not really a child item, but we are not interested in the instance, so use this.  It still
									// returns the right data anyway.
									$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'item_id'=>$HTTP_VARS['item_id'],'title'=>expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], NULL, NULL, $CONFIG_VARS['item_display.title_display_mask'])), $LANG_VARS['type_export_for_item']);
								}
								else //if(strlen($HTTP_VARS['owner_id'])>0)
									$page_title = replace_lang_vars(array('type'=>get_display_export_type($HTTP_VARS['type']),'fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['type_export_for_name']);
							}
							else
								$page_title = replace_lang_var("type", get_display_export_type($HTTP_VARS['type']), $LANG_VARS['type_export']);
								
							if(!export_type_items($page_title, $HTTP_VARS['send_as_format'], $HTTP_VARS['s_item_type'], $HTTP_VARS['item_id'], $HTTP_VARS['instance_no'], $HTTP_VARS['owner_id'], $HTTP_VARS['linked_items']))
							{
								echo _theme_header($page_title);
								echo("<h2>".$page_title."</h2>");
								echo format_error_block(array('error'=>$LANG_VARS['no_records_found'],'detail'=>''));
								echo _theme_footer();
							}
						}
					}
					else//if(is_valid_item_type_structure($HTTP_VARS['s_item_type']))
					{
						$page_title = replace_lang_var("type", get_display_export_type($HTTP_VARS['type']), $LANG_VARS['type_export']);
						echo _theme_header($page_title);
						echo("<h2>".$page_title."</h2>");
						echo format_error_block(array('error'=>replace_lang_var("s_item_type", $HTTP_VARS['s_item_type'], $LANG_VARS['invalid_item_type_structure']),'detail'=>''));
						echo _theme_footer();
					}
				}
				else //no access available for specified item, or illegal owner specified.
				{
					$page_title = replace_lang_var("type", get_display_export_type($HTTP_VARS['type']), $LANG_VARS['type_export']);
					echo _theme_header($page_title);
					echo("<h2>".$page_title."</h2>");
					echo format_error_block(array('error'=>$LANG_VARS['operation_not_available'],'detail'=>''));
					echo _theme_footer();
				}
			}
			else //if(is_legal_export_type($HTTP_VARS['type']))
			{
				$page_title = replace_lang_var("type", get_display_export_type($HTTP_VARS['type']), $LANG_VARS['type_export']);
				echo _theme_header($page_title);
				echo("<h2>".$page_title."</h2>");
				echo format_error_block(array('error'=>replace_lang_var("type", $HTTP_VARS['type'], $LANG_VARS['illegal_export_type']),'detail'=>''));
				echo _theme_footer();
			}
		}
		else
		{
			// A custom title.
			if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && strlen($HTTP_VARS['owner_id'])==0)
				$page_title = $LANG_VARS['export_items'];
			else if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] || strlen($HTTP_VARS['owner_id'])==0)
				$page_title = $LANG_VARS['export_my_items'];
				
			echo _theme_header($page_title);
			echo("<h2>".$page_title."</h2>");
			
			echo("<form name=\"search\" method=\"get\" action=\"$PHP_SELF\">");
			echo("<table border=0 frameborder=0 cellspacing=1>");
			echo("\n<input type=hidden name=op value=\"export\">");
			
			// Item Type select block.
			echo format_field(
					$LANG_VARS['item_type'], 
					NULL,
					single_select("s_item_type", 
						fetch_item_type_rs(TRUE), 
						"%value% - %display%", 
						NULL, 
						$HTTP_VARS['s_item_type']
					)
				);
			
			if($CONFIG_VARS['item_input.linked_item_support']!==FALSE)
			{
				echo format_field(
					$LANG_VARS['linked_item(s)'],
					NULL,
						"\n<input type=radio name=\"linked_items\" value=\"include\" CHECKED>".$LANG_VARS['include']."&nbsp;&nbsp;".
 							"<input type=radio name=\"linked_items\" value=\"exclude\">".$LANG_VARS['exclude']);
			}
						
			// Do not show OwnerID field, if not an admin user.
			if($HTTP_VARS['owner_id'] != $HTTP_SESSION_VARS['user_id'] && is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
			{
				// Item Type field.
				echo format_field(
						$LANG_VARS['owner'], 
						NULL,
						"\n<select name=\"owner_id\">".
							"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
							custom_select(
								'owner_id', 
								fetch_user_rs(get_owner_user_types_r()), 
								'%fullname% (%user_id%)',
								'NA',
								NULL,
								'user_id'
							).
							"\n</select>"
						);
			}
			else
			{
				echo("<input type=\"hidden\" name=\"owner_id\" value=\"".$HTTP_VARS['owner_id']."\">");
			}
			
			$field = "\n<select name=\"type\">\n";
			$export_type_rs = get_export_r();
			if(is_array($export_type_rs))
			{
				while(list(,$value) = @each($export_type_rs))
				{
					$field .= "<option value=\"$value\">".get_display_export_type($value)."\n";
				}
			}
			$field .= "</select>";
			
			echo format_field(
				$LANG_VARS['type'], 
				NULL, 
				$field
			);
			
			echo format_field(
				$LANG_VARS['send_as_file'],
				NULL,
				"<input type=\"checkbox\" name=\"send_as_format\" value=\"file\" CHECKED>");
			
			echo("<tr><td align=center colspan=2>");
			echo("<br><input type=submit value=\"".$page_title."\">");
			echo("</td></tr>");
	
			echo("</table>");
			echo("</form>");
			echo _theme_footer();
		}
	}
	else//no guests or borrowers allowed!
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
		echo _theme_footer();
	}	
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
