// DisplayAnimationDocApp.cpp : implementation of the CDisplayAnimationDoc class
//

#include "stdafx.h"

#include "DisplayAnimationApp.h"
#include "DisplayAnimationDoc.h"
#include "DisplayAnimationView3D.h"
#include "AISDialogs.h"
#include "ShadingDialog.h"
#include "ThreadDialog.h"

#ifdef _DEBUG
//#define new DEBUG_NEW  // by cascade
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDisplayAnimationDoc

IMPLEMENT_DYNCREATE(CDisplayAnimationDoc, CDocument)

BEGIN_MESSAGE_MAP(CDisplayAnimationDoc, CDocument)
	//{{AFX_MSG_MAP(CDisplayAnimationDoc)
	ON_COMMAND(ID_SHADING, OnShading)
	ON_COMMAND(ID_Thread, OnThread)
	//}}AFX_MSG_MAP

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisplayAnimationDoc construction/destruction

CDisplayAnimationDoc::CDisplayAnimationDoc()
{
	// TODO: add one-time construction code here

	static Standard_Integer StaticCount=0;
	StaticCount++;
	myCount = StaticCount;

	Handle(Graphic3d_WNTGraphicDevice) theGraphicDevice = 
		((CDisplayAnimationApp*)AfxGetApp())->GetGraphicDevice();

    TCollection_ExtendedString a3DName("Visu3D");
	myViewer = new V3d_Viewer(theGraphicDevice,a3DName.ToExtString(),"", 1000.0, 
                              V3d_XposYnegZpos, Quantity_NOC_GRAY30,
                              V3d_ZBUFFER,V3d_GOURAUD,V3d_WAIT, 
                              Standard_True, Standard_False);

	myViewer->SetDefaultLights();
	myViewer->SetLightOn();

	myAISContext =new AIS_InteractiveContext(myViewer);

	myDeviation = 0.0008;
	thread = 4;
	myAngle = 0;

	BRep_Builder B;
	TopoDS_Shape CrankArm;
	TopoDS_Shape CylinderHead;
	TopoDS_Shape Propeller;
	TopoDS_Shape Piston;
	TopoDS_Shape EngineBlock;
	
	char AbloluteExecutableFileName[200];
	HMODULE hModule = GetModuleHandle(NULL);
	GetModuleFileName (hModule, AbloluteExecutableFileName, 200);

	CString aString(AbloluteExecutableFileName);
	int index = aString.ReverseFind('\\');

	aString.Delete(index+1, aString.GetLength() - index - 1);

	TCHAR tchBuf[80];

	CString CASROOTValue = ((GetEnvironmentVariable("CASROOT", tchBuf, 80) > 0) ? tchBuf : NULL); 
	aString = (CASROOTValue + "\\..\\data\\occ");	

	char DataDirPath[200];
	strcpy(DataDirPath, aString);
	char temp[200];
	strcpy(temp, DataDirPath);

	BRepTools::Read(CrankArm, strcat(temp,"\\CrankArm.rle"),B);
	strcpy(temp, DataDirPath);
	BRepTools::Read(CylinderHead, strcat(temp,"\\CylinderHead.rle"),B);
	strcpy(temp, DataDirPath);
	BRepTools::Read(Propeller,strcat(temp,"\\Propeller.rle"),B);
	strcpy(temp, DataDirPath);
	BRepTools::Read(Piston,strcat(temp,"\\Piston.rle"),B);
	strcpy(temp, DataDirPath);
	BRepTools::Read(EngineBlock,strcat(temp,"\\EngineBlock.rle"),B);
	strcpy(temp, DataDirPath);
	/*
	if (CrankArm.IsNull() || CylinderHead.IsNull() || Propeller.IsNull() ||
		Piston.IsNull() || EngineBlock.IsNull()){
		BRepTools::Read(CrankArm,"..\\Data\\CrankArm.rle",B);
		BRepTools::Read(CylinderHead,"..\\Data\\CylinderHead.rle",B);
		BRepTools::Read(Propeller,"..\\Data\\Propeller.rle",B);
		BRepTools::Read(Piston,"..\\Data\\Piston.rle",B);
		BRepTools::Read(EngineBlock,"..\\Data\\EngineBlock.rle",B);
	}
	if (CrankArm.IsNull() || CylinderHead.IsNull() || Propeller.IsNull() ||
		Piston.IsNull() || EngineBlock.IsNull()){
		BRepTools::Read(CrankArm,"..\\13_DisplayAnimation\\Data\\CrankArm.rle",B);
		BRepTools::Read(CylinderHead,"..\\13_DisplayAnimation\\Data\\CylinderHead.rle",B);
		BRepTools::Read(Propeller,"..\\13_DisplayAnimation\\Data\\Propeller.rle",B);
		BRepTools::Read(Piston,"..\\13_DisplayAnimation\\Data\\Piston.rle",B);
		BRepTools::Read(EngineBlock,"..\\13_DisplayAnimation\\Data\\EngineBlock.rle",B);
	}
	*/
	if (CrankArm.IsNull() || CylinderHead.IsNull() || Propeller.IsNull() ||
		Piston.IsNull() || EngineBlock.IsNull())
	{
		int rep = MessageBox(NULL, "Shape(s) not found.\nCheck the Data directory path!", "Error",MB_OK | MB_ICONERROR);
		if (rep == IDOK)
			exit(0);
	}
	myAISContext->SetDeviationCoefficient(myDeviation);

	myAisCylinderHead = new AIS_Shape (CylinderHead);
	myAISContext->SetColor    (myAisCylinderHead, Quantity_NOC_WHITE);
	myAISContext->SetMaterial (myAisCylinderHead, Graphic3d_NOM_PLASTIC);
	myAisEngineBlock  = new AIS_Shape (EngineBlock);
	myAISContext->SetColor(myAisEngineBlock,   Quantity_NOC_WHITE);
	myAISContext->SetMaterial(myAisEngineBlock,Graphic3d_NOM_PLASTIC);

	myAISContext->Display(myAisCylinderHead ,1,-1,Standard_False,Standard_False);
	myAISContext->Display(myAisEngineBlock  ,1,-1,Standard_False,Standard_False);

	myAisCrankArm     = new AIS_Shape (CrankArm);
	myAISContext->SetColor   (myAisCrankArm, Quantity_NOC_HOTPINK);
	myAISContext->SetMaterial(myAisCrankArm, Graphic3d_NOM_PLASTIC);
	myAisPiston       = new AIS_Shape (Piston);
	myAISContext->SetColor   (myAisPiston  , Quantity_NOC_WHITE);
	myAISContext->SetMaterial(myAisPiston  , Graphic3d_NOM_PLASTIC);
	myAisPropeller    = new AIS_Shape (Propeller);
	myAISContext->SetColor   (myAisPropeller, Quantity_NOC_RED);
	myAISContext->SetMaterial(myAisPropeller, Graphic3d_NOM_PLASTIC);

	myAISContext->Display(myAisCrankArm     ,1,-1,Standard_False,Standard_False);
	myAISContext->Display(myAisPropeller    ,1,-1,Standard_False,Standard_False);
	myAISContext->Display(myAisPiston       ,1,-1,Standard_True,Standard_False);
}

CDisplayAnimationDoc::~CDisplayAnimationDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CDisplayAnimationDoc diagnostics

#ifdef _DEBUG
void CDisplayAnimationDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDisplayAnimationDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDisplayAnimationDoc commands
//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::DragEvent(const Standard_Integer  x        ,
				                  const Standard_Integer  y        ,
				                  const Standard_Integer  TheState ,
                                  const Handle(V3d_View)& aView    )
{

    // TheState == -1  button down
	// TheState ==  0  move
	// TheState ==  1  button up

    static Standard_Integer theButtonDownX=0;
    static Standard_Integer theButtonDownY=0;

	if (TheState == -1)
    {
      theButtonDownX=x;
      theButtonDownY=y;
    }

	if (TheState == 0)
	  myAISContext->Select(theButtonDownX,theButtonDownY,x,y,aView);  
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::InputEvent(const Standard_Integer  x     ,
				                   const Standard_Integer  y     ,
                                   const Handle(V3d_View)& aView ) 
{
    myAISContext->Select(); 
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::MoveEvent(const Standard_Integer  x       ,
                                  const Standard_Integer  y       ,
                                  const Handle(V3d_View)& aView   ) 
{
      myAISContext->MoveTo(x,y,aView);
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::ShiftMoveEvent(const Standard_Integer  x       ,
                                  const Standard_Integer  y       ,
                                  const Handle(V3d_View)& aView   ) 
{
      myAISContext->MoveTo(x,y,aView);
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::ShiftDragEvent(const Standard_Integer  x        ,
									   const Standard_Integer  y        ,
									   const Standard_Integer  TheState ,
                                       const Handle(V3d_View)& aView    ) 
{
    static Standard_Integer theButtonDownX=0;
    static Standard_Integer theButtonDownY=0;

	if (TheState == -1)
    {
      theButtonDownX=x;
      theButtonDownY=y;
    }

	if (TheState == 0)
	  myAISContext->ShiftSelect(theButtonDownX,theButtonDownY,x,y,aView);  
}


//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CDisplayAnimationDoc::ShiftInputEvent(const Standard_Integer  x       ,
									    const Standard_Integer  y       ,
                                        const Handle(V3d_View)& aView   ) 
{
	myAISContext->ShiftSelect(); 
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void  CDisplayAnimationDoc::Popup(const Standard_Integer  x,
							   const Standard_Integer  y ,
                               const Handle(V3d_View)& aView   ) 
{
}

void CDisplayAnimationDoc::OnMyTimer() 
{
	// TODO: Add your message handler code here and/or call default
	
	Standard_Real angleA;
	Standard_Real angleB;
	Standard_Real X;
	gp_Ax1 Ax1(gp_Pnt(0,0,0),gp_Vec(0,0,1));

	myAngle++;

	angleA = thread*myAngle*PI/180;
	X = Sin(angleA)*3/8;
	angleB = atan(X / Sqrt(-X * X + 1));
	Standard_Real decal(25*0.6);

	
	//Build a transformation on the display
    gp_Trsf aPropellerTrsf;
    aPropellerTrsf.SetRotation(Ax1,angleA);
	myAISContext->SetLocation(myAisPropeller,aPropellerTrsf);
	
	gp_Ax3 base(gp_Pnt(3*decal*(1-Cos(angleA)),-3*decal*Sin(angleA),0),gp_Vec(0,0,1),gp_Vec(1,0,0));
    gp_Trsf aCrankArmTrsf;
    aCrankArmTrsf.SetTransformation(   base.Rotated(gp_Ax1(gp_Pnt(3*decal,0,0),gp_Dir(0,0,1)),angleB));
	myAISContext->SetLocation(myAisCrankArm,aCrankArmTrsf);

    gp_Trsf aPistonTrsf;
    aPistonTrsf.SetTranslation(gp_Vec(-3*decal*(1-Cos(angleA))-8*decal*(1-Cos(angleB)),0,0));
	myAISContext->SetLocation(myAisPiston,aPistonTrsf);

    myAISContext->UpdateCurrentViewer();
}

void CDisplayAnimationDoc::OnShading() 
{
	
	POSITION position = GetFirstViewPosition();
	CView* pCurrentView = (CView*)GetNextView(position);
	((CDisplayAnimationView3D *)pCurrentView)		->OnStop();

	CShadingDialog aDial(NULL);

	aDial.myvalue=int((myDeviation-0.00003)/0.00003);
	
	if (aDial.DoModal()==IDOK) {
		Standard_Real dev(aDial.myvalue);
		myDeviation = 0.00003+0.00003*dev;

		myAISContext->SetDeviationCoefficient(myDeviation);
        TopoDS_Shape Propeller=myAisPropeller->Shape();
		BRepTools::Clean(Propeller);
		
        myAisPropeller->Set(Propeller);
        myAISContext->Deactivate(myAisPropeller);
        myAISContext->Redisplay(myAisPropeller);
	}
	((CDisplayAnimationView3D *)pCurrentView)->OnRestart();
}


void CDisplayAnimationDoc::OnThread() 
{
	POSITION position = GetFirstViewPosition();
    CView* pCurrentView = (CView*)GetNextView(position);
	((CDisplayAnimationView3D *)pCurrentView)		->OnStop();
	CThreadDialog aThreadDial(NULL);
	if (aThreadDial.DoModal()==IDOK) {
		thread = aThreadDial.m_Angle;
	}

	((CDisplayAnimationView3D *)pCurrentView)->OnRestart();
}



