// SerializeDoc.cpp : implementation of the CSerializeDoc class
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "stdafx.h"

#include "SerializeDoc.h"

#include "SerializeApp.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CSerializeDoc

IMPLEMENT_DYNCREATE(CSerializeDoc, CDocument)

BEGIN_MESSAGE_MAP(CSerializeDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CSerializeDoc)
	ON_COMMAND(ID_BOX, OnBox)
	ON_COMMAND(ID_Cylinder, OnCylinder)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSerializeDoc construction/destruction

CSerializeDoc::CSerializeDoc()
{
    m_pcoloredshapeCurrent=NULL;
}

CSerializeDoc::~CSerializeDoc()
{
  if(m_pcoloredshapeCurrent) delete m_pcoloredshapeCurrent ;
}

/////////////////////////////////////////////////////////////////////////////
// CSerializeDoc serialization

void CSerializeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// Put the curent CColoredShape in the archive
		ar << m_pcoloredshapeCurrent;
	}
	else
	{
		// Read from the archive the current CColoredShape
		ar >> m_pcoloredshapeCurrent;

		// Display the new object
		m_pcoloredshapeCurrent->Display(myAISContext);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSerializeDoc diagnostics

#ifdef _DEBUG
void CSerializeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSerializeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CSerializeDoc::OnBox() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	BRepPrimAPI_MakeBox B(200.,150.,100.);

	if ( m_pcoloredshapeCurrent ) {
		delete m_pcoloredshapeCurrent;
	}

	m_pcoloredshapeCurrent = new CColoredShape(Quantity_NOC_YELLOW, B.Shape());

	m_pcoloredshapeCurrent->Display(myAISContext);
	Fit();

	// document has been modified
	SetModifiedFlag(TRUE);
}

void CSerializeDoc::OnCylinder() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	BRepPrimAPI_MakeCylinder C(50.,200.);

	if ( m_pcoloredshapeCurrent ) {
		delete m_pcoloredshapeCurrent;
	}

	m_pcoloredshapeCurrent = new CColoredShape(Quantity_NOC_GREEN, C.Shape());

	m_pcoloredshapeCurrent->Display(myAISContext);
	Fit();

	// document has been modified
	SetModifiedFlag(TRUE);
}

