// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gce_MakeRotation_HeaderFile
#define _gce_MakeRotation_HeaderFile

#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Lin;
class gp_Ax1;
class gp_Pnt;
class gp_Dir;
class gp_Trsf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements elementary construction algorithms for a <br>
//! rotation in 3D space. The result is a gp_Trsf transformation. <br>
//! A MakeRotation object provides a framework for: <br>
//! -   defining the construction of the transformation, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class gce_MakeRotation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a rotation through angle Angle about the axis defined by the line Line. <br>
Standard_EXPORT gce_MakeRotation(const gp_Lin& Line,const Standard_Real Angle);

//! Constructs a rotation through angle Angle about the axis defined by the axis Axis. <br>
Standard_EXPORT gce_MakeRotation(const gp_Ax1& Axis,const Standard_Real Angle);


//! Constructs a rotation through angle Angle about the axis defined by: <br>
//! the point Point and the unit vector Direc. <br>
Standard_EXPORT gce_MakeRotation(const gp_Pnt& Point,const gp_Dir& Direc,const Standard_Real Angle);

//! Returns the constructed transformation. <br>
Standard_EXPORT  const gp_Trsf& Value() const;


Standard_EXPORT  const gp_Trsf& Operator() const;
Standard_EXPORT operator gp_Trsf() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Trsf TheRotation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
