// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDocStd_XLinkIterator_HeaderFile
#define _TDocStd_XLinkIterator_HeaderFile

#ifndef _TDocStd_XLinkPtr_HeaderFile
#include <TDocStd_XLinkPtr.hxx>
#endif
#ifndef _Handle_TDocStd_Document_HeaderFile
#include <Handle_TDocStd_Document.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NoMoreObject;
class TDocStd_Document;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Iterates on Reference attributes. <br>
class TDocStd_XLinkIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns an empty iterator; <br>
Standard_EXPORT TDocStd_XLinkIterator();

//! Creates an iterator on Reference of <D>. <br>
Standard_EXPORT TDocStd_XLinkIterator(const Handle(TDocStd_Document)& D);

//! Restarts an iteration with <D>. <br>
Standard_EXPORT   void Initialize(const Handle(TDocStd_Document)& D) ;
//! Returns True if there is a current Item in the <br>
//!          iteration. <br>
//! <br>
  Standard_Boolean More() const;

//! Move to the next item; raises if there is no more item. <br>
Standard_EXPORT   void Next() ;
//! Returns the current item; a null handle if there is none. <br>
//! <br>
  TDocStd_XLinkPtr Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Init(const Handle(TDocStd_Document)& D) ;


 // Fields PRIVATE
 //
TDocStd_XLinkPtr myValue;


};


#include <TDocStd_XLinkIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
