// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TCollection_BaseSequence_HeaderFile
#define _TCollection_BaseSequence_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NoSuchObject;
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Definition of a base class for all instanciations <br>
//!          of sequence. <br>
//! <br>
//!          The methods : Clear, Remove accepts a pointer to a <br>
//!          function  to use  to delete the  nodes. This allow <br>
//!          proper    call of  the  destructor  on  the Items. <br>
//!          Without adding a  virtual function pointer to each <br>
//!          node or each sequence. <br>
class TCollection_BaseSequence  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! returns True if the sequence <me> contains no elements. <br>
  Standard_Boolean IsEmpty() const;
//! Returns  the  number  of element(s) in the <br>
//! sequence.  Returns zero if the sequence is empty. <br>
  Standard_Integer Length() const;

//! Reverses the order of items on <me>. <br>
//!  Example: <br>
//! before <br>
//!   me = (A B C) <br>
//! after <br>
//!   me = (C B A) <br>
Standard_EXPORT   void Reverse() ;

//! Swaps  elements  which    are  located  at <br>
//! positions <I> and <J> in <me>. <br>
//! Raises an exception if I or J is out of bound. <br>
//!  Example: <br>
//! before <br>
//!   me = (A B C), I = 1, J = 3 <br>
//! after <br>
//!   me = (C B A) <br>
Standard_EXPORT   void Exchange(const Standard_Integer I,const Standard_Integer J) ;





protected:

 // Methods PROTECTED
 // 

//! Creation of an empty sequence. <br>
Standard_EXPORT TCollection_BaseSequence();


Standard_EXPORT   void Clear(const Standard_Address DelNode) ;


Standard_EXPORT   void PAppend(const Standard_Address Node) ;

//! Concatenates <S> at the end of <me>. <br>
//! <S> is cleared. <br>
//!  Example: <br>
//! before <br>
//!   me = (A B C) <br>
//!   S  = (D E F) <br>
//! after <br>
//!   me = (A B C D E F) <br>
//!   S  = () <br>
Standard_EXPORT   void PAppend(TCollection_BaseSequence& S) ;


Standard_EXPORT   void PPrepend(const Standard_Address Node) ;

//! Concatenates <S> at the beginning of <me>. <br>
//! <S> is cleared. <br>
//!  Example: <br>
//! before <br>
//! me = (A B C) S =  (D E F) <br>
//! after me = (D E F A B C) <br>
//! S = () <br>
Standard_EXPORT   void PPrepend(TCollection_BaseSequence& S) ;


Standard_EXPORT   void PInsertAfter(const Standard_Integer Index,const Standard_Address Node) ;

//! Inserts the sequence <S> in <me> after the <br>
//! position <Index>. <S> is cleared. <br>
//! Raises an exception if the index is out of bound. <br>
//!  Example: <br>
//! before <br>
//!   me = (A B C), Index = 3, S = (D E F) <br>
//! after <br>
//!   me = (A B C D E F) <br>
//!   S  = () <br>
Standard_EXPORT   void PInsertAfter(const Standard_Integer Index,TCollection_BaseSequence& S) ;

//! Keeps in <me> the items 1 to <Index>-1 and <br>
//! puts  in  <Sub> the  items <Index>  to the end. <br>
//!  Example: <br>
//! before <br>
//!   me = (A B C D) ,Index = 3 <br>
//! after <br>
//!   me  = (A B) <br>
//!   Sub = (C D) <br>
Standard_EXPORT   void PSplit(const Standard_Integer Index,TCollection_BaseSequence& Sub) ;


Standard_EXPORT   void Remove(const Standard_Integer Index,const Standard_Address DelNode) ;


Standard_EXPORT   void Remove(const Standard_Integer FromIndex,const Standard_Integer ToIndex,const Standard_Address DelNode) ;

//! Returns the node at position <index>. <br>
Standard_EXPORT   Standard_Address Find(const Standard_Integer Index) const;


 // Fields PROTECTED
 //
Standard_Address FirstItem;
Standard_Address LastItem;
Standard_Address CurrentItem;
Standard_Integer CurrentIndex;
Standard_Integer Size;


private: 

 // Methods PRIVATE
 // 

//! Creation by copy of existing Sequence. <br>
//!  Warning: This constructor prints a warning message. <br>
//! We recommand to use the operator =. <br>
Standard_EXPORT TCollection_BaseSequence(const TCollection_BaseSequence& Other);

//! Clear all fields. <br>
//! <br>
Standard_EXPORT   void Nullify() ;


 // Fields PRIVATE
 //


};


#include <TCollection_BaseSequence.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
