// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeAnalysis_FreeBounds_HeaderFile
#define _ShapeAnalysis_FreeBounds_HeaderFile

#ifndef _TopoDS_Compound_HeaderFile
#include <TopoDS_Compound.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TopTools_HSequenceOfShape_HeaderFile
#include <Handle_TopTools_HSequenceOfShape.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Compound;
class TopTools_HSequenceOfShape;
class TopTools_DataMapOfShapeShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is intended to output free bounds of the shape <br>
//!          (free bounds are the wires consisting of edges referenced by the <br>
//!          only face). <br>
//!          This class works on two distinct types of shapes when analyzing <br>
//!          their free bounds: <br>
//!          1. compound of faces. <br>
//!            Analyzer of sewing algorithm (BRepAlgo_Sewing) is used for <br>
//!            for forecasting free bounds that would be obtained after <br>
//!            performing sewing <br>
//!          2. compound of shells. <br>
//!            Actual free bounds (edges shared by the only face in the shell) <br>
//!            are output in this case. ShapeAnalysis_Shell is used for that. <br>
class ShapeAnalysis_FreeBounds  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT ShapeAnalysis_FreeBounds();

//! Builds forecasting free bounds of the <shape>. <br>
//!          <shape> should be a compound of faces. <br>
//!          This constructor is to be used for forecasting free edges <br>
//!          with help of sewing analyzer BRepAlgo_Sewing which is called <br>
//!          with tolerance <toler>. <br>
//!          Free edges are connected into wires only when their ends are <br>
//!          at distance less than <toler>. <br>
//!          If <splitclosed> is True extracts closed sub-wires out of <br>
//!          built closed wires. <br>
//!          If <splitopen> is True extracts closed sub-wires out of <br>
//!          built open wires. <br>
Standard_EXPORT ShapeAnalysis_FreeBounds(const TopoDS_Shape& shape,const Standard_Real toler,const Standard_Boolean splitclosed = Standard_False,const Standard_Boolean splitopen = Standard_True);

//! Builds actual free bounds of the <shape>. <br>
//!          <shape> should be a compound of shells. <br>
//!          This constructor is to be used for getting free edges (ones <br>
//!          referenced by the only face) with help of analyzer <br>
//!          ShapeAnalysis_Shell. <br>
//!          Free edges are connected into wires only when they share the <br>
//!          same vertex. <br>
//!          If <splitclosed> is True extracts closed sub-wires out of <br>
//!          built closed wires. <br>
//!          If <splitopen> is True extracts closed sub-wires out of <br>
//!          built open wires. <br>
Standard_EXPORT ShapeAnalysis_FreeBounds(const TopoDS_Shape& shape,const Standard_Boolean splitclosed = Standard_False,const Standard_Boolean splitopen = Standard_True);
//! Returns compound of closed wires out of free edges. <br>
 const TopoDS_Compound& GetClosedWires() const;
//! Returns compound of open wires out of free edges. <br>
 const TopoDS_Compound& GetOpenWires() const;

//! Builds sequnce of <wires> out of sequence of not sorted <br>
//!          <edges>. <br>
//!          Tries to build wires of maximum length. Building a wire is <br>
//!          stopped when no edges can be connected to it at its head or <br>
//!          at its tail. <br>
Standard_EXPORT static  void ConnectEdgesToWires(Handle(TopTools_HSequenceOfShape)& edges,const Standard_Real toler,const Standard_Boolean shared,Handle(TopTools_HSequenceOfShape)& wires) ;


Standard_EXPORT static  void ConnectWiresToWires(Handle(TopTools_HSequenceOfShape)& iwires,const Standard_Real toler,const Standard_Boolean shared,Handle(TopTools_HSequenceOfShape)& owires) ;

//! Builds sequnce of <owires> out of sequence of not sorted <br>
//!          <iwires>. <br>
//!          Tries to build wires of maximum length. Building a wire is <br>
//!          stopped when no wires can be connected to it at its head or <br>
//!          at its tail. <br>
Standard_EXPORT static  void ConnectWiresToWires(Handle(TopTools_HSequenceOfShape)& iwires,const Standard_Real toler,const Standard_Boolean shared,Handle(TopTools_HSequenceOfShape)& owires,TopTools_DataMapOfShapeShape& vertices) ;

//! Extracts closed sub-wires out of <wires> and adds them <br>
//!          to <closed>, open wires remained after extraction are put <br>
//!          into <open>. <br>
//!          If <shared> is True extraction is performed only when <br>
//!          edges share the same vertex. <br>
//!          If <shared> is False connection is performed only when <br>
//!          ends of the edges are at distance less than <toler>. <br>
Standard_EXPORT static  void SplitWires(const Handle(TopTools_HSequenceOfShape)& wires,const Standard_Real toler,const Standard_Boolean shared,Handle(TopTools_HSequenceOfShape)& closed,Handle(TopTools_HSequenceOfShape)& open) ;

//! Dispatches sequence of <wires> into two compounds <br>
//!          <closed> for closed wires and <open> for open wires. <br>
//!          If a compound is not empty wires are added into it. <br>
Standard_EXPORT static  void DispatchWires(const Handle(TopTools_HSequenceOfShape)& wires,TopoDS_Compound& closed,TopoDS_Compound& open) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void SplitWires() ;


 // Fields PRIVATE
 //
TopoDS_Compound myWires;
TopoDS_Compound myEdges;
Standard_Real myTolerance;
Standard_Boolean myShared;
Standard_Boolean mySplitClosed;
Standard_Boolean mySplitOpen;


};


#include <ShapeAnalysis_FreeBounds.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
