// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepProj_Projection_HeaderFile
#define _BRepProj_Projection_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_ListIteratorOfListOfShape_HeaderFile
#include <TopTools_ListIteratorOfListOfShape.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_NoSuchObject;
class Standard_ConstructionError;
class Standard_NullObject;
class TopoDS_Shape;
class gp_Dir;
class gp_Pnt;
class BRepAlgo_BooleanOperations;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  Projection   class provides  conical  and <br>
//!          cylindrical projections of  Edge  or  Wire  on <br>
//!          a Shape from TopoDS. The result will be a Edge <br>
//!          or  Wire  from  TopoDS. <br>
class BRepProj_Projection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Makes a Cylindrical projection Lsh on Ssh <br>
Standard_EXPORT BRepProj_Projection(const TopoDS_Shape& Lsh,const TopoDS_Shape& Ssh,const gp_Dir& D,const Standard_Boolean FaceBounds = Standard_True);

//! Makes a Conical projection Lsh on Ssh <br>
Standard_EXPORT BRepProj_Projection(const TopoDS_Shape& Lsh,const TopoDS_Shape& Ssh,const gp_Pnt& P,const Standard_Boolean FaceBounds = Standard_True);
//! returns False if the section failed <br>
  Standard_Boolean IsDone() const;
//! Resets the iterator. <br>
  void Init() ;
//! Returns True if there is a result <br>
  Standard_Boolean More() const;
//! Move to the next result. <br>
  void Next() ;
//! Returns the current result. <br>
  TopoDS_Shape Current() const;
//! Returns the current result. <br>
  TopoDS_Shape Shape() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Real DistanceOut(const TopoDS_Shape& DS) ;


Standard_EXPORT   Standard_Real DistanceIn(const TopoDS_Shape& DS) ;


Standard_EXPORT   void MakeList(BRepAlgo_BooleanOperations& Bop) ;


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
TopoDS_Shape myLsh;
TopTools_ListIteratorOfListOfShape myItr;
TopoDS_Shape myShape;
TopTools_ListOfShape mySectionEdgeList;


};


#include <BRepProj_Projection.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
