// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_GenericColorMap_HeaderFile
#define _Aspect_GenericColorMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Aspect_GenericColorMap_HeaderFile
#include <Handle_Aspect_GenericColorMap.hxx>
#endif

#ifndef _TColStd_DataMapOfIntegerInteger_HeaderFile
#include <TColStd_DataMapOfIntegerInteger.hxx>
#endif
#ifndef _Aspect_ColorMap_HeaderFile
#include <Aspect_ColorMap.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Aspect_BadAccess;
class Aspect_ColorMapEntry;
class Quantity_Color;


//! This class defines a GenericColorMap object. <br>
class Aspect_GenericColorMap : public Aspect_ColorMap {

public:
 // Methods PUBLIC
 // 

//! Creates a generic ColorMap . <br>
Standard_EXPORT Aspect_GenericColorMap();

//! Adds an entry in the color map <me>. <br>
//!  Warning: Raises BadAccess if the ColorMapEntry index is alreadry <br>
//!          defined. <br>
Standard_EXPORT   void AddEntry(const Aspect_ColorMapEntry& AnEntry) ;

//! Search an identical color entry in the color map <me> <br>
//! and returns the ColorMapEntry Index if exist. <br>
//! Or add a new entry and returns the computed ColorMapEntry index used. <br>
Standard_EXPORT   Standard_Integer AddEntry(const Quantity_Color& aColor) ;

//! Remove the ColorMapEntry at position index in the ColorMap <br>
//!  Warning: Raises BadAccess if the index is not defined in the <br>
//!	    ColorMap. <br>
Standard_EXPORT   void RemoveEntry(const Standard_Integer AColorMapEntryIndex) ;

//! Returns the index in the ColorMap of the <br>
//!	    ColorMapEntry.Index() equal to <AnEntryIndex>. <br>
//!  Warning: Raises BadAccess if the index is not defined in the <br>
//!	    ColorMap. <br>
Standard_EXPORT   Standard_Integer FindColorMapIndex(const Standard_Integer AColorMapEntryIndex) const;

//! Returns the ColorMapEntry with ColorMapEntry.Index() <br>
//!	    equal to <AnEntryIndex>. <br>
//!  Warning: Raises BadAccess if the index is not defined in the <br>
//!	    ColorMap. <br>
Standard_EXPORT  const Aspect_ColorMapEntry& FindEntry(const Standard_Integer AColorMapEntryIndex) const;

//! Returns the index in the ColorMap of the <br>
//!	    nearest matching ColorMapEntry <br>
Standard_EXPORT   Standard_Integer NearestColorMapIndex(const Quantity_Color& aColor) const;

//! Returns the nearest ColorMapEntry that match aColor . <br>
Standard_EXPORT  const Aspect_ColorMapEntry& NearestEntry(const Quantity_Color& aColor) const;
//Standard_EXPORT ~Aspect_GenericColorMap();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
TColStd_DataMapOfIntegerInteger myDataMap;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
