#!/usr/bin/perl
# 
# timesheet-migrate-data-2.0-2.1.pl 
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: timesheet-migrate-data-2.0-2.1.pl,v 1.7 2001/08/29 22:23:13 adam Exp $
#
use Getopt::Long;
use ADB; 
require "../etc/timesheet.conf"; 
require '../lib/common-funcs.pl';
&GetOptions (
	     "help" => \$help, 
	     "mode=s" => \$mode 
	     ); 

$dumpdir=shift;
if ( ! $dumpdir || $help ) { 
  &usage; 
  exit 0; 
}

sub usage { 
    print "timehseet-migrate-data-2.0-2.1.pl\n" .
      "Usage:\n" . 
        "timesheet-migrate-data-2.0-2.1.pl dumpdir\n\n" . 
	  "Where \"dumpdir\" is the directory where a timesheet-dump was performed\n\n" . 
	    "In the upgrade process, this script should be run after the database has\n" .
	      "been dumped, deleted, and receated as part of the 2.1 install.\n"; 
            
  }; 

if ( $mode eq "migrate" ) { 
  &migrate; 
} else { 
  &import_old; 
  &migrate; 
}

sub import_old { 
    print "\n********************************************\n" . 
	"Migrating data from timesheet v2.0 to timesheet v2.1\n" . 
	    "********************************************\n" . 
		"This process may take some time, so please be patient. \n\n" . 
		    "During the process, only relevant errors will be echoed to your terminal.\n" . 
			"It would probably be a good thing to address these errors.\n"; 
    foreach  $table ("client",  "hours", "job" ,"personnel") { 
	print "\n********************************************\n"; 
	print "   Importing data from table $table\n"; 
	print "********************************************\n"; 
	open (DUMP, "$dumpdir/$table") or die "Can't open $dumpdir/$table"; 
	open (SQL, "|psql timesheet 2>&1 | grep ERROR | grep -v 'Cannot create index' | grep -v 'relation already exists'"); 
	while (<DUMP>) { 
	    if ( $table eq "hours" || $table eq "client" || $table eq "job" ) { 
	      $_ =~ s/^(INSERT INTO|CREATE TABLE) "$table" /$1 "$table-old" /
	    }
	    print SQL $_; 
	}
	close SQL; 
  }
} 

sub migrate { 
    print "\n********************************************\n"; 
    print "   Migrating old hours data  to new format\n"; 
    print "*********************************************\n"; 
    print "There will probably be a few \"key value was not unique\" errors.\n"; 
    print "For each of these errors, you will have to re-enter\n"; 
    print "the record with a new, unique, value for hours_id\n"; 
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB, 'sql_escape_data');
    if(!$dbconn->is_ok){
	$oops = $dbconn->errorstring;
	print STDERR "Failed connection to backend: $oops";
	exit 1; 
    }

    $sq="Select hours_id,fkjob_id, fkclient_id, fkpersonnel_id, date_entered, intime, time_in, time_out, total_hours, billable, hours_description, comment, category, parking, expense_amount, downloaded, fkapprover_id, approval_date, del  from \"hours-old\""; 
    my $munge=$dbconn->query("$sq"); 
    if ( ! $munge ) { 
	$oops = $dbconn->errorstring; 
	print STDERR "Error getting old hours: $oops\n$sq\n"; 
	exit 1; 
    }
    
    $n=$munge->get_num_rows; 
    for ( $i=0; $i < $n; $i++) { 
	my %new;
	%jh=$munge->get_row($i);
	unless ($dbconn->insert_record($Conf::HOURS_DB_KEY, 
				       $Conf::HOURS_DB, 
				       \%jh))
	{
	    my $oops = $dbconn->errorstring; 
	    print STDERR "\nError migrating record: \"$oops\"\n"; 
	    foreach (keys %jh) {
		print STDERR "$_ = '$jh{$_}'\n";
	    }
	}
    }

    print "\n********************************************\n"; 
    print "   Migrating old client data to new format\n"; 
    print "*********************************************\n"; 


    $sq="Select client_id, client_name, default_bill_rate from \"client-old\""; 
    my $munge=$dbconn->query("$sq"); 
    if ( ! $munge ) { 
	$oops = $dbconn->errorstring; 
	print STDERR "Error getting old client: $oops\n$sq\n"; 
	exit 1; 
    }
    
    $n=$munge->get_num_rows; 
    for ( $i=0; $i < $n; $i++) { 
	%jh=$munge->get_row($i);
	$jh{default_bill_rate} = "\$$jh{default_bill_rate}"; 
	unless ($dbconn->insert_record($Conf::CLIENT_DB_KEY, 
				       $Conf::CLIENT_DB, 
				       \%jh))
	{
	    my $oops = $dbconn->errorstring; 
	    print STDERR "\nError migrating record: \"$oops\"\n"; 
	    foreach (keys %jh) {
		print STDERR "$_ = '$jh{$_}'\n";
	    }
	}
      }
    
    
    print "\n********************************************\n"; 
    print "   Migrating old job data to new format\n"; 
    print "*********************************************\n"; 

    $sq="Select job_id, fkclient_id, estimated_hours, current_hours_estimate, current_estimate_date, open_date, close_date, open, bill_rate, job_description, default_approved, fksupervisor_id, fknotify_id, flag_hrs, category, downloaded from \"job-old\""; 
    my $munge=$dbconn->query("$sq"); 
    if ( ! $munge ) { 
	$oops = $dbconn->errorstring; 
	print STDERR "Error getting old job data: $oops\n$sq\n"; 
    }
    
    $n=$munge->get_num_rows; 
    for ( $i=0; $i < $n; $i++) { 
	%jh=$munge->get_row($i);
	$jh{bill_rate} = "\$$jh{bill_rate}"; 
	unless ($dbconn->insert_record($Conf::JOB_DB_KEY, 
				       $Conf::JOB_DB, 
				       \%jh))
	{
	    my $oops = $dbconn->errorstring; 
	    print STDERR "\nError migrating record: \"$oops\"\n"; 
	    foreach (keys %jh) {
		print STDERR "$_ = '$jh{$_}'\n";
	    }
	}
    }
    
    print "\n********************************************\n"; 
    print "DONE.  Cleaning up\n";
    print "*******************************************\n"; 

    foreach  $table ("job-old", "hours-old", "client-old") {
      $sq="drop table \"$table\""; 
      my $munge=$dbconn->query("$sq"); 
      if ( ! $munge ) { 
	$oops = $dbconn->errorstring; 
	print STDERR "Error dropping table ${table}-old: $oops"; 
	exit 1; 
      }
    }
}

  








