#!/usr/bin/perl
#
# timesheet-log-from.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
# log_from.pl
# what more can I say?  This is a program to log timesheet hours from STDIN
#
#\USERNAME
#\PASSWORD
#\BEGIN
#\SERIAL
#\CLIENT_ID
#\FUNCTION
#\CLIENT_NAME
#\JOB_ID
#\DATE_ENTERED
#\TOTAL_HOURS
#\TIME_IN
#\TIME_OUT
#\PARKING
#\TRAVEL
#\BILLABLE
#\HOURS_DESCRIPTION
#\COMMENT
#\END
#\QUIT
#
# output errors: (???)
#ERROR: <blah>
#WARNING: <blah>
#OUTPUT: <blah>

#use strict;
use URI::URL;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use Getopt::Long; 

&GetOptions(
	    "approot=s" => \$approot, 
	    "cgi=s" => \$cgi, 
	    );

if ( ! $approot ) {
    $approot = "http://localhost/onshore-timesheet/";
}

if ( ! $cgi ) { 
    $cgi = "loghours.cgi"; 
}

my $uri = new URI::URL($cgi, $approot);

my ($INPUT, $field, %field_hash, $serial, %login_hash);

&init_hash();

while (<STDIN>) {
    $INPUT = $_;
    chomp $INPUT;
    if ($INPUT =~ /^\\/) {
	$field = $INPUT;
	$field =~ s/[^A-Z_]//g;
	if (($INPUT =~ /^\\USERNAME/) || ($INPUT =~ /^\\PASSWORD/)) {
	    $login_hash{$field} = '';
	}
	elsif ($INPUT =~ /^\\BEGIN/) {
	    &init_hash();
	}
	elsif ($INPUT =~ /^\\SERIAL/) {
	    $serial = 0;
	}
	elsif ($INPUT =~ /^\\END/) {
	    &send_info();
	}
	elsif ($INPUT =~ /^\\QUIT/) {
	    exit;
	}
	else {
	    $field_hash{$field} = '';     
	}
    }
    else {
	$INPUT =~ s/[ \t]*$//;
	if (($field eq 'USERNAME') || ($field eq 'PASSWORD')) {
	    $login_hash{$field} = $INPUT;
	}
	elsif ($field eq 'SERIAL') {
	    $serial = $INPUT;
	}
	else {
	    # These are the only two multiline fields; we have to explicitly
	    # put back the newlines, because they got `chomp'ed off earlier
	    # (which is desirable for most fields):
	    if (($field eq 'HOURS_DESCRIPTION') or ($field eq 'COMMENT')) {
		$INPUT .= "\n";
	    }
	    $field_hash{$field} .= $INPUT;
	}
    }
}

sub init_hash {
    undef %field_hash;
    undef $serial;
    %field_hash = ('CLIENT_ID'=>140,
		   'FUNCTION'=>'log',
		   'CLIENT_NAME'=>'onShore, Inc.',
		   'JOB_ID'=>11888,
		   'DATE_ENTERED'=>'DATE',
		   'TOTAL_HOURS'=>1,
		   'TIME_IN'=>'',
		   'TIME_OUT'=>'',
		   'PARKING'=>'',
		   'TRAVEL'=>0,
		   'BILLABLE'=>'y',
		   'HOURS_DESCRIPTION'=>'Testing testing',
		   'COMMENT'=>'Whoop');
    $serial = 0;
}

sub send_info {
    my $user = $login_hash{'USERNAME'};
    my $pass = $login_hash{'PASSWORD'};

    my $FORM = '';
    foreach my $KEY (keys %field_hash) {
	my $key = lc($KEY);
	if ($FORM ne '') {
	    $FORM .= '&';
	}
	$FORM .= "$key=$field_hash{$KEY}";
    }

    # copied subclass of LWP::UserAgent for passing Basic Authentication
    # (from /usr/local/GET)
    {
	package RequestAgent;
	@ISA = qw(LWP::UserAgent);

	sub new	{ 
	    my $self = LWP::UserAgent::new(@_);
	    $self->agent("lwp-request/$main::VERSION");
	    $self;
	}

	sub get_basic_credentials {
	    return ($user, $pass);
	}
    }
    
    my $ua = new RequestAgent;
    
    my $req = new HTTP::Request('POST', $uri);
    $req->header('content-type'=>'application/x-www-form-urlencoded');
    $req->authorization_basic($uname, $password);
    $req->content("$FORM");
    my $resp = $ua->request($req);
  
    if (($resp->is_success) && 
	($resp->content =~ /Hours Successfully Logged/s)) {
	print "\\SUCCESS: $serial\n";
    }
    elsif ($resp->is_error) {
	print "\\FAILURE: $serial\n";
	print $resp->error_as_HTML;
    }
    else {
	print "\\FAILURE: $serial\n";
	print $resp->content;
    }
}


