/*
// $Id: OlapStatement.java 229 2009-05-08 19:11:29Z jhyde $
// This software is subject to the terms of the Eclipse Public License v1.0
// Agreement, available at the following URL:
// http://www.eclipse.org/legal/epl-v10.html.
// Copyright (C) 2006-2008 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package org.olap4j;

import java.sql.Statement;

import org.olap4j.mdx.SelectNode;

/**
 * Object used for statically executing an MDX statement and returning a
 * {@link CellSet}.
 *
 * <p>An <code>OlapStatement</code> is generally created using
 * {@link OlapConnection#createStatement()}.</p>
 *
 * @see PreparedOlapStatement
 *
 * @author jhyde
 * @version $Id: OlapStatement.java 229 2009-05-08 19:11:29Z jhyde $
 * @since Aug 22, 2006
 */
public interface OlapStatement extends Statement, OlapWrapper {

    /**
     * Executes an OLAP statement.
     *
     * @param mdx MDX <code>SELECT</code> statement
     *
     * @return Cell set
     *
     * @throws OlapException if a database access error occurs,
     * this method is called on a closed <code>OlapStatement</code>,
     * the query times out (see {@link #setQueryTimeout(int)})
     * or another thread cancels the statement (see {@link #cancel()})
     */
    CellSet executeOlapQuery(String mdx) throws OlapException;

    /**
     * Executes an OLAP statement expressed as a parse tree.
     *
     * <p>Validates the parse tree before executing it.
     *
     * @param selectNode Parse tree of MDX <code>SELECT</code> statement
     *
     * @return Cell set
     *
     * @throws OlapException if a database access error occurs,
     * this method is called on a closed <code>OlapStatement</code>,
     * the query times out (see {@link #setQueryTimeout(int)})
     * or another thread cancels the statement (see {@link #cancel()})
     */
    CellSet executeOlapQuery(SelectNode selectNode) throws OlapException;
}

// End OlapStatement.java
