#include <klocale.h>

#include "language.h"

LangCode::LangCode(const QString& n,const QString& c)
{
 name = n;
 code = c;
}

void Language::init()
{
 languages.append(new LangCode(I18N_NOOP("Abkhazian"),"ab"));
 languages.append(new LangCode(I18N_NOOP("Afrikaans"),"af"));
 languages.append(new LangCode(I18N_NOOP("Albanian"),"sq"));
 languages.append(new LangCode(I18N_NOOP("Amharic"),"am"));
 languages.append(new LangCode(I18N_NOOP("Arabic"),"ar"));
 languages.append(new LangCode(I18N_NOOP("Armenian"),"hy"));
 languages.append(new LangCode(I18N_NOOP("Assamese"),"as"));
 languages.append(new LangCode(I18N_NOOP("Avestan"),"ae"));
 languages.append(new LangCode(I18N_NOOP("Aymara"),"ay"));
 languages.append(new LangCode(I18N_NOOP("Azerbaijani"),"az"));
 languages.append(new LangCode(I18N_NOOP("Bashkir"),"ba"));
 languages.append(new LangCode(I18N_NOOP("Basque"),"eu"));
 languages.append(new LangCode(I18N_NOOP("Belarusian"),"be"));
 languages.append(new LangCode(I18N_NOOP("Bengali"),"bn"));
 languages.append(new LangCode(I18N_NOOP("Bihari"),"bh"));
 languages.append(new LangCode(I18N_NOOP("Bislama"),"bi"));
 languages.append(new LangCode(I18N_NOOP("Bosnian"),"bs"));
 languages.append(new LangCode(I18N_NOOP("Breton"),"br"));
 languages.append(new LangCode(I18N_NOOP("Bulgarian"),"bg"));
 languages.append(new LangCode(I18N_NOOP("Burmese"),"my"));
 languages.append(new LangCode(I18N_NOOP("Catalan"),"ca"));
 languages.append(new LangCode(I18N_NOOP("Chamorro"),"ch"));
 languages.append(new LangCode(I18N_NOOP("Chechen"),"ce"));
 languages.append(new LangCode(I18N_NOOP("Chichewa; Nyanja"),"ny"));
 languages.append(new LangCode(I18N_NOOP("Chinese"),"zh"));
 languages.append(new LangCode(I18N_NOOP("Church Slavic"),"cu"));
 languages.append(new LangCode(I18N_NOOP("Chuvash"),"cv"));
 languages.append(new LangCode(I18N_NOOP("Cornish"),"kw"));
 languages.append(new LangCode(I18N_NOOP("Corsican"),"co"));
 languages.append(new LangCode(I18N_NOOP("Croatian"),"hr"));
 languages.append(new LangCode(I18N_NOOP("Czech"),"cs"));
 languages.append(new LangCode(I18N_NOOP("Danish"),"da"));
 languages.append(new LangCode(I18N_NOOP("Dutch"),"nl"));
 languages.append(new LangCode(I18N_NOOP("Dzongkha"),"dz"));
 languages.append(new LangCode(I18N_NOOP("English"),"en"));
 languages.append(new LangCode(I18N_NOOP("Esperanto"),"eo"));
 languages.append(new LangCode(I18N_NOOP("Estonian"),"et"));
 languages.append(new LangCode(I18N_NOOP("Faroese"),"fo"));
 languages.append(new LangCode(I18N_NOOP("Fijian"),"fj"));
 languages.append(new LangCode(I18N_NOOP("Finnish"),"fi"));
 languages.append(new LangCode(I18N_NOOP("French"),"fr"));
 languages.append(new LangCode(I18N_NOOP("Frisian"),"fy"));
 languages.append(new LangCode(I18N_NOOP("Gaelic (Scots)"),"gd"));
 languages.append(new LangCode(I18N_NOOP("Gallegan"),"gl"));
 languages.append(new LangCode(I18N_NOOP("Georgian"),"ka"));
 languages.append(new LangCode(I18N_NOOP("German"),"de"));
 languages.append(new LangCode(I18N_NOOP("Greek"),"el"));
 languages.append(new LangCode(I18N_NOOP("Guarani"),"gn"));
 languages.append(new LangCode(I18N_NOOP("Gujarati"),"gu"));
 languages.append(new LangCode(I18N_NOOP("Hausa"),"ha"));
 languages.append(new LangCode(I18N_NOOP("Hebrew"),"he"));
 languages.append(new LangCode(I18N_NOOP("Hebrew"),"iw"));
 languages.append(new LangCode(I18N_NOOP("Herero"),"hz"));
 languages.append(new LangCode(I18N_NOOP("Hindi"),"hi"));
 languages.append(new LangCode(I18N_NOOP("Hiri Motu"),"ho"));
 languages.append(new LangCode(I18N_NOOP("Hungarian"),"hu"));
 languages.append(new LangCode(I18N_NOOP("Icelandic"),"is"));
 languages.append(new LangCode(I18N_NOOP("Indonesian"),"id"));
 languages.append(new LangCode(I18N_NOOP("Indonesian"),"in"));
 languages.append(new LangCode(I18N_NOOP("Interlingua"),"ia"));
 languages.append(new LangCode(I18N_NOOP("Interlingue"),"ie"));
 languages.append(new LangCode(I18N_NOOP("Inuktitut"),"iu"));
 languages.append(new LangCode(I18N_NOOP("Inupiaq"),"ik"));
 languages.append(new LangCode(I18N_NOOP("Irish"),"ga"));
 languages.append(new LangCode(I18N_NOOP("Italian"),"it"));
 languages.append(new LangCode(I18N_NOOP("Japanese"),"ja"));
 languages.append(new LangCode(I18N_NOOP("Javanese"),"jv"));
 languages.append(new LangCode(I18N_NOOP("Javanese"),"jw"));
 languages.append(new LangCode(I18N_NOOP("Kalaallisut"),"kl"));
 languages.append(new LangCode(I18N_NOOP("Kannada"),"kn"));
 languages.append(new LangCode(I18N_NOOP("Kashmiri"),"ks"));
 languages.append(new LangCode(I18N_NOOP("Kazakh"),"kk"));
 languages.append(new LangCode(I18N_NOOP("Khmer"),"km"));
 languages.append(new LangCode(I18N_NOOP("Kikuyu"),"ki"));
 languages.append(new LangCode(I18N_NOOP("Kinyarwanda"),"rw"));
 languages.append(new LangCode(I18N_NOOP("Kirghiz"),"ky"));
 languages.append(new LangCode(I18N_NOOP("Komi"),"kv"));
 languages.append(new LangCode(I18N_NOOP("Korean"),"ko"));
 languages.append(new LangCode(I18N_NOOP("Kuanyama"),"kj"));
 languages.append(new LangCode(I18N_NOOP("Kurdish"),"ku"));
 languages.append(new LangCode(I18N_NOOP("Lao"),"lo"));
 languages.append(new LangCode(I18N_NOOP("Latin"),"la"));
 languages.append(new LangCode(I18N_NOOP("Latvian"),"lv"));
 languages.append(new LangCode(I18N_NOOP("Letzeburgesch"),"lb"));
 languages.append(new LangCode(I18N_NOOP("Lingala"),"ln"));
 languages.append(new LangCode(I18N_NOOP("Lithuanian"),"lt"));
 languages.append(new LangCode(I18N_NOOP("Macedonian"),"mk"));
 languages.append(new LangCode(I18N_NOOP("Malagasy"),"mg"));
 languages.append(new LangCode(I18N_NOOP("Malay"),"ms"));
 languages.append(new LangCode(I18N_NOOP("Malayalam"),"ml"));
 languages.append(new LangCode(I18N_NOOP("Maltese"),"mt"));
 languages.append(new LangCode(I18N_NOOP("Manx"),"gv"));
 languages.append(new LangCode(I18N_NOOP("Maori"),"mi"));
 languages.append(new LangCode(I18N_NOOP("Marathi"),"mr"));
 languages.append(new LangCode(I18N_NOOP("Marshall"),"mh"));
 languages.append(new LangCode(I18N_NOOP("Moldavian"),"mo"));
 languages.append(new LangCode(I18N_NOOP("Mongolian"),"mn"));
 languages.append(new LangCode(I18N_NOOP("Nauru"),"na"));
 languages.append(new LangCode(I18N_NOOP("Navajo"),"nv"));
 languages.append(new LangCode(I18N_NOOP("Ndebele, North"),"nd"));
 languages.append(new LangCode(I18N_NOOP("Ndebele, South"),"nr"));
 languages.append(new LangCode(I18N_NOOP("Ndonga"),"ng"));
 languages.append(new LangCode(I18N_NOOP("Nepali"),"ne"));
 languages.append(new LangCode(I18N_NOOP("Northern Sami"),"se"));
 languages.append(new LangCode(I18N_NOOP("Norwegian"),"no"));
 // TRANSLATORS: this is really Bokm&#229;l
 languages.append(new LangCode(I18N_NOOP("Norwegian Bokmaal"),"nb"));
 languages.append(new LangCode(I18N_NOOP("Norwegian Nynorsk"),"nn"));
 languages.append(new LangCode(I18N_NOOP("Nyanja; Chichewa"),"ny"));
 languages.append(new LangCode(I18N_NOOP("Occitan"),"oc"));
 languages.append(new LangCode(I18N_NOOP("Oriya"),"or"));
 languages.append(new LangCode(I18N_NOOP("Oromo"),"om"));
 languages.append(new LangCode(I18N_NOOP("Ossetian"),"os"));
 languages.append(new LangCode(I18N_NOOP("Pali"),"pi"));
 languages.append(new LangCode(I18N_NOOP("Panjabi"),"pa"));
 languages.append(new LangCode(I18N_NOOP("Persian"),"fa"));
 languages.append(new LangCode(I18N_NOOP("Polish"),"pl"));
 languages.append(new LangCode(I18N_NOOP("Portuguese"),"pt"));
 // TRANSLATORS: this is really Proven&#231;al
 languages.append(new LangCode(I18N_NOOP("Provenc,al"),"oc"));
 languages.append(new LangCode(I18N_NOOP("Pushto"),"ps"));
 languages.append(new LangCode(I18N_NOOP("Quechua"),"qu"));
 languages.append(new LangCode(I18N_NOOP("Raeto-Romance"),"rm"));
 languages.append(new LangCode(I18N_NOOP("Romanian"),"ro"));
 languages.append(new LangCode(I18N_NOOP("Rundi"),"rn"));
 languages.append(new LangCode(I18N_NOOP("Russian"),"ru"));
 languages.append(new LangCode(I18N_NOOP("Samoan"),"sm"));
 languages.append(new LangCode(I18N_NOOP("Sango"),"sg"));
 languages.append(new LangCode(I18N_NOOP("Sanskrit"),"sa"));
 languages.append(new LangCode(I18N_NOOP("Sardinian"),"sc"));
 languages.append(new LangCode(I18N_NOOP("Serbian"),"sr"));
 languages.append(new LangCode(I18N_NOOP("Serbo-Croatian"),"sh"));
 languages.append(new LangCode(I18N_NOOP("Shona"),"sn"));
 languages.append(new LangCode(I18N_NOOP("Sindhi"),"sd"));
 languages.append(new LangCode(I18N_NOOP("Sinhalese"),"si"));
 languages.append(new LangCode(I18N_NOOP("Slovak"),"sk"));
 languages.append(new LangCode(I18N_NOOP("Slovenian"),"sl"));
 languages.append(new LangCode(I18N_NOOP("Somali"),"so"));
 languages.append(new LangCode(I18N_NOOP("Sotho, Southern"),"st"));
 languages.append(new LangCode(I18N_NOOP("Spanish"),"es"));
 languages.append(new LangCode(I18N_NOOP("Sundanese"),"su"));
 languages.append(new LangCode(I18N_NOOP("Swahili"),"sw"));
 languages.append(new LangCode(I18N_NOOP("Swati"),"ss"));
 languages.append(new LangCode(I18N_NOOP("Swedish"),"sv"));
 languages.append(new LangCode(I18N_NOOP("Tagalog"),"tl"));
 languages.append(new LangCode(I18N_NOOP("Tahitian"),"ty"));
 languages.append(new LangCode(I18N_NOOP("Tajik"),"tg"));
 languages.append(new LangCode(I18N_NOOP("Tamil"),"ta"));
 languages.append(new LangCode(I18N_NOOP("Tatar"),"tt"));
 languages.append(new LangCode(I18N_NOOP("Telugu"),"te"));
 languages.append(new LangCode(I18N_NOOP("Thai"),"th"));
 languages.append(new LangCode(I18N_NOOP("Tibetan"),"bo"));
 languages.append(new LangCode(I18N_NOOP("Tigrinya"),"ti"));
 languages.append(new LangCode(I18N_NOOP("Tonga"),"to"));
 languages.append(new LangCode(I18N_NOOP("Tsonga"),"ts"));
 languages.append(new LangCode(I18N_NOOP("Tswana"),"tn"));
 languages.append(new LangCode(I18N_NOOP("Turkish"),"tr"));
 languages.append(new LangCode(I18N_NOOP("Turkmen"),"tk"));
 languages.append(new LangCode(I18N_NOOP("Twi"),"tw"));
 languages.append(new LangCode(I18N_NOOP("Uighur"),"ug"));
 languages.append(new LangCode(I18N_NOOP("Ukrainian"),"uk"));
 languages.append(new LangCode(I18N_NOOP("Urdu"),"ur"));
 languages.append(new LangCode(I18N_NOOP("Uzbek"),"uz"));
 languages.append(new LangCode(I18N_NOOP("Vietnamese"),"vi"));
 // TRANSLATORS: this is really Volap&#252;k
 languages.append(new LangCode(I18N_NOOP("Volapuk"),"vo"));
 languages.append(new LangCode(I18N_NOOP("Welsh"),"cy"));
 languages.append(new LangCode(I18N_NOOP("Wolof"),"wo"));
 languages.append(new LangCode(I18N_NOOP("Xhosa"),"xh"));
 languages.append(new LangCode(I18N_NOOP("Yiddish"),"yi"));
 languages.append(new LangCode(I18N_NOOP("Yiddish"),"ji"));
 languages.append(new LangCode(I18N_NOOP("Yoruba"),"yo"));
 languages.append(new LangCode(I18N_NOOP("Zhuang"),"za"));
 languages.append(new LangCode(I18N_NOOP("Zulu"),"zu"));
}

QString Language::name(DVDLangID_t lang) 
{
 QString lang_code;
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<languages.count();i++)
  {
   if(languages.at(i)->code == lang_code)
    return i18n(languages.at(i)->name);
  }
 // Unknown language
 return i18n("Unknown");
}

QString Language::code(DVDLangID_t lang) 
{
 QString lang_code;
  
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<languages.count();i++)
  {
   if(languages.at(i)->code == lang_code)
    return languages.at(i)->code;
  }
 return "??";
}

QStringList Language::allNames()
{
 QStringList tmplist;
 for(uint i=0;i<languages.count();i++)
  tmplist.append(i18n(languages.at(i)->name));
 tmplist.sort();
 return tmplist;
}

QStringList Language::allCodes()
{
 QStringList tmplist;
 for(uint i=0;i<languages.count();i++)
  tmplist.append(languages.at(i)->code);
 tmplist.sort();
 return tmplist;
}

DVDLangID_t Language::id(const QString& str)
{
 DVDLangID_t langid = 0;
 QString code_639_1;
 for(uint i=0;languages.count();i++)
  {
   if(i18n(languages.at(i)->name) == str)
    {
     langid = QChar(languages.at(i)->code[0]) << 8;
     langid += QChar(languages.at(i)->code[1]);
     break;
    }
  }
 return langid;
}

QPtrList<LangCode> Language::languages;

