// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "surface.h"
#include "axes.h"
#include "figure.h"
#include "mathutils.h"

#define OBJ_NAME "Surface"

Surface::Surface(ocpl::Handle Parent, 
	     Matrix& XData, 
	     Matrix& YData, 
	     Matrix& ZData) : Object(Parent)
{
  Properties["XData"]     = new Matrix(XData,1);
  Properties["YData"]     = new Matrix(YData,1);
  Properties["ZData"]     = new Matrix(ZData,1);

  SET_TYPE;
//   COPY_DEFAULT(FaceColor,Color);
//   COPY_DEFAULT(EdgeColor,Color);
//   COPY_DEFAULT(LineWidth,Scalar);
  //  COPY_DEFAULT(LineStyle,Radio);
  COPY_DEFAULT(Clipping,Radio);
 
  // update limits
  FindMinMax(XData,min[0],max[0],lmin[0],lmax[0],ZData.nc());
  FindMinMax(YData,min[1],max[1],lmin[1],lmax[1],ZData.nr());
  FindMinMax(ZData,min[2],max[2],lmin[2],lmax[2]);

  // init display list
  display_list = 0;
}

void Surface::draw()
{
  IS_VISIBLE;

  MAKE_REF(clipping,Radio);
//   MAKE_REF(linestyle,Radio);
//   MAKE_REF(edgecolor,Color);
//   MAKE_REF(linewidth,Scalar);
//   MAKE_REF(markercolor,Color);
//   MAKE_REF(marker,Radio);
//   MAKE_REF(markersize,Scalar);
  

  // if we have a list, use it
//   if(display_list) {
//     SET_CLIPPING;
//     glCallList(display_list);
//     UNSET_CLIPPING;
//     return;
//   }


  MAKE_REF(xdata,Matrix);
  MAKE_REF(ydata,Matrix);
  MAKE_REF(zdata,Matrix);

  Axes* axes  = dynamic_cast<Axes*>(FindParentOfType("axes"));
  Figure* fig = dynamic_cast<Figure*>(FindParentOfType("Figure"));
  Radio& xscale = ::Get<Radio>(axes,"xscale");
  Radio& yscale = ::Get<Radio>(axes,"yscale");
  Matrix& clim  = ::Get<Matrix>(axes,"clim");
  Matrix& cmap  = ::Get<Matrix>(fig,"ColorMap");

  SET_CLIPPING;
  
  //
  // 1---2
  // |   |
  // |   |
  // 0---3
  //


//   display_list = glGenLists (1);
//   glNewList(display_list, GL_COMPILE_AND_EXECUTE);
  double x0,y0,x1,y1,x2,y2,x3,y3;
  for(long xi = 0 ; xi < zdata.nc()-1 ; xi++) {
    for(long yi = 0 ; yi < zdata.nr()-1 ; yi++) {

      if(xdata.len()==0) {
	x0 = x1 = xi+1;
	x2 = x3 = xi+2;
      }
      else if(xdata.len()==zdata.nc()) {
	x0 = x1 = xdata(xi);
	x2 = x3 = xdata(xi+1);
      }
      else {
	x0 = xdata(yi,xi);
	x1 = xdata(yi+1,xi);
	x2 = xdata(yi+1,xi+1);
	x3 = xdata(yi,xi+1);
      }

      if(ydata.len()==0) {
	y0 = y3 = yi+1.;
	y1 = y2 = yi+2.;
      }
      else if(ydata.len()==zdata.nr()) {
	y0 = y3 = ydata(yi);
	y1 = y2 = ydata(yi+1);
      }
      else {
	y0 = ydata(yi,xi);
	y1 = ydata(yi+1,xi);
	y2 = ydata(yi+1,xi+1);
	y3 = ydata(yi,xi+1);
      }
      
      double midpx = (x0+x1+x2+x3)/4.;
      double midpy = (y0+y1+y2+y3)/4.;
      double midpz = (zdata(yi,xi) + 
		      zdata(yi+1,xi) +
		      zdata(yi+1,xi+1) +
		      zdata(yi,xi+1))/4.;
  
      glBegin(GL_TRIANGLE_FAN);
      double cv[3];
      InterpColor(cmap, clim, midpz, cv);
      glColor3dv(cv);
      glVertex3d(midpx,midpy,0);
      glVertex3d(x0,y0,0);
      glVertex3d(x1,y1,0);
      glVertex3d(x2,y2,0);
      glVertex3d(x3,y3,0);
      glVertex3d(x0,y0,0);
      glEnd();
    }
  }
//   glEndList();
  
  UNSET_CLIPPING;
}

