

%  This example demonstrates cell picking using vtkCellPicker.  It
%  displays the results of picking using a vtkTextMapper.

vtk_init;

%  create a sphere source, mapper, and actor
sphere = vtkSphereSource();
sphereMapper = vtkPolyDataMapper();
sphereMapper.SetInput(sphere.GetOutput());
sphereMapper.GlobalImmediateModeRenderingOn();
sphereActor = vtkLODActor();
sphereActor.SetMapper(sphereMapper);

%  create the spikes by glyphing the sphere with a cone.  Create the
%  mapper and actor for the glyphs.
cone = vtkConeSource();
glyph = vtkGlyph3D();
glyph.SetInput(sphere.GetOutput());
glyph.SetSource(cone.GetOutput());
glyph.SetVectorModeToUseNormal();
glyph.SetScaleModeToScaleByVector();
glyph.SetScaleFactor(0.25);
spikeMapper = vtkPolyDataMapper();
spikeMapper.SetInput(glyph.GetOutput());
spikeActor = vtkLODActor();
spikeActor.SetMapper(spikeMapper);

%  Create a text mapper and actor to display the results of picking.
global textMapper = vtkTextMapper();
tprop = textMapper.GetTextProperty();
tprop.SetFontFamilyToArial();
tprop.SetFontSize(10);
tprop.BoldOn();
tprop.ShadowOn();
tprop.SetColor(1, 0, 0);
global textActor;
textActor = vtkActor2D();
textActor.VisibilityOff();
textActor.SetMapper(textMapper);

%  Create a cell picker.
global picker = vtkCellPicker();

% Create an Octave function to create the text for the text 
% mapper used to display the results of picking.
function PickAnnotate(object, event)
    global picker;
		global textActor;
		global textMapper;
    if picker.GetCellId() < 0
        textActor.VisibilityOff();
    else
        selPt = picker.GetSelectionPoint();
        pickPos = picker.GetPickPosition();
        textActor.SetPosition(selPt(1:2));
				textMapper.SetInput(sprintf('(%.6f, %.6f, %.6f)',pickPos));
        textActor.VisibilityOn();
     end
endfunction
%  Now at the end of the pick event call the above function.
picker.AddObserver("EndPickEvent", "PickAnnotate");

%  Create the Renderer, RenderWindow, etc. and set the Picker.
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);
iren.SetPicker(picker);

%  Add the actors to the renderer, set the background and size
ren.AddActor2D(textActor);
ren.AddActor(sphereActor);
ren.AddActor(spikeActor);
ren.SetBackground(1, 1, 1);
renWin.SetSize(300, 300);

%  Get the camera and zoom in closer to the image.
cam1 = ren.GetActiveCamera();
cam1.Zoom(1.4);


%  Initially pick the cell at this location.
picker.Pick(85, 126, 0, ren);
% renWin.Render();
vtkInitializeInteractor(iren);
