(* $Id: examplesLib.ml,v 1.2 2005/11/17 09:56:53 rwmj Exp $ *)

open Printf

module DB = Dbi_postgresql

(* This code creates some temporary tables and populates them with
 * data.  You don't need to worry about this code if you're just trying
 * to follow the examples.
 *)

let set_up_database dbname =
  printf "Connecting to database '%s' ...\n\n" dbname; flush stdout;

  (* Connect to the database. *)
  let dbh = new DB.connection dbname in

  let sth = dbh#prepare "create temporary table positions
                           (id int not null unique,
                            name text not null)" in
  sth#execute [];

  let sth = dbh#prepare "insert into positions (id, name) values (?, ?)" in
  sth#execute [`Int 1; `String "Boss"];
  sth#execute [`Int 2; `String "VP of Internal Affairs"];
  sth#execute [`Int 3; `String "Junior Minion"];

  let sth = dbh#prepare "create temporary table employees
                           (id serial primary key not null,
                            name text not null,
                            nickname text,
                            salary int not null,
                            position int not null
                              references positions (id))" in
  sth#execute [];

  let sth = dbh#prepare "insert into employees (name, nickname, salary,
                           position)
                         values (?, ?, ?, ?)" in
  sth#execute [`String "Anne";   `Null;            `Int 10000; `Int 3];
  sth#execute [`String "Jane";   `Null;            `Int 15000; `Int 2];
  sth#execute [`String "Mark";   `Null;            `Int  9000; `Int 3];
  sth#execute [`String "Robert"; `String "Bob";    `Int 10000; `Int 3];
  sth#execute [`String "Thomas"; `String "Tom";    `Int 30000; `Int 1];

  dbh

let print_salaries title dbh =
  print_endline title;
  print_endline "-----";

  let sth = dbh#prepare "select name, salary
                           from employees
                          order by 1" in
  sth#execute [];

  sth#iter (function
	      | [`String name; `Int salary] ->
		  printf "%s is paid $%d.\n" name salary
	      | _ -> assert false);

  print_endline ""

let print_employees title dbh =
  print_endline title;
  print_endline "-----";

  let sth = dbh#prepare "select e.name, e.id, p.name, e.salary
                           from employees e, positions p
                          where e.position = p.id
                          order by 1" in
  sth#execute [];

  sth#iter (function
	      | [`String name; `Int id; `String position; `Int salary] ->
		  printf "%s (employee ID %d) position: %s salary: $%d\n"
		    name id position salary
	      | _ -> assert false);

  print_endline ""
