# Before `make install' is performed this script should be runnable
# with `make test'. After `make install' it should work as `perl
# IDOM_NamedNodeMap.t'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..14\n"; }
END {print "not ok 1\n" unless $loaded;}
use Carp;
use XML::Xerces;

use lib 't';
use TestUtils qw(result is_object $IDOM);
use vars qw($i $loaded);
use strict;

$loaded = 1;
$i = 1;
result($loaded);

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $document = <<EOT;
<list>
  <element one='1' two='2' three='3'/>
</list>
EOT

$IDOM->parse(XML::Xerces::MemBufInputSource->new($document));

my $doc = $IDOM->getDocument();

# get the single <element> node
my ($element) = $doc->getElementsByTagName('element');
my %attrs = $element->getAttributes();
result(scalar keys %attrs == 3 &&
       $attrs{one} == 1 &&
       $attrs{two} == 2 &&
       $attrs{three} == 3);

# test that we can still get a IDOM_NodeList object
# and test getLength()
my $idom_node_map = $element->getAttributes();
result(is_object($idom_node_map) 
      && $idom_node_map->isa('XML::Xerces::IDOM_NamedNodeMap')
      && $idom_node_map->getLength() == scalar keys %attrs
      );

# test item()
for (my $i=0;$i<scalar keys %attrs ;$i++) {
  my $node = $idom_node_map->item($i);
  result($attrs{$node->getNodeName} == $node->getNodeValue);
}

# test getNamedItem()
foreach (keys %attrs) {
  result($idom_node_map->getNamedItem($_)->getNodeValue eq $attrs{$_});
}

# test setNamedItem()
my $four = $doc->createAttribute('four');
$four->setNodeValue('4');
$idom_node_map->setNamedItem($four);
result($idom_node_map->getNamedItem('four')->getNodeValue eq $four->getNodeValue);

# test removeNamedItem()
$idom_node_map->removeNamedItem('four');
result($idom_node_map->getLength() == scalar keys %attrs);

#
# Test the DOM Level 2 methods
# 
my $uri = 'http://www.foo.bar/';
$document = <<EOT;
<list xmlns:qs="$uri">
  <element qs:one='1' qs:two='2' qs:three='3' one='27'/>
</list>
EOT

$IDOM->setDoNamespaces(1);
$IDOM->parse(XML::Xerces::MemBufInputSource->new($document));
$doc = $IDOM->getDocument();

# get the single <element> node
($element) = $doc->getElementsByTagName('element');
%attrs = $element->getAttributes();
$idom_node_map = $element->getAttributes();

# test getNamedItemNS()
my $oneNS = $idom_node_map->getNamedItemNS($uri,'one');
my $one = $idom_node_map->getNamedItem('one');
result($one->getNodeValue eq '27'
       && $oneNS->getNodeValue eq '1'
      );

# test setNamedItem()
$four = $doc->createAttributeNS($uri,'four');
$four->setNodeValue('4');
$idom_node_map->setNamedItemNS($four);
result($idom_node_map->getNamedItemNS($uri,'four')->getNodeValue eq $four->getNodeValue);

# test removeNamedItem()
$idom_node_map->removeNamedItemNS($uri,'four');
result($idom_node_map->getLength() == scalar keys %attrs);

