/* ***************************************************************************
 *
 * Pico Technology USBTC08 Device Driver
 *
 *//**
 * \file      readingbuff.h 
 * \brief     Definition of the ReadingBuffer class
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: readingbuff.h,v 1.2 2007/07/07 15:55:14 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef READINGBUFF_H
#define READINGBUFF_H

#include "pthread.h"
#include <limits>

#define RBUFFER_LOCK_TIMEOUT  2000UL  ///< 2 second lock timeout

/// Circular reading buffer class
class ReadingBuffer {
	public:
		ReadingBuffer ();
		~ReadingBuffer ();

		bool AddReading (float reading);
		bool AddReading (float reading, bool overflow);
		bool PadQNaN (long readingcount);
		bool set_TimeInfo (long interval_ms);
		bool set_ReadingBufferSize (long readingbuffersize);
		bool ResetBuffers (void);
		bool BufferIsFull (void);
		long get_Readings (float * readings, bool * overflow, long arraysize, long * firsttime);
		long get_Readings (float * readings, long arraysize, long * firsttime);
		long get_ReadingCount (bool * wrapped);

	private:
		inline void m_IncrementValueBuffer (void);
		inline long m_FirstAvailable (void);
		bool m_GetLock (void);
		void m_ReleaseLock (void);

		// Value buffer info
		long          ValueBufferCount;
		long          LastValuePosition;
		long          CurrentValuePosition;
		bool          BufferFull;

		// Time information
		long          SamplingInterval;
		long          LastValueTime;

		// Actual buffer pointer
		float * ValueBuffer;
		unsigned char  * OverflowFlagBuffer;

		/// Buffer lock serialises access to the buffer
		pthread_mutex_t m_LockBuffer;
	};

#endif /* not defined READINGBUFF_H */
