/* count.h
 */
#ifndef _MOVE_ACTION_COUNT_H
#define _MOVE_ACTION_COUNT_H
#include "osl/piece.h"
namespace osl
{
  namespace move_action
  {
    /**
     * 指手の数を数えるだけ
     */
    struct Count
    {
      int count;
      Count() : count(0)
      {
      }
      /** コマをとらないMove */
      void simpleMove(Square /*from*/,Square /*to*/,Ptype /*ptype*/, bool /*isPromote*/,Player /*p*/,Move){
	count++;
      }
      /** 
       *	コマを取るかもしれないMove 
       * @param from - 駒の移動元
       * @param to - 駒の移動先
       * @param p1 - 移動先のマスの駒
       * @param ptype - 移動後の駒のptype
       * @param isPromote - 成りか?
       * @param p - プレイヤー
       */
      void unknownMove(Square /*from*/,Square /*to*/,Piece /*p1*/,Ptype /*ptype*/,bool /*isPromote*/,Player /*p*/,Move){
	count++;
      }
      /** コマを打つMove */
      void dropMove(Square /*to*/,Ptype /*ptype*/,Player /*p*/,Move ){
	count++;
      }
      // old interfaces
      void simpleMove(Square from,Square to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,Move());
      }
      void unknownMove(Square from,Square to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,Move());
      }
      void dropMove(Square to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,Move());
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* _MOVE_ACTION_COUNT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
