/* trapRook.cc
 */
#include "osl/move_classifier/trapRook.h"


template <osl::Player P>
template <osl::Direction Dir>
bool osl::move_classifier::
TrapRook<P>::testDirection(const NumEffectState& state, Square initial)
{
  const Player Opponent = PlayerTraits<P>::opponent;
  for (Square p=initial+DirectionPlayerTraits<Dir,P>::offset();; 
       p+=DirectionPlayerTraits<Dir,P>::offset())
  {
    const Piece focus = state.pieceAt(p);
    if (! focus.canMoveOn<Opponent>())
      break;

    if (! state.hasEffectAt<P>(p))
      return false;
    if (focus.isOnBoardByOwner<P>())
      return true;
    assert(focus.isEmpty());
  }
  return true;
}


template <osl::Player P>
bool osl::move_classifier::
TrapRook<P>::isMember(const NumEffectState& state, 
		      Ptype ptype,Square from,Square to)
{
  // 横に行けない、縦に成れない、飛車の一つ後ろに利きがある
  // とりあえず歩で封じるものだけ
  if (ptype != PAWN)
    return false;
  if (! from.isPieceStand())
    return false;
  if (! state.hasEffectAt<P>(to))
    return false;
  const Square back_position = to + DirectionPlayerTraits<D,P>::offset();
  const Piece rook = state.pieceAt(back_position);
  if (rook.ptypeO() != newPtypeO(alt(P), ROOK))
    return false;  
  if (! testDirection<R>(state, back_position))
    return false;
  if (! testDirection<L>(state, back_position))
    return false;

  const Player Opponent = PlayerTraits<P>::opponent;
  for (Square p=back_position+DirectionPlayerTraits<D,P>::offset();;
       p+=DirectionPlayerTraits<D,P>::offset())
  {
    const Piece focus = state.pieceAt(p);
    if (! focus.canMoveOn<Opponent>())
      break;

    if (focus.isOnBoardByOwner<P>())
      return state.hasEffectAt<P>(p);
    assert(focus.isEmpty());
    if (state.hasEffectAt<P>(p))
      continue;
    if (p.canPromote<Opponent>())
      return false;
  }
  return true;
}
namespace osl
{
  namespace move_classifier
  {
    template struct TrapRook<BLACK>;
    template struct TrapRook<WHITE>;
  }
} // namespace osl

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
