/* doUndoMoveLockTest.h
 */
#ifndef _DOUNDOMOVELOCKTEST_H
#define _DOUNDOMOVELOCKTEST_H

#include "osl/state/historyState.h"
#include "osl/move.h"
#include "osl/stl/vector.h"
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>

namespace osl
{
  template <class State>
  struct DoUndoMoveLockTest
  {
    State& state;
    HistoryState stateByLock;
    const vector<Move>& moves;
    size_t depth, limit;
    bool verbose;
    DoUndoMoveLockTest(State& s, const vector<Move>& m, bool v=false)
      : state(s), stateByLock(s), moves(m), depth(0), verbose(v)
    {
    }
    struct Helper
    {
      DoUndoMoveLockTest *tester;
      Helper(DoUndoMoveLockTest *t) : tester(t)
      {
      }
      void operator()(Position /*last_to*/)
      {
	++tester->depth;
	tester->runRecord();
      }
    };
    void run()
    {
      for (limit=1; limit<=moves.size(); limit+=(verbose ? 1 : moves.size()))
      {
	runRecord();
	if (verbose)
	  std::cerr << "pass " << limit << "\n";
      }
      if (limit < moves.size())
      {
	limit = moves.size();
	runRecord();
      }
    }
    void runRecord()
    {
      CPPUNIT_ASSERT(state.isConsistent(true) ||
		     (std::cerr << "stateInconsistent " <<
		      state << std::endl <<
		      stateByLock << std::endl,0)
		     );
      CPPUNIT_ASSERT(stateByLock.state().isConsistent(true) ||
		     (std::cerr << "stateInconsistent " <<
		      state << std::endl <<
		      stateByLock << std::endl,0)
		     );
      CPPUNIT_ASSERT_EQUAL((const NumEffectState&)state, stateByLock.state());
      if (depth >= limit)
	return;
      {
	if (verbose)
	  std::cerr << ">> " << depth << " " << moves[depth] << "\n";
	DoUndoMoveLock lock(stateByLock, moves[depth]);
	Helper helper(this);
	ApplyMoveOfTurn::doUndoMove(state, moves[depth], helper); // ここでdepth 増える
	--depth;
	if (verbose)
	  std::cerr << "<< " << depth << "\n";
      }
      CPPUNIT_ASSERT(state.isConsistent(true));
      CPPUNIT_ASSERT(stateByLock.state().isConsistent(true) ||
		     (std::cerr << "stateInconsistent " <<
		      state << std::endl <<
		      stateByLock << std::endl,0)
		     );
      CPPUNIT_ASSERT_EQUAL(static_cast<const NumEffectState&>(state), stateByLock.state());
    }
  };
}

#endif /* _DOUNDOMOVELOCKTEST_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
