/* positionCompressor.h
 */
#ifndef _POSITIONCOMPRESSOR_H
#define _POSITIONCOMPRESSOR_H

#include "osl/position.h"
#include "osl/misc/carray.h"
namespace osl
{

  /**
   * Position を [0..81] に圧縮する
   * 0: 駒台，1..81 盤上
   */
  struct PositionCompressor
  {
  private:
    /** 本当はconst にしたいけど初期化が手間なので後回し */
    static CArray<signed char, Position::SIZE> positionToIndex;
  public:
    class Initializer;
    friend class Initializer;

    static int compress(Position pos)
    {
      const int result = positionToIndex[pos.index()];
      assert(result >= 0);
      return result;
    }
    static Position
#ifdef __GNUC__
__attribute__ ((noinline))
#endif
      melt(int index)
    {
      assert(0 <= index);
      assert(index < 82);
      if (index == 0)
	return Position::STAND();
      --index;
      return Position(index/9+1, index%9+1);
    }
  };

} // namespace osl

#endif /* _POSITIONCOMPRESSOR_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
