#!/usr/bin/perl -w



# choice {cpp,h}
my $arg = $ARGV[0];
if(!defined($arg)) {
    print STDERR "No argument. Pass either cpp or h. Aborted\n";
    exit 1;
}
else {
    shift;
}
if($arg eq "-cpp") {
    print "/* autogenerated do not edit */\n";
    print "#include \"testsuitetags.h\"\n";
    print "const xml::tag_map_definition_t  testsuitetags[] = { \n";
    
    my $enumvalue = 1;
    while(<>) {
	chomp($_);
	print "{ \"$_\" , XML_" . $_ . " },\n";
	$enumvalue++;
    }
    print "{ 0, 0 }\n";
    print "};\n";
}
elsif($arg eq "-h") {
    
    print "/* autogenerated do not edit */\n";
    print "#ifndef __TESTSUITE_TAGS_H__\n";
    print "#define __TESTSUITE_TAGS_H__\n";
    print "#include \"xmlhandler.h\"\n";
    print "extern const xml::tag_map_definition_t  testsuitetags[];\n";
    print "enum {\n";
    
    my $enumvalue = 1;
    
    while(<>) {
	chomp($_);
	print "XML_" . $_ ." = $enumvalue,\n";
	$enumvalue++;
    }

    print "_XML_LASTTOKEN\n";
    print "};\n";
    print "#endif\n";
}
else {
    print "pass either cpp or h. Aborted\n";
    exit 1;
}
