/***************************************************************************
  $RCSfile: mediumpluginfile.cpp,v $
  -------------------
  cvs         : $Id: mediumpluginfile.cpp,v 1.4 2003/05/11 16:56:09 aquamaniac Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "mediumpluginfile.h"
//#include <openhbci/mediumplugin.h>
#include <openhbci/api.h>
//#include <openhbci/libloader.h>
#include <openhbci/error.h>


namespace HBCI {



MediumPluginFile::MediumPluginFile(const string &name, const string &prefix)
  :PluginFile(name, prefix)
{
  try {
    _createPlugin = (CREATE_PLUGIN_PTR)(resolve("createPlugin"));
  }
  catch (Error xerr) {
    throw Error("MediumPluginFile::MediumPluginFile", xerr);
  }
  if (_createPlugin==0)
    throw Error("MediumPluginFile::MediumPluginFile()",
		ERROR_LEVEL_NORMAL,
		HBCI_ERROR_CODE_LIBRARY,
		ERROR_ADVISE_ABORT,
		"error resolving symbol",
		"createPlugin");
}


MediumPluginFile::~MediumPluginFile(){
}


Pointer<MediumPlugin> MediumPluginFile::createMediumPlugin(const API *api){
  return (_createPlugin)(api);
}







}; // namespace





