/***************************************************************************
 $RCSfile: loader.h,v $
                             -------------------
    cvs         : $Id: loader.h,v 1.4 2003/05/29 20:09:32 aquamaniac Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef HBCILOADER_H
#define HBCILOADER_H

#include <string>
#include <list>
#include <openhbci/dllimport.h>
#include <openhbci/simpleconfig.h>

namespace HBCI {
  class Loader;
}
/**
 * Flags for loading ans saving
 */
enum {
    HBCILOADER_WITH_TRANSACTIONS=1,
    HBCILOADER_WITH_MESSAGES=2,
    HBCILOADER_DEFAULT=HBCILOADER_WITH_TRANSACTIONS|
    HBCILOADER_WITH_MESSAGES
};

#include <openhbci/api.h>

namespace HBCI {

/**
 * This class saves and loads all OpenHCBI data and is called from HBCIAPI.
 * @short Saves and loads all OpenHCBI data and is called from HBCIAPI.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT Loader{
  API *_hbci;

private:

public:
  Loader(API *hbci);
  ~Loader();

  static Error saveTransaction(const Transaction &t,
			       SimpleConfig &cfg,
			       cfgPtr where);

  Error saveUpdJob(const updJob &j,
		   SimpleConfig &cfg,
		   cfgPtr group2);
  Error saveAccountParams(Pointer<Account> a,
			  SimpleConfig &cfg,
			  cfgPtr group1);
  Error saveBalance(const Balance &b,
		    SimpleConfig &cfg,
		    cfgPtr where);
  Error saveAccountBalance(const AccountBalance &b,
			   SimpleConfig &cfg,
			   cfgPtr where);
  Error saveStandingOrder(const StandingOrder &o,
			  SimpleConfig &cfg,
			  cfgPtr where);
  Error saveAccount(Pointer<Account> a,
		    SimpleConfig &cfg,
		    cfgPtr where,
		    unsigned int flags=HBCILOADER_DEFAULT);
  Error saveCustomer(Pointer<Customer> c,
		     SimpleConfig &cfg,
		     cfgPtr where);
  Error saveUser(Pointer<User> c,
		 SimpleConfig &cfg,
		 cfgPtr where);
  Error saveBankJob(const bpdJob &b,
		    SimpleConfig &cfg,
		    cfgPtr w);
  Error saveBankParams(Pointer<Bank> b,
		       SimpleConfig &cfg,
		       cfgPtr where);
  Error saveInstituteMessage(const instituteMessage &msg,
			     SimpleConfig &cfg,
			     cfgPtr w);
  Error saveBank(Pointer<Bank> b,
		 SimpleConfig &cfg,
		 cfgPtr where,
		 unsigned int flags=HBCILOADER_DEFAULT);
  Error saveAll(SimpleConfig &cfg,
		cfgPtr where,
		unsigned int flags=HBCILOADER_DEFAULT);


  static Error loadTransaction(Transaction &t,
			       SimpleConfig &cfg,
			       cfgPtr w);
  Error loadBalance(Balance &b,
		    SimpleConfig &cfg,
		    cfgPtr w);
  Error loadAccountBalance(AccountBalance &ab,
			   SimpleConfig &cfg,
			   cfgPtr w);
  Error loadUpdJob(Pointer<Account> a,
		   SimpleConfig &cfg,
		   cfgPtr w);
  Error loadAccountParams(Pointer<Account> a,
			  SimpleConfig &cfg,
			  cfgPtr w);
  Error loadStandingOrder(StandingOrder &o,
			  SimpleConfig &cfg,
			  cfgPtr w);
  Error loadAccount(Pointer<Bank> b,
		    SimpleConfig &cfg,
		    cfgPtr w,
		    unsigned int flags=HBCILOADER_DEFAULT);
  Error loadCustomer(Pointer<User> u,
		     Pointer<Customer> &cu,
		     SimpleConfig &cfg,
		     cfgPtr w);
  Error loadUser(Pointer<Bank> b,
		 SimpleConfig &cfg,
		 cfgPtr w);
  Error loadBankJob(Pointer<Bank> b,
		    SimpleConfig &cfg,
		    cfgPtr w);
  Error loadBankParams(Pointer<Bank> b,
		       SimpleConfig &cfg,
		       cfgPtr w);
  Error loadInstituteMessage(instituteMessage &msg,
			     SimpleConfig &cfg,
			     cfgPtr w);
  Error loadBank(SimpleConfig &cfg,
		 cfgPtr w,
		 unsigned int flags=HBCILOADER_DEFAULT);
  Error loadAll(SimpleConfig &cfg,
		cfgPtr w,
		unsigned int flags=HBCILOADER_DEFAULT);

  Error writeTransactionFile(const string &name,
			     const list<Transaction> &xactions);
  Error readTransactionFile(const string &name,
			    list<Transaction> &xactions);

  Error writeStandingOrderFile(const string &name,
			       const list<StandingOrder> &sto);
  Error readStandingOrderFile(const string &name,
			      list<StandingOrder> &sto);


};


} /* namespace HBCI */


#endif
