/***************************************************************************
 $RCSfile: inetaddress.cpp,v $
 -------------------
 cvs         : $Id: inetaddress.cpp,v 1.6 2002/12/27 23:06:54 aquamaniac Exp $
 begin       : Wed Dec 12 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : martin@aquamaniac.de
 */


/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include "inetaddress.h"


namespace HBCI {

InetAddress::InetAddress(){
    // make address
    _inaddr.sin_family=PF_INET;
    if (!::inet_aton("0.0.0.0",&_inaddr.sin_addr))
        // no error should occur
        throw Error("InetAddress::InetAddress()",
                      ERROR_LEVEL_NORMAL,
                      0,
                      ERROR_ADVISE_DONTKNOW,
                      "bad addr");
    _inaddr.sin_port=htons(0);
}


InetAddress::InetAddress(string addr){
    // make address
    _inaddr.sin_family=PF_INET;
    if (!::inet_aton(addr.c_str(),&_inaddr.sin_addr)) {
        struct hostent *he;

        he=::gethostbyname(addr.c_str());
        if (!he)
            throw Error("InetAddress::InetAddress(addr)",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "unknown host");
        memcpy(&(_inaddr.sin_addr),he->h_addr_list[0],sizeof(in_addr));
    }
    _inaddr.sin_port=htons(0);
}


InetAddress::~InetAddress(){
}


string InetAddress::address() const {
    return ::inet_ntoa(_inaddr.sin_addr);
}


string InetAddress::name() {
    struct hostent *he;
    in_addr ia;

    if (_name.empty()) {
        ia=_inaddr.sin_addr;
        he=gethostbyaddr((char*)&ia,sizeof(ia),PF_INET);
        if (!he)
            throw Error("InetAddress::name()",
                          ERROR_LEVEL_NORMAL,
                          0,
                          ERROR_ADVISE_DONTKNOW,
                          "unknown host");
        _name=he->h_name;
    }
    return _name;
}

} /* namespace HBCI */


