/***************************************************************************
  $RCSfile: libloader.h,v $
  -------------------
  cvs         : $Id: libloader.h,v 1.5 2003/05/11 19:47:19 aquamaniac Exp $
  begin       : Sun Mar 10 2002
  copyright   : (C) 2002 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */

#ifndef LIBLOADER_H
#define LIBLOADER_H

#include <openhbci/dllimport.h>
#include <openhbci/error.h>

#ifdef __cplusplus
#include <string>
using namespace std;

#ifdef OS_WIN32
# include <windows.h>
#endif

namespace HBCI {


/**
 * This class handles loading of dynamic libraries (DLL, libXYZ.so)
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT LibLoader {
private:
  void *_handle;
  string _name;
  string _prefix;

  void *_resolve(const string &symbol);

public:
  /**
   * Constructor.
   * @author Martin Preuss<martin@libchipcard.de>
   * @param libname path and name of the library to load.
   */
  LibLoader(const string &libname, const string &prefix="");

  virtual ~LibLoader();

  /**
   * Actually loads the library thus making it's symbols resolveable.
   * @author Martin Preuss<martin@libchipcard.de>
   * @return false on error, true otherwise
     */
  Error openLibrary();

  /**
   * Unloads the library.
   * @author Martin Preuss<martin@libchipcard.de>
   * @return false on error, true otherwise
   */
  Error closeLibrary();

  /**
   * Resolves the address of a symbol.
   * @author Martin Preuss<martin@libchipcard.de>
   * @return address of the symbol (or 0 on error)
   * @param symbol name of the symbol to resolve.
   */
  void *resolve(const string &symbol);

  /**
   * Returns the path and name of the library (given to the constructor).
   * @author Martin Preuss<martin@libchipcard.de>
   */
  string libraryName() const ;
};


};
#endif /* __cplusplus */


#endif
