/***************************************************************************
 $RCSfile: account.cpp,v $
 -------------------
 cvs         : $Id: account.cpp,v 1.8 2003/07/28 20:43:58 cstim Exp $
 begin       : Thu Nov 29 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : openhbci@aquamaniac.de


 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#include "account.h"

namespace HBCI {

Account::Account(){
}


Account::~Account(){
}

} // namespace HBCI

const HBCI_Bank* HBCI_Account_bank(const HBCI_Account *h)
{
    assert(h);
    return h->bank().ptr();
}
int HBCI_Account_managed(const HBCI_Account *h)
{
    assert(h);
    return h->managed();
}
void HBCI_Account_setManaged(HBCI_Account *h, int m)
{
    assert(h);
    h->setManaged(m);
}
const list_HBCI_Customer* 
HBCI_Account_authorizedCustomers(const HBCI_Account *h)
{
    assert(h);
    return &(h->authorizedCustomers());
}
int HBCI_Account_isAuthorized(const HBCI_Account *h, 
			     const HBCI_Customer *c)
{
    assert(h);
    assert(c);
    // Unfortunately we don't have a const-Pointer, so we have to
    // cast away the const here. Note that the const is still valid
    // (according to the code in HBCI_AccountImpl), we just can't write
    // it down here with a Pointer. 
    HBCI::Pointer<HBCI::Customer> pc = const_cast<HBCI::Customer*>(c);
    pc.setAutoDelete(false);
    return h->isAuthorized(pc);
}
extern HBCI_Error *
HBCI_Account_addAuthorizedCustomer(HBCI_Account *h,
				   const HBCI_Customer *c)
{
    assert(h);
    assert(c);
    HBCI::Pointer<HBCI::Customer> cp = const_cast<HBCI::Customer*>(c);
    cp.setAutoDelete(false);
    try {
	h->addAuthorizedCustomer(cp);
	return 0;
    }
    catch(HBCI_Error err) {
	return new HBCI_Error(err);
    }
}

const char* HBCI_Account_accountId(const HBCI_Account* h)
{
    assert(h);
    return h->accountId().c_str();
}
const char* HBCI_Account_accountSuffix(const HBCI_Account* h)
{
    assert(h);
    return h->accountSuffix().c_str();
}
const char* HBCI_Account_instituteCode(const HBCI_Account* h)
{
    assert(h);
    return h->instituteCode().c_str();
}
int HBCI_Account_countryCode(const HBCI_Account* h)
{
    assert(h);
    return h->countryCode();
}
const char* HBCI_Account_accountName(const HBCI_Account* h)
{
    assert(h);
    return h->accountName().c_str();
}
const char* HBCI_Account_name1(const HBCI_Account* h)
{
    assert(h);
    return h->name1().c_str();
}
const char* HBCI_Account_name2(const HBCI_Account* h)
{
    assert(h);
    return h->name2().c_str();
}
const char* HBCI_Account_currency(const HBCI_Account* h)
{
    assert(h);
    return h->currency().c_str();
}
const HBCI_Limit *HBCI_Account_limit(HBCI_Account *h)
{
    assert(h);
    return &(h->limit());
}



void list_HBCI_Account_delete(list_HBCI_Account *l)
{
    delete l;
}
void list_HBCI_Account_iter_delete(list_HBCI_Account_iter *l)
{
    delete l;
}
int list_HBCI_Account_size(const list_HBCI_Account *l)
{
    assert(l);
    return l->size();
}
list_HBCI_Account_iter* list_HBCI_Account_begin(const list_HBCI_Account *l)
{
    assert(l);
    return new list_HBCI_Account_iter(l->begin());
}
list_HBCI_Account_iter* list_HBCI_Account_end(const list_HBCI_Account *l)
{
    assert(l);
    return new list_HBCI_Account_iter(l->end());
}
const HBCI_Account *
list_HBCI_Account_iter_get(const list_HBCI_Account_iter *l)
{
    assert(l);
    return (**l).ptr();
}
void list_HBCI_Account_iter_next(list_HBCI_Account_iter *l)
{
    assert(l);
    l->operator++();
}
int list_HBCI_Account_iter_equal(const list_HBCI_Account_iter *l1, 
				 const list_HBCI_Account_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_Account_foreach (const list_HBCI_Account *list, 
				 list_HBCI_Account_cb func,
				 void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_Account_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}



