MODULE VO:StringPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT V   := VO:Model:Value,
       PP  := VO:Prefs:Parser,

       BO  := VO:Bool,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       S   := VO:String,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                gridDisable : V.BoolModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="String";

    d.SetPrefs(S.prefs);
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    bool   : BO.Bool;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreateVPanel();

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        label:=L.CreateLabel();
          
          d.gridDisable:=V.CreateBoolModel();
          d.gridDisable.SetBoolean(S.prefs.gridDisable);

          bool:=BO.CreateBool();
          bool.SetModel(d.gridDisable);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("disable with grid",bool);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.gridDisable.SetBoolean(S.prefs.gridDisable);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    S.prefs.gridDisable:=p.gridDisable.GetBoolean();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    S.prefs.gridDisable:=top.GetBoolEntry("gridDisable",S.prefs.gridDisable);
    S.prefs.baseline:=top.GetBoolEntry("gridDisable",S.prefs.baseline);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemBool("gridDisable",S.prefs.gridDisable);
    block.AddItemBool("baseline",S.prefs.baseline);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:StringPrefs.