(**
   A simple led with two states: on and off.
**)

MODULE VO:LED;

(*
    Implements a simple led with two states: on and off.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT G  := VO:Object,
       S  := VO:State,
       VI := VO:VecImage;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
                 image* : LONGINT;
               END;


  LED*     = POINTER TO LEDDesc;
  LEDDesc* = RECORD (S.StateDesc)
             END;

VAR
  prefs* : Prefs;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;

    p.image:=VI.led;
  END Init;

  PROCEDURE (l : LED) Init*;

  BEGIN
    l.Init^;

    l.SetPrefs(prefs);
    l.SetImage(l.prefs(Prefs).image);
    (* We do that for stopping interactive toggling via keyboard or mouse *)
    l.Disable(TRUE);
  END Init;

  PROCEDURE CreateLED*():LED;

  VAR
    led : LED;

  BEGIN
    NEW(led);
    led.Init;

    RETURN led;
  END CreateLED;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:LED.