(**
  A demo for the VOClock class. This little clock is really useable and
  is used by the author as part of its fvwm2 button pannel.
**)

MODULE Clock;

(*
    Demo for VisualOberon. Shows the current time.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,
       Z   := VO:Base:Size,

              VO:Prefs:All,  (* Include preferences for all objects *)

       C   := VO:Clock,
       G   := VO:Object,
       Q   := VO:QuickHelp,
       T   := VO:Text,
       W   := VO:Window,

              Err,
       L   := Locales;

TYPE
  Window     = POINTER TO WindowDesc;
  WindowDesc = RECORD (W.WindowDesc)
               END;

VAR
  w        : Window;

  msg2Exit : D.Msg2Exit;

  old      : ARRAY 32 OF CHAR;

  PROCEDURE (w : Window) PreInit*;

  VAR
    clock : C.Clock;

  BEGIN
    NEW(clock);
    clock.Init;
    clock.SetFlags({G.horizontalFlex,G.verticalFlex});
    clock.SetWidth(Z.screenHRel,25);
    clock.SetHeight(Z.screenVRel,25);
    clock.SetHelpObject(Q.InitHelp(T.MakeLeftText("\ecClock\n@ 1997, Tim Teulings\nwritten with VisualOberon"),clock));
    clock.ShowFrame(FALSE);

    w.SetTop(clock);

    w.PreInit^;
  END PreInit;


BEGIN
  D.display.SetAppName("Clock");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  L.Set(L.ALL,"",old);  (* use env variables *)

  NEW(w);
  w.Init;
  w.SetTitle("Clock");

  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);

  w.Open;

  D.display.EventLoop;

  D.display.Close;
END Clock.