package ru.novosoft.uml.gen;
import java.io.*;
import java.util.*;
import ru.novosoft.uml.gen.mmm.*;

public class GenMMWriter extends PrintWriter
{
  public static final String bag = "Collection";
  public static final String list = "List";
  public static final String ibag = "ArrayList";
  public static final String ilist = "ArrayList";

  public GenMMWriter(GenMM generator, String pkg, String file)  throws IOException
  {
    super(new FileWriter(generator.getFileName(pkg, file)));
    this.generator=generator;
  }

  int identLevel=0;
  String identString = "  ";
  GenMM generator;
  public GenMM getGenerator()
  {
    return generator;
  }
 

  int iterNum = 0;

  public void prolog()
  {
    line("/* "+GenMM.VERSION);
    line(" * Copyright (C) 1999, 2000, NovoSoft.");
    line(" * This library is free software; you can redistribute it and/or");
    line(" * modify it under the terms of the GNU Library General Public");
    line(" * License as published by the Free Software Foundation; either");
    line(" * version 2 of the License, or (at your option) any later version.");
    line(" * This library is distributed in the hope that it will be useful,");
    line(" * but WITHOUT ANY WARRANTY; without even the implied warranty of");
    line(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU");
    line(" * Library General Public License for more details.");
    line(" *");
    line(" * You should have received a copy of the GNU Library General Public");
    line(" * License along with this library; if not, write to the");
    line(" * Free Software Foundation, Inc., 59 Temple Place - Suite 330,");
    line(" * Boston, MA  02111-1307, USA. The text of license can be also found ");
    line(" * at http://www.gnu.org/copyleft/lgpl.html");
    line(" */");
    line();
  }

  public void line()
  {
    sline();
    println();
  }
  public void line(String s)
  {
    sline();
    println(s);
  }
  
  public void sline()
  {
    for(int i = 0; i<identLevel; i++)
    {
      print(identString);
    }
  }

  public void sline(String s)
  {
    sline();
    print(s);
  }

  public void ident()
  {
    identLevel++;
  }
  public void unident()
  {
    identLevel--;
  }

  public void iline(String s)
  {
    ident();
    line(s);
  }
  public void uline(String s)
  {
    unident();
    line(s);
  }

  public void iline()
  {
    ident();
    line();
  }
  public void uline()
  {
    unident();
    line();
  }
  
  public void sblock()
  {
    line("{");
    ident();
  }

  public void eblock()
  {
    uline("}");
  }
  

  public void sfor(String arg)
  {
    line("for ("+arg+")");
    sblock();
  }
  public void efor()
  {
    eblock();
  }

  public void sif(String arg)
  {
    line("if ("+arg+")");
    sblock();
  }
  public void eif()
  {
    eblock();
  }
  
  public void swhile(String arg)
  {
    line("while ("+arg+")");
    sblock();
  }
  public void ewhile()
  {
    eblock();
  }

  public void sdo()
  {
    line("do");
    sblock();
  }
  public void edo(String arg)
  {
    eblock();
    line("while ("+arg+")");
  }

  public void sforeach(String col, String type, String obj)
  {
    iterNum++;
    String ivar = "iter"+iterNum;
    line("Iterator "+ivar+" = "+col+".iterator();");
    swhile(ivar+".hasNext()");
    line(type+" "+obj+" = ("+type+")"+ivar+".next();");
  }
  public void eforeach()
  {
    ewhile();
  }
  //String name(MClass c)
  public static String cname(MClass c)
  {
    String nm = c.getName();
    if (c instanceof MPrimitive)
    {
      if (nm.equals("Integer"))
      {
        return "int";
      }
      else if (nm.equals("UnlimitedInteger"))
      {
        return "int";
      }
      else if (nm.equals("Boolean"))
      {
        return "boolean";
      }
      else if (nm.equals("Name"))
      {
        return "String";
      }
      else if (nm.equals("Uninterpreted"))
      {
        return "String";
      }
      else if (nm.equals("Time"))
      {
        return "Date";
      }
      else if (nm.equals("Geometry"))
      {
        return "String";
      }
      else if (nm.equals("Mapping"))
      {
        return "String";
      }
      else if (nm.equals("LocationReference"))
      {
        return "String";
      }
      else if (nm.equals("String"))
      {
        return "String";
      }
      else
      {
        System.out.println("ERROR: Unresolved primitive type : "+nm);
        return "<<"+nm+">>";
      }
    }
    return "M"+nm;
  }
  // implementation name
  public static String iname(MClass c)
  {
    return "M"+c.getName()+"Impl";
  }
  public String vname(String name)
  {
    return "_"+name;
  }

  public void generateCustomCode()
  {
    // insert getting custom code here
  }

  public String asetterName(MAttribute at)
  {
    String nm = at.getName();
    if (at.getType().getName().equals("Boolean"))
    {
      if (nm.startsWith("is"))
      {
        return "set"+uname(nm.substring(2));
      }
      return "set"+uname(nm);
    }
    return "set"+uname(nm);
  }

  public String rsetterName(MRole r)
  {
    return "set"+uname(r.getName());
  }
  public String bsetterName(MRole r)
  {
    return "set"+uname(getPlural(r.getName()));
  }

  public String badderName(MRole r)
  {
    return "add"+uname(r.getName());
  }
  public String bremoverName(MRole r)
  {
    return "remove"+uname(r.getName());
  }
  
  public String lsetterName(MRole r)
  {
    return "set"+uname(r.getName());
  }
  public String ladderName(MRole r)
  {
    return "add"+uname(r.getName());
  }
  public String lremoverName(MRole r)
  {
    return "remove"+uname(r.getName());
  }

  public String agetter(MAttribute at)
  {
    String nm = at.getName();
    if (at.getType().getName().equals("Boolean"))
    {
      if (nm.startsWith("is"))
      {
        return nm+"()";
      }
      else if (nm.startsWith("has"))
      {
        return nm+"()";
      }
      return "is"+uname(nm)+"()";
    }
    return "get"+uname(nm)+"()";
  }
  public String asetter(MAttribute at, String arg)
  {
    String nm = at.getName();
    if (at.getType().getName().equals("Boolean"))
    {
      if (nm.startsWith("is"))
      {
        return "set"+uname(nm.substring(2))+"("+arg+")";
      }
      return "set"+uname(nm)+"("+arg+")";
    }
    return "set"+uname(nm)+"("+arg+")";
  }

  public String rgetter(MRole r)
  {
    return "get"+uname(r.getName())+"()";
  }
  public String rsetter(MRole r, String arg)
  {
    return "set"+uname(r.getName())+"("+arg+")";
  }


  public String bgetter(MRole r)
  {
    return "get"+uname(getPlural(r.getName()))+"()";
  }
  public String bsetter(MRole r, String arg)
  {
    return "set"+uname(getPlural(r.getName()))+"("+arg+")";
  }

  public String badder(MRole r, String arg)
  {
    return "add"+uname(r.getName())+"("+arg+")";
  }
  public String bremover(MRole r, String arg)
  {
    return "remove"+uname(r.getName())+"("+arg+")";
  }
  
  public String lsetter(MRole r, String parg, String varg)
  {
    return "set"+uname(r.getName())+"("+parg+", "+varg+")";
  }
  public String lgetter(MRole r, String parg)
  {
    return "get"+uname(r.getName())+"("+parg+")";
  }
  public String ladder(MRole r, String parg, String varg)
  {
    return "add"+uname(r.getName())+"("+parg+", "+varg+")";
  }
  public String lremover(MRole r, String parg)
  {
    return "remove"+uname(r.getName())+"("+parg+")";
  }
  public String unref(MRole r, String arg)
  {
    return "internalUnrefBy"+uname(r.getName())+"("+arg+")";
  }
  public String ref(MRole r, String arg)
  {
    return "internalRefBy"+uname(r.getName())+"("+arg+")";
  }
  public String refThis(MRole r, String o)
  {
    return o+"."+ref(r, "this")+";";
  }
  public String unrefThis(MRole r, String o)
  {
    return o+"."+unref(r, "this")+";";
  }
  
  public MRole oppositeRole(MRole tr)
  {
    MAssociation a = tr.getAssociation();
    List rs = a.getRoles();
    rs.remove(tr);
    return (MRole)rs.get(0);
  }

  public void importCollections()
  {
    sline("import "); print(generator.getCollectionsPackage()); println(".List;");
    sline("import "); print(generator.getCollectionsPackage()); println(".ArrayList;");
    sline("import "); print(generator.getCollectionsPackage()); println(".Collection;");
    sline("import "); print(generator.getCollectionsPackage()); println(".Collections;");
    sline("import "); print(generator.getCollectionsPackage()); println(".Iterator;");
  }

  public void imports(MClass c)
  {
    importCollections();
    println();

    ArrayList lst = new ArrayList();
    lst.add(GenMM.ROOT_PACKAGE);
    lst.add(GenMM.ROOT_PACKAGE+".foundation.core");
    lst.add(GenMM.ROOT_PACKAGE+".foundation.data_types");
    lst.add(GenMM.ROOT_PACKAGE+".foundation.extension_mechanisms");
    lst.add(GenMM.ROOT_PACKAGE+".behavior.common_behavior");
    lst.add(GenMM.ROOT_PACKAGE+".behavior.collaborations");
    lst.add(GenMM.ROOT_PACKAGE+".behavior.use_cases");
    lst.add(GenMM.ROOT_PACKAGE+".behavior.state_machines");
    lst.add(GenMM.ROOT_PACKAGE+".behavior.activity_graphs");
    lst.add(GenMM.ROOT_PACKAGE+".model_management");
    
    
    lst.remove(getPackage(c));
    Iterator i = lst.iterator();
    while (i.hasNext())
    {
      line("import "+i.next()+".*;");
    }
  }

  public static String getPackage(MClass c)
  {
    //if (c.getName().equals("Element"))
    //{
    //  return GenMM.ROOT_PACKAGE;
    //}
    if (c.getPackage().getName().equals("root"))
    {
      return GenMM.ROOT_PACKAGE;
    }
    if (c.getPackage().getName().equals("Core"))
    {
      return GenMM.ROOT_PACKAGE+".foundation.core";
    }
    if (c.getPackage().getName().equals("Data_Types"))
    {
      return GenMM.ROOT_PACKAGE+".foundation.data_types";
    }
    if (c.getPackage().getName().equals("Extension_Mechanisms"))
    {
      return GenMM.ROOT_PACKAGE+".foundation.extension_mechanisms";
    }
    if (c.getPackage().getName().equals("Common_Behavior"))
    {
      return GenMM.ROOT_PACKAGE+".behavior.common_behavior";
    }
    if (c.getPackage().getName().equals("Collaborations"))
    {
      return GenMM.ROOT_PACKAGE+".behavior.collaborations";
    }
    if (c.getPackage().getName().equals("Use_Cases"))
    {
      return GenMM.ROOT_PACKAGE+".behavior.use_cases";
    }
    if (c.getPackage().getName().equals("State_Machines"))
    {
      return GenMM.ROOT_PACKAGE+".behavior.state_machines";
    }
    if (c.getPackage().getName().equals("Activity_Graphs"))
    {
      return GenMM.ROOT_PACKAGE+".behavior.activity_graphs";
    }
    if (c.getPackage().getName().equals("Model_Management"))
    {
      return GenMM.ROOT_PACKAGE+".model_management";
    }
    System.out.println("ERROR: Unrecognized package name: "+c.getPackage().getName());
    return "<<illegal>>";
  }

  protected static String uname(String a)
  {
    if (a.length()>0)
    {
      return a.substring(0,1).toUpperCase()+a.substring(1);
    }
    else
    {
      return a;
    }
  }


  public String getPlural(String a)
  {
    return generator.getPlural(a);
  }

  public InputStream getResourceAsStream(String p_sPackage, String p_sFilename) throws IOException
  {
    if (p_sPackage.equals(""))
    {
      return generator.getClass().getResourceAsStream(
        generator.RESOURCE_ROOT + "/" + p_sFilename
      );
    }
    return generator.getClass().getResourceAsStream(
      generator.RESOURCE_ROOT + "/" + p_sPackage.replace('.', '/') + '/' + p_sFilename
    );
  }

  public void appendResource(String p_sPackage, String p_sFilename) throws IOException
  {
    InputStream insAppend = generator.getClass().getResourceAsStream(
      generator.RESOURCE_ROOT + "/" + p_sPackage.replace('.', '/') + '/' + p_sFilename
    );

    if (null != insAppend)
    {
      BufferedReader bfr = new BufferedReader(new InputStreamReader(insAppend));
      String s = bfr.readLine();
      while (null != s)
      {
        println(s);
        s = bfr.readLine();
      }
    }
  }


  public static void getSuperclasses(MClass c, Set out)
  {
    if (null == c) 
    {
      return;
    }

    Iterator i = c.getSuperClasses().iterator();
    while (i.hasNext())
    {
      MClass sc = (MClass)i.next();
      out.add(sc);
      getSuperclasses(sc, out);
    }
  }
}


