#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <libnjb.h>

int progress(u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data);
void usage(void);

extern int njb_error;

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	int n, opt, debug;
	u_int32_t id, size;
	extern int optind;
	extern char *optarg;
	char *endptr;
	char *file;

	debug= 0;
	size= 0;
	while ( (opt= getopt(argc, argv, "D:s:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		case 's':
			size= strtoul(optarg, &endptr, 10);
			if ( *endptr != '\0' ) {
				fprintf(stderr, "illegal size value %s\n",
					optarg);
				return 1;
			}
			break;
		default:
			usage();
			return 1;
		}
	}
	argc-= optind;
	argv+= optind;

	if ( argc != 2 ) {
		usage();
		return 1;
	}

	id= strtoul(argv[0], &endptr, 10);
	if ( *endptr != 0 ) {
		fprintf(stderr, "illegal value %s\n", optarg);
		return 1;
	} else if ( ! id ) {
		fprintf(stderr, "bad song id %u\n", id);
		return 1;
	}

	file= argv[1];

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
	}
	if ( n == 0 ) {
		fprintf(stderr, "no NJB devices found\n");
		return 1;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	NJB_Capture(njb);

	if ( ! size ) {
		songid_t *tag;

		printf("Locating track %u\n", id);
		NJB_Reset_Get_Track_Tag(njb);
		while ( (tag= NJB_Get_Track_Tag(njb)) ) {
			if ( tag->trid == id ) {
				size= songid_size(tag);
			}
			songid_destroy(tag);
		}
		if ( njb_error != EO_EOM ) njb_error_dump(stderr);

		if ( size ) {
			printf("%u bytes\n", size);
		} else {
			fprintf(stderr, "Track %u not found\n", id);
		}
	}

	if ( size ) {
		if ( NJB_Get_Track(njb, id, size, file, progress, NULL) == -1 ) {
			njb_error_dump(stderr);
		}
		printf("\n");
	}

	NJB_Release(njb);

	NJB_Close(njb);

	return 0;
}

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data)
{
	int percent = (sent*100)/total;
	printf("Progress: %qu of %qu (%d%%)\r", sent, total, percent);
	fflush(stdout);
	return 0;
}

void usage (void)
{
	fprintf(stderr, "get [ -s size ] <trackid> <filename>\n");
}
